/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DateTimeTemplate {
    private static final SmallLRUCache<String, DateTimeTemplate> CACHE = SmallLRUCache.newInstance(100);
    private final Part[] parts;
    private final boolean containsDate;
    private final boolean containsTime;
    private final boolean containsTimeZone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTimeTemplate of(String template) {
        DateTimeTemplate old;
        SmallLRUCache<String, DateTimeTemplate> smallLRUCache = CACHE;
        synchronized (smallLRUCache) {
            DateTimeTemplate t = (DateTimeTemplate)CACHE.get(template);
            if (t != null) {
                return t;
            }
        }
        DateTimeTemplate t = DateTimeTemplate.parseTemplate(template);
        SmallLRUCache<String, DateTimeTemplate> smallLRUCache2 = CACHE;
        synchronized (smallLRUCache2) {
            old = CACHE.putIfAbsent(template, t);
        }
        return old != null ? old : t;
    }

    private static DateTimeTemplate parseTemplate(String template) {
        int usedFields;
        ArrayList<Delimiter> parts;
        block35: {
            block34: {
                int c;
                parts = new ArrayList<Delimiter>();
                Scanner s = new Scanner(template);
                usedFields = 0;
                while ((c = s.readChar()) >= 0) {
                    Part part;
                    switch (c) {
                        case 45: {
                            part = Delimiter.MINUS_SIGN;
                            break;
                        }
                        case 46: {
                            part = Delimiter.PERIOD;
                            break;
                        }
                        case 47: {
                            part = Delimiter.SOLIDUS;
                            break;
                        }
                        case 44: {
                            part = Delimiter.COMMA;
                            break;
                        }
                        case 39: {
                            part = Delimiter.APOSTROPHE;
                            break;
                        }
                        case 59: {
                            part = Delimiter.SEMICOLON;
                            break;
                        }
                        case 58: {
                            part = Delimiter.COLON;
                            break;
                        }
                        case 32: {
                            part = Delimiter.SPACE;
                            break;
                        }
                        case 89: {
                            usedFields = DateTimeTemplate.checkUsed(usedFields, 0, template);
                            if (s.readCharIf('Y')) {
                                if (s.readCharIf('Y')) {
                                    part = s.readCharIf('Y') ? Field.YYYY : Field.YYY;
                                    break;
                                }
                                part = Field.YY;
                                break;
                            }
                            part = Field.Y;
                            break;
                        }
                        case 82: {
                            usedFields = DateTimeTemplate.checkUsed(usedFields, 0, template);
                            s.readChar('R');
                            if (s.readCharIf('R')) {
                                s.readChar('R');
                                part = Field.RRRR;
                                break;
                            }
                            part = Field.RR;
                            break;
                        }
                        case 77: {
                            if (s.readCharIf('I')) {
                                usedFields = DateTimeTemplate.checkUsed(usedFields, 7, template);
                                part = Field.MI;
                                break;
                            }
                            s.readChar('M');
                            usedFields = DateTimeTemplate.checkUsed(usedFields, 2, template);
                            part = Field.MM;
                            break;
                        }
                        case 68: {
                            s.readChar('D');
                            if (s.readCharIf('D')) {
                                usedFields = DateTimeTemplate.checkUsed(usedFields, 4, template);
                                part = Field.DDD;
                                break;
                            }
                            usedFields = DateTimeTemplate.checkUsed(usedFields, 3, template);
                            part = Field.DD;
                            break;
                        }
                        case 72: {
                            s.readChar('H');
                            if (s.readCharIf('2')) {
                                s.readChar('4');
                                usedFields = DateTimeTemplate.checkUsed(usedFields, 6, template);
                                part = Field.HH24;
                                break;
                            }
                            if (s.readCharIf('1')) {
                                s.readChar('2');
                            }
                            usedFields = DateTimeTemplate.checkUsed(usedFields, 5, template);
                            part = Field.HH12;
                            break;
                        }
                        case 83: {
                            s.readChar('S');
                            if (s.readCharIf('S')) {
                                s.readChar('S');
                                s.readChar('S');
                                usedFields = DateTimeTemplate.checkUsed(usedFields, 9, template);
                                part = Field.SSSSS;
                                break;
                            }
                            usedFields = DateTimeTemplate.checkUsed(usedFields, 8, template);
                            part = Field.SS;
                            break;
                        }
                        case 70: {
                            s.readChar('F');
                            c = s.readChar();
                            if (c < 49 || c > 57) {
                                throw DbException.get(90014, template);
                            }
                            usedFields = DateTimeTemplate.checkUsed(usedFields, 10, template);
                            part = Field.ff(c - 48);
                            break;
                        }
                        case 65: 
                        case 80: {
                            s.readChar('.');
                            s.readChar('M');
                            s.readChar('.');
                            usedFields = DateTimeTemplate.checkUsed(usedFields, 11, template);
                            part = Field.AM_PM;
                            break;
                        }
                        case 84: {
                            s.readChar('Z');
                            if (s.readCharIf('H')) {
                                usedFields = DateTimeTemplate.checkUsed(usedFields, 12, template);
                                part = Field.TZH;
                                break;
                            }
                            if (s.readCharIf('M')) {
                                usedFields = DateTimeTemplate.checkUsed(usedFields, 13, template);
                                part = Field.TZM;
                                break;
                            }
                            s.readChar('S');
                            usedFields = DateTimeTemplate.checkUsed(usedFields, 14, template);
                            part = Field.TZS;
                            break;
                        }
                        default: {
                            throw DbException.get(90014, template);
                        }
                    }
                    parts.add((Delimiter)part);
                }
                if ((usedFields & 0x10) != 0 && (usedFields & 0xC) != 0) break block34;
                boolean bl = (usedFields & 0x20) != 0;
                boolean bl2 = (usedFields & 0x800) != 0;
                if (!(bl != bl2 || (usedFields & 0x40) != 0 && (usedFields & 0x20) != 0 || (usedFields & 0x200) != 0 && (usedFields & 0x1E0) != 0 || (usedFields & 0x4000) != 0 && (usedFields & 0x2000) == 0) && ((usedFields & 0x2000) == 0 || (usedFields & 0x1000) != 0)) break block35;
            }
            throw DbException.get(90014, template);
        }
        return new DateTimeTemplate(parts.toArray(new Part[0]), (usedFields & 0x1D) != 0, (usedFields & 0xBE0) != 0, (usedFields & 0x7000) != 0);
    }

    private static int checkUsed(int usedFields, int type, String template) {
        int newUsedFields = usedFields | 1 << type;
        if (usedFields == newUsedFields) {
            throw DbException.get(90014, template);
        }
        return newUsedFields;
    }

    private DateTimeTemplate(Part[] parts, boolean containsDate, boolean containsTime, boolean containsTimeZone) {
        this.parts = parts;
        this.containsDate = containsDate;
        this.containsTime = containsTime;
        this.containsTimeZone = containsTimeZone;
    }

    public String format(Value value) {
        int offsetSeconds;
        long nanoOfDay;
        long dateValue;
        switch (value.getValueType()) {
            case 0: {
                return null;
            }
            case 17: {
                if (this.containsTime || this.containsTimeZone) {
                    throw DbException.get(90014, "time or time zone fields with DATE");
                }
                dateValue = ((ValueDate)value).getDateValue();
                nanoOfDay = 0L;
                offsetSeconds = 0;
                break;
            }
            case 18: {
                if (this.containsDate || this.containsTimeZone) {
                    throw DbException.get(90014, "date or time zone fields with TIME");
                }
                dateValue = 0L;
                nanoOfDay = ((ValueTime)value).getNanos();
                offsetSeconds = 0;
                break;
            }
            case 19: {
                if (this.containsDate) {
                    throw DbException.get(90014, "date fields with TIME WITH TIME ZONE");
                }
                Value vt = (ValueTimeTimeZone)value;
                dateValue = 0L;
                nanoOfDay = ((ValueTimeTimeZone)vt).getNanos();
                offsetSeconds = ((ValueTimeTimeZone)vt).getTimeZoneOffsetSeconds();
                break;
            }
            case 20: {
                if (this.containsTimeZone) {
                    throw DbException.get(90014, "time zone fields with TIMESTAMP");
                }
                Value vt = (ValueTimestamp)value;
                dateValue = ((ValueTimestamp)vt).getDateValue();
                nanoOfDay = ((ValueTimestamp)vt).getTimeNanos();
                offsetSeconds = 0;
                break;
            }
            case 21: {
                Value vt = (ValueTimestampTimeZone)value;
                dateValue = ((ValueTimestampTimeZone)vt).getDateValue();
                nanoOfDay = ((ValueTimestampTimeZone)vt).getTimeNanos();
                offsetSeconds = ((ValueTimestampTimeZone)vt).getTimeZoneOffsetSeconds();
                break;
            }
            default: {
                throw DbException.getUnsupportedException(value.getType().getTraceSQL());
            }
        }
        StringBuilder builder = new StringBuilder();
        Part[] partArray = this.parts;
        int n = this.parts.length;
        int n2 = 0;
        while (n2 < n) {
            Part part = partArray[n2];
            part.format(builder, dateValue, nanoOfDay, offsetSeconds);
            ++n2;
        }
        return builder.toString();
    }

    public Value parse(String string, TypeInfo targetType, CastDataProvider provider) {
        switch (targetType.getValueType()) {
            case 17: {
                if (this.containsTime || this.containsTimeZone) {
                    throw DbException.get(90014, "time or time zone fields with DATE");
                }
                int[] yearMonth = DateTimeTemplate.yearMonth(provider);
                return ValueDate.fromDateValue(DateTimeTemplate.constructDate(this.parse(string, yearMonth[0]), yearMonth));
            }
            case 18: {
                if (this.containsDate || this.containsTimeZone) {
                    throw DbException.get(90014, "date or time zone fields with TIME");
                }
                return ValueTime.fromNanos(DateTimeTemplate.constructTime(this.parse(string, 0)));
            }
            case 19: {
                if (this.containsDate) {
                    throw DbException.get(90014, "date fields with TIME WITH TIME ZONE");
                }
                int[] target = this.parse(string, 0);
                return ValueTimeTimeZone.fromNanos(DateTimeTemplate.constructTime(target), DateTimeTemplate.constructOffset(target));
            }
            case 20: {
                if (this.containsTimeZone) {
                    throw DbException.get(90014, "time zone fields with TIMESTAMP");
                }
                int[] yearMonth = DateTimeTemplate.yearMonth(provider);
                int[] target = this.parse(string, yearMonth[0]);
                return ValueTimestamp.fromDateValueAndNanos(DateTimeTemplate.constructDate(target, yearMonth), DateTimeTemplate.constructTime(target));
            }
            case 21: {
                int[] yearMonth = DateTimeTemplate.yearMonth(provider);
                int[] target = this.parse(string, yearMonth[0]);
                return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeTemplate.constructDate(target, yearMonth), DateTimeTemplate.constructTime(target), DateTimeTemplate.constructOffset(target));
            }
        }
        throw DbException.getUnsupportedException(targetType.getTraceSQL());
    }

    private static int[] yearMonth(CastDataProvider provider) {
        long dateValue = provider.currentTimestamp().getDateValue();
        return new int[]{DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue)};
    }

    private int[] parse(String string, int year) {
        int[] target = new int[15];
        Arrays.fill(target, Integer.MIN_VALUE);
        Scanner s = new Scanner(string);
        int i = 0;
        int l = this.parts.length - 1;
        while (i <= l) {
            Part part = this.parts[i];
            part.parse(target, s, !(i != 0 && (1 << part.type() & 0x1800) == 0 && (1 << this.parts[i - 1].type() & 0x8800) == 0 || i != l && part.type() != 11 && (1 << this.parts[i + 1].type() & 0x9800) == 0), year);
            ++i;
        }
        return target;
    }

    private static long constructDate(int[] target, int[] yearMonth) {
        int day;
        int dayOfYear;
        int year = target[0];
        if (year == Integer.MIN_VALUE) {
            year = target[1];
        }
        if (year == Integer.MIN_VALUE) {
            year = yearMonth[0];
        }
        if ((dayOfYear = target[4]) != Integer.MIN_VALUE) {
            if (dayOfYear < 1 || dayOfYear > (DateTimeUtils.isLeapYear(year) ? 366 : 365)) {
                throw DbException.get(90014, "Day of year " + dayOfYear);
            }
            return DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromYear(year) + (long)dayOfYear - 1L);
        }
        int month = target[2];
        if (month == Integer.MIN_VALUE) {
            month = yearMonth[1];
        }
        if ((day = target[3]) == Integer.MIN_VALUE) {
            day = 1;
        }
        if (!DateTimeUtils.isValidDate(year, month, day)) {
            throw DbException.get(90014, "Invalid date, year=" + year + ", month=" + month + ", day=" + day);
        }
        return DateTimeUtils.dateValue(year, month, day);
    }

    private static long constructTime(int[] target) {
        int secondOfDay = target[9];
        if (secondOfDay == Integer.MIN_VALUE) {
            int hour = target[6];
            if (hour == Integer.MIN_VALUE) {
                hour = target[5];
                if (hour == Integer.MIN_VALUE) {
                    hour = 0;
                } else {
                    if (hour < 1 || hour > 12) {
                        throw DbException.get(90014, "Hour(12) " + hour);
                    }
                    if (hour == 12) {
                        hour = 0;
                    }
                    hour += target[11] * 12;
                }
            } else if (hour < 0 || hour > 23) {
                throw DbException.get(90014, "Hour(24) " + hour);
            }
            int minute = target[7];
            if (minute == Integer.MIN_VALUE) {
                minute = 0;
            } else if (minute < 0 || minute > 59) {
                throw DbException.get(90014, "Minute " + minute);
            }
            int second = target[8];
            if (second == Integer.MIN_VALUE) {
                second = 0;
            } else if (second < 0 || second > 59) {
                throw DbException.get(90014, "Second of minute " + second);
            }
            secondOfDay = (hour * 60 + minute) * 60 + second;
        } else if (secondOfDay < 0 || (long)secondOfDay >= 86400L) {
            throw DbException.get(90014, "Second of day " + secondOfDay);
        }
        int fraction = target[10];
        if (fraction == Integer.MIN_VALUE) {
            fraction = 0;
        }
        return (long)secondOfDay * 1000000000L + (long)fraction;
    }

    private static int constructOffset(int[] target) {
        int minute;
        boolean negative;
        int hour = target[12];
        if (hour == Integer.MIN_VALUE) {
            return 0;
        }
        boolean bl = negative = hour < 0;
        if (negative) {
            hour = hour == -100 ? 0 : -hour;
        }
        if ((minute = target[13]) == Integer.MIN_VALUE) {
            minute = 0;
        } else if (minute > 59) {
            throw DbException.get(90014, "Time zone minute " + minute);
        }
        int second = target[14];
        if (second == Integer.MIN_VALUE) {
            second = 0;
        } else if (second > 59) {
            throw DbException.get(90014, "Time zone second " + second);
        }
        int offset = (hour * 60 + minute) * 60 + second;
        if (offset > 64800) {
            throw DbException.get(90014, "Time zone offset is too large");
        }
        return negative ? -offset : offset;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Delimiter
    extends Part {
        static final Delimiter MINUS_SIGN = new Delimiter('-');
        static final Delimiter PERIOD = new Delimiter('.');
        static final Delimiter SOLIDUS = new Delimiter('/');
        static final Delimiter COMMA = new Delimiter(',');
        static final Delimiter APOSTROPHE = new Delimiter('\'');
        static final Delimiter SEMICOLON = new Delimiter(';');
        static final Delimiter COLON = new Delimiter(':');
        static final Delimiter SPACE = new Delimiter(' ');
        private final char delimiter;

        private Delimiter(char delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        int type() {
            return 15;
        }

        @Override
        public void format(StringBuilder builder, long dateValue, long timeNanos, int offsetSeconds) {
            builder.append(this.delimiter);
        }

        @Override
        public void parse(int[] target, Scanner s, boolean delimited, int year) {
            s.readChar(this.delimiter);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Field
    extends Part {
        static final Field Y = new Field(0, 1);
        static final Field YY = new Field(0, 2);
        static final Field YYY = new Field(0, 3);
        static final Field YYYY = new Field(0, 4);
        static final Field RR = new Field(1, 2);
        static final Field RRRR = new Field(1, 4);
        static final Field MM = new Field(2, 2);
        static final Field DD = new Field(3, 2);
        static final Field DDD = new Field(4, 3);
        static final Field HH12 = new Field(5, 2);
        static final Field HH24 = new Field(6, 2);
        static final Field MI = new Field(7, 2);
        static final Field SS = new Field(8, 2);
        static final Field SSSSS = new Field(9, 5);
        private static final Field[] FF;
        static final Field AM_PM;
        static final Field TZH;
        static final Field TZM;
        static final Field TZS;
        private final int type;
        private final int digits;

        static {
            AM_PM = new Field(11, 4);
            TZH = new Field(12, 2);
            TZM = new Field(13, 2);
            TZS = new Field(14, 2);
            Field[] ff = new Field[9];
            int i = 0;
            while (i < 9) {
                ff[i++] = new Field(10, i);
            }
            FF = ff;
        }

        static Field ff(int digits) {
            return FF[digits - 1];
        }

        Field(int type, int digits) {
            this.type = type;
            this.digits = digits;
        }

        @Override
        int type() {
            return this.type;
        }

        @Override
        void format(StringBuilder builder, long dateValue, long timeNanos, int offsetSeconds) {
            switch (this.type) {
                case 0: 
                case 1: {
                    int y = DateTimeUtils.yearFromDateValue(dateValue);
                    if (y < 0) {
                        builder.append('-');
                        y = -y;
                    }
                    switch (this.digits) {
                        case 1: {
                            y %= 10;
                            break;
                        }
                        case 2: {
                            y %= 100;
                            break;
                        }
                        case 3: {
                            y %= 1000;
                        }
                    }
                    Field.formatLast(builder, y, this.digits);
                    break;
                }
                case 2: {
                    StringUtils.appendTwoDigits(builder, DateTimeUtils.monthFromDateValue(dateValue));
                    break;
                }
                case 3: {
                    StringUtils.appendTwoDigits(builder, DateTimeUtils.dayFromDateValue(dateValue));
                    break;
                }
                case 4: {
                    StringUtils.appendZeroPadded(builder, 3, DateTimeUtils.getDayOfYear(dateValue));
                    break;
                }
                case 5: {
                    int h = (int)(timeNanos / 3600000000000L);
                    if (h == 0) {
                        h = 12;
                    } else if (h > 12) {
                        h -= 12;
                    }
                    StringUtils.appendTwoDigits(builder, h);
                    break;
                }
                case 6: {
                    StringUtils.appendTwoDigits(builder, (int)(timeNanos / 3600000000000L));
                    break;
                }
                case 7: {
                    StringUtils.appendTwoDigits(builder, (int)(timeNanos / 60000000000L % 60L));
                    break;
                }
                case 8: {
                    StringUtils.appendTwoDigits(builder, (int)(timeNanos / 1000000000L % 60L));
                    break;
                }
                case 9: {
                    StringUtils.appendZeroPadded(builder, 5, (int)(timeNanos / 1000000000L));
                    break;
                }
                case 10: {
                    Field.formatLast(builder, (int)(timeNanos % 1000000000L) / DateTimeUtils.FRACTIONAL_SECONDS_TABLE[this.digits], this.digits);
                    break;
                }
                case 11: {
                    int h = (int)(timeNanos / 3600000000000L);
                    builder.append(h < 12 ? "A.M." : "P.M.");
                    break;
                }
                case 12: {
                    int h = offsetSeconds / 3600;
                    if (offsetSeconds >= 0) {
                        builder.append('+');
                    } else {
                        h = -h;
                        builder.append('-');
                    }
                    StringUtils.appendTwoDigits(builder, h);
                    break;
                }
                case 13: {
                    StringUtils.appendTwoDigits(builder, Math.abs(offsetSeconds % 3600 / 60));
                    break;
                }
                case 14: {
                    StringUtils.appendTwoDigits(builder, Math.abs(offsetSeconds % 60));
                }
            }
        }

        private static void formatLast(StringBuilder builder, int value, int digits) {
            if (digits == 2) {
                StringUtils.appendTwoDigits(builder, value);
            } else {
                StringUtils.appendZeroPadded(builder, digits, value);
            }
        }

        @Override
        void parse(int[] target, Scanner s, boolean delimited, int year) {
            switch (this.type) {
                case 0: 
                case 1: {
                    boolean negative = s.readCharIf('-');
                    if (!negative) {
                        s.readCharIf('+');
                    }
                    int v = s.readPositiveInt(this.digits, delimited);
                    if (negative) {
                        if (this.digits < 4 || this.type == 1) {
                            throw DbException.get(90014, s.string);
                        }
                        v = -v;
                    } else if (this.digits < 4) {
                        if (this.digits == 1) {
                            if (v > 9) {
                                throw DbException.get(90014, s.string);
                            }
                            v += year / 10 * 10;
                        } else if (this.digits == 2) {
                            if (v > 99) {
                                throw DbException.get(90014, s.string);
                            }
                            v += year / 100 * 100;
                            if (this.type == 1) {
                                if (v > year + 50) {
                                    v -= 100;
                                } else if (v < year - 49) {
                                    year += 100;
                                }
                            }
                        } else if (this.digits == 3) {
                            if (v > 999) {
                                throw DbException.get(90014, s.string);
                            }
                            v += year / 1000 * 1000;
                        }
                    }
                    target[this.type] = v;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 13: 
                case 14: {
                    target[this.type] = s.readPositiveInt(this.digits, delimited);
                    break;
                }
                case 10: {
                    target[10] = s.readNanos(this.digits, delimited);
                    break;
                }
                case 11: {
                    int v;
                    if (s.readCharIf('A')) {
                        v = 0;
                    } else {
                        s.readChar('P');
                        v = 1;
                    }
                    s.readChar('.');
                    s.readChar('M');
                    s.readChar('.');
                    target[11] = v;
                    break;
                }
                case 12: {
                    int v;
                    boolean negative = s.readCharIf('-');
                    if (!negative && !s.readCharIf('+')) {
                        s.readChar(' ');
                    }
                    if ((v = s.readPositiveInt(this.digits, delimited)) > 18) {
                        throw DbException.get(90014, s.string);
                    }
                    target[12] = negative ? (v == 0 ? -100 : -v) : v;
                }
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class FieldType {
        static final int YEAR = 0;
        static final int ROUNDED_YEAR = 1;
        static final int MONTH = 2;
        static final int DAY_OF_MONTH = 3;
        static final int DAY_OF_YEAR = 4;
        static final int HOUR12 = 5;
        static final int HOUR24 = 6;
        static final int MINUTE = 7;
        static final int SECOND_OF_MINUTE = 8;
        static final int SECOND_OF_DAY = 9;
        static final int FRACTION = 10;
        static final int AMPM = 11;
        static final int TIME_ZONE_HOUR = 12;
        static final int TIME_ZONE_MINUTE = 13;
        static final int TIME_ZONE_SECOND = 14;
        static final int DELIMITER = 15;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static abstract class Part {
        Part() {
        }

        abstract int type();

        abstract void format(StringBuilder var1, long var2, long var4, int var6);

        abstract void parse(int[] var1, Scanner var2, boolean var3, int var4);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Scanner {
        final String string;
        private int offset;
        private final int length;

        Scanner(String string) {
            this.string = string;
            this.length = string.length();
        }

        int readChar() {
            return this.offset < this.length ? (int)this.string.charAt(this.offset++) : -1;
        }

        void readChar(char c) {
            if (this.offset >= this.length || this.string.charAt(this.offset) != c) {
                throw DbException.get(90014, this.string);
            }
            ++this.offset;
        }

        boolean readCharIf(char c) {
            if (this.offset < this.length && this.string.charAt(this.offset) == c) {
                ++this.offset;
                return true;
            }
            return false;
        }

        int readPositiveInt(int digits, boolean delimited) {
            int end;
            int start = this.offset;
            if (delimited) {
                char c;
                end = start;
                while (end < this.length && (c = this.string.charAt(end)) >= '0' && c <= '9') {
                    ++end;
                }
                if (start == end) {
                    throw DbException.get(90014, this.string);
                }
            } else {
                end = start + digits;
                if (end > this.length) {
                    throw DbException.get(90014, this.string);
                }
            }
            try {
                this.offset = end;
                return StringUtils.parseUInt31(this.string, start, this.offset);
            }
            catch (NumberFormatException e) {
                throw DbException.get(90014, this.string);
            }
        }

        /*
         * Unable to fully structure code
         */
        int readNanos(int digits, boolean delimited) {
            block5: {
                block4: {
                    end = start = this.offset;
                    nanos = 0;
                    mul = 100000000;
                    if (!delimited) break block4;
                    end = start;
                    while (end < this.length && (c = this.string.charAt(end)) >= '0' && c <= '9') {
                        nanos += mul * (c - 48);
                        mul /= 10;
                        ++end;
                    }
                    if (start == end) {
                        throw DbException.get(90014, this.string);
                    }
                    break block5;
                }
                end = start + digits;
                if (end <= this.length) ** GOTO lbl24
                throw DbException.get(90014, this.string);
lbl-1000:
                // 1 sources

                {
                    c = this.string.charAt(start);
                    if (c < '0' || c > '9') {
                        throw DbException.get(90014, this.string);
                    }
                    nanos += mul * (c - 48);
                    mul /= 10;
                    ++start;
lbl24:
                    // 2 sources

                    ** while (start < end)
                }
            }
            this.offset = end;
            return nanos;
        }
    }
}

