/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.h2.util.NetUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class NetworkConnectionInfo {
    private final String server;
    private final byte[] clientAddr;
    private final int clientPort;
    private final String clientInfo;

    public NetworkConnectionInfo(String server, String clientAddr, int clientPort) throws UnknownHostException {
        this(server, InetAddress.getByName(clientAddr).getAddress(), clientPort, null);
    }

    public NetworkConnectionInfo(String server, byte[] clientAddr, int clientPort, String clientInfo) {
        this.server = server;
        this.clientAddr = clientAddr;
        this.clientPort = clientPort;
        this.clientInfo = clientInfo;
    }

    public String getServer() {
        return this.server;
    }

    public byte[] getClientAddr() {
        return this.clientAddr;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public String getClient() {
        return NetUtils.ipToShortForm(new StringBuilder(), this.clientAddr, true).append(':').append(this.clientPort).toString();
    }
}

