/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.message.DbException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Permutations<T> {
    private final T[] in;
    private final T[] out;
    private final int n;
    private final int m;
    private final int[] index;
    private boolean hasNext = true;

    private Permutations(T[] in, T[] out, int m) {
        this.n = in.length;
        this.m = m;
        if (this.n < m || m < 0) {
            throw DbException.getInternalError("n < m or m < 0");
        }
        this.in = in;
        this.out = out;
        this.index = new int[this.n];
        int i = 0;
        while (i < this.n) {
            this.index[i] = i;
            ++i;
        }
        this.reverseAfter(m - 1);
    }

    public static <T> Permutations<T> create(T[] in, T[] out) {
        return new Permutations<T>(in, out, in.length);
    }

    public static <T> Permutations<T> create(T[] in, T[] out, int m) {
        return new Permutations<T>(in, out, m);
    }

    private void moveIndex() {
        int i = this.rightmostDip();
        if (i < 0) {
            this.hasNext = false;
            return;
        }
        int leastToRightIndex = i + 1;
        int j = i + 2;
        while (j < this.n) {
            if (this.index[j] < this.index[leastToRightIndex] && this.index[j] > this.index[i]) {
                leastToRightIndex = j;
            }
            ++j;
        }
        int t = this.index[i];
        this.index[i] = this.index[leastToRightIndex];
        this.index[leastToRightIndex] = t;
        if (this.m - 1 > i) {
            this.reverseAfter(i);
            this.reverseAfter(this.m - 1);
        }
    }

    private int rightmostDip() {
        int i = this.n - 2;
        while (i >= 0) {
            if (this.index[i] < this.index[i + 1]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private void reverseAfter(int i) {
        int start = i + 1;
        int end = this.n - 1;
        while (start < end) {
            int t = this.index[start];
            this.index[start] = this.index[end];
            this.index[end] = t;
            ++start;
            --end;
        }
    }

    public boolean next() {
        if (!this.hasNext) {
            return false;
        }
        int i = 0;
        while (i < this.m) {
            this.out[i] = this.in[this.index[i]];
            ++i;
        }
        this.moveIndex();
        return true;
    }
}

