/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.instrument.Instrumentation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Profiler
implements Runnable {
    private static Instrumentation instrumentation;
    private static final String LINE_SEPARATOR;
    private static final int MAX_ELEMENTS = 1000;
    public int interval = 2;
    public int depth = 48;
    public boolean paused;
    public boolean sumClasses;
    public boolean sumMethods;
    private int pid;
    private final String[] ignoreLines = "java,sun,com.sun.,com.google.common.,com.mongodb.,org.bson.,".split(",");
    private final String[] ignorePackages = "java,sun,com.sun.,com.google.common.,com.mongodb.,org.bson".split(",");
    private final String[] ignoreThreads = "java.lang.Object.wait,java.lang.Thread.dumpThreads,java.lang.Thread.getThreads,java.lang.Thread.sleep,java.lang.UNIXProcess.waitForProcessExit,java.net.PlainDatagramSocketImpl.receive0,java.net.PlainSocketImpl.accept,java.net.PlainSocketImpl.socketAccept,java.net.SocketInputStream.socketRead,java.net.SocketOutputStream.socketWrite,org.eclipse.jetty.io.nio.SelectorManager$SelectSet.doSelect,sun.awt.windows.WToolkit.eventLoop,sun.misc.Unsafe.park,sun.nio.ch.EPollArrayWrapper.epollWait,sun.nio.ch.KQueueArrayWrapper.kevent0,sun.nio.ch.ServerSocketChannelImpl.accept,dalvik.system.VMStack.getThreadStackTrace,dalvik.system.NativeStart.run".split(",");
    private volatile boolean stop;
    private final HashMap<String, Integer> counts = new HashMap();
    private final HashMap<String, Integer> summary = new HashMap();
    private int minCount = 1;
    private int total;
    private Thread thread;
    private long start;
    private long time;
    private int threadDumps;

    static {
        LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        instrumentation = inst;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static void main(String ... args) {
        new Profiler().run(args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(String ... args) {
        if (args.length == 0) {
            System.out.println("Show profiling data");
            System.out.println("Usage: java " + this.getClass().getName() + " <pid> | <stackTraceFileNames>");
            System.out.println("Processes:");
            String processes = Profiler.exec("jps", "-l");
            System.out.println(processes);
            return;
        }
        this.start = System.nanoTime();
        if (args[0].matches("\\d+")) {
            this.pid = Integer.parseInt(args[0]);
            long last = 0L;
            while (true) {
                this.tick();
                long t = System.nanoTime();
                if (t - last <= TimeUnit.SECONDS.toNanos(5L)) continue;
                this.time = System.nanoTime() - this.start;
                System.out.println(this.getTopTraces(3));
                last = t;
            }
        }
        try {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.startsWith("-")) {
                    if ("-classes".equals(arg)) {
                        this.sumClasses = true;
                    } else if ("-methods".equals(arg)) {
                        this.sumMethods = true;
                    } else {
                        if (!"-packages".equals(arg)) throw new IllegalArgumentException(arg);
                        this.sumClasses = false;
                        this.sumMethods = false;
                    }
                } else {
                    BufferedReader reader;
                    Path file = Paths.get(arg, new String[0]);
                    Throwable throwable = null;
                    Object var8_14 = null;
                    try {
                        reader = Files.newBufferedReader(file);
                        try {
                            String line;
                            LineNumberReader r = new LineNumberReader(reader);
                            while ((line = r.readLine()) != null) {
                                if (!line.startsWith("Full thread dump")) continue;
                                ++this.threadDumps;
                            }
                        }
                        finally {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        } else {
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    throwable = null;
                    var8_14 = null;
                    try {
                        reader = Files.newBufferedReader(file);
                        try {
                            this.processList(Profiler.readStackTrace(new LineNumberReader(reader)));
                        }
                        finally {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                ++n2;
            }
            System.out.println(this.getTopTraces(5));
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Object[]> getRunnableStackTraces() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] dump;
            Thread t = entry.getKey();
            if (t.getState() != Thread.State.RUNNABLE || (dump = entry.getValue()) == null || dump.length == 0) continue;
            list.add(dump);
        }
        return list;
    }

    private static List<Object[]> readRunnableStackTraces(int pid) {
        try {
            String jstack = Profiler.exec("jstack", Integer.toString(pid));
            LineNumberReader r = new LineNumberReader(new StringReader(jstack));
            return Profiler.readStackTrace(r);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Object[]> readStackTrace(LineNumberReader r) throws IOException {
        String line;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        while ((line = r.readLine()) != null) {
            if (!line.startsWith("\"")) continue;
            line = r.readLine();
            if (line == null) break;
            if (!(line = line.trim()).startsWith("java.lang.Thread.State: RUNNABLE")) continue;
            ArrayList<String> stack = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).startsWith("- ")) continue;
                if (!line.startsWith("at ")) break;
                line = StringUtils.trimSubstring(line, 3);
                stack.add(line);
            }
            if (stack.isEmpty()) continue;
            String[] s = stack.toArray(new String[0]);
            list.add(s);
        }
        return list;
    }

    private static String exec(String ... args) {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Process p = Runtime.getRuntime().exec(args);
            Profiler.copyInThread(p.getInputStream(), out);
            Profiler.copyInThread(p.getErrorStream(), err);
            p.waitFor();
            String e = err.toString(StandardCharsets.UTF_8);
            if (e.length() > 0) {
                throw new RuntimeException(e);
            }
            return out.toString(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyInThread(final InputStream in, final OutputStream out) {
        new Thread("Profiler stream copy"){

            @Override
            public void run() {
                byte[] buffer = new byte[4096];
                try {
                    int len;
                    while ((len = in.read(buffer, 0, buffer.length)) >= 0) {
                        out.write(buffer, 0, len);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }

    public Profiler startCollecting() {
        this.thread = new Thread((Runnable)this, "Profiler");
        this.thread.setDaemon(true);
        this.thread.start();
        return this;
    }

    public Profiler stopCollecting() {
        this.stop = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
        return this;
    }

    @Override
    public void run() {
        this.start = System.nanoTime();
        while (!this.stop) {
            try {
                this.tick();
            }
            catch (Throwable t) {
                break;
            }
        }
        this.time = System.nanoTime() - this.start;
    }

    private void tick() {
        if (this.interval > 0) {
            if (this.paused) {
                return;
            }
            try {
                Thread.sleep(this.interval, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List<Object[]> list = this.pid != 0 ? Profiler.readRunnableStackTraces(this.pid) : Profiler.getRunnableStackTraces();
        ++this.threadDumps;
        this.processList(list);
    }

    private void processList(List<Object[]> list) {
        for (Object[] dump : list) {
            if (Profiler.startsWithAny(dump[0].toString(), this.ignoreThreads)) continue;
            StringBuilder buff = new StringBuilder();
            String last = null;
            boolean packageCounts = false;
            int j = 0;
            int i = 0;
            while (i < dump.length && j < this.depth) {
                String el = dump[i].toString();
                if (!el.equals(last) && !Profiler.startsWithAny(el, this.ignoreLines)) {
                    last = el;
                    buff.append("at ").append(el).append(LINE_SEPARATOR);
                    if (!packageCounts && !Profiler.startsWithAny(el, this.ignorePackages)) {
                        int m;
                        packageCounts = true;
                        int index = 0;
                        while (index < el.length()) {
                            char c = el.charAt(index);
                            if (c == '(' || Character.isUpperCase(c)) break;
                            ++index;
                        }
                        if (index > 0 && el.charAt(index - 1) == '.') {
                            --index;
                        }
                        if (this.sumClasses) {
                            m = el.indexOf(46, index + 1);
                            int n = index = m >= 0 ? m : index;
                        }
                        if (this.sumMethods) {
                            m = el.indexOf(40, index + 1);
                            index = m >= 0 ? m : index;
                        }
                        String groupName = el.substring(0, index);
                        Profiler.increment(this.summary, groupName, 0);
                    }
                    ++j;
                }
                ++i;
            }
            if (buff.length() <= 0) continue;
            this.minCount = Profiler.increment(this.counts, buff.toString().trim(), this.minCount);
            ++this.total;
        }
    }

    private static boolean startsWithAny(String s, String[] prefixes) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.length() > 0 && s.startsWith(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int increment(HashMap<String, Integer> map, String trace, int minCount) {
        Integer oldCount = map.get(trace);
        if (oldCount == null) {
            map.put(trace, 1);
        } else {
            map.put(trace, oldCount + 1);
        }
        while (map.size() > 1000) {
            Iterator<Map.Entry<String, Integer>> ei = map.entrySet().iterator();
            while (ei.hasNext()) {
                Map.Entry<String, Integer> e = ei.next();
                if (e.getValue() > minCount) continue;
                ei.remove();
            }
            if (map.size() <= 1000) continue;
            ++minCount;
        }
        return minCount;
    }

    public String getTop(int count) {
        this.stopCollecting();
        return this.getTopTraces(count);
    }

    private String getTopTraces(int count) {
        StringBuilder buff = new StringBuilder();
        buff.append("Profiler: top ").append(count).append(" stack trace(s) of ");
        if (this.time > 0L) {
            buff.append(" of ").append(TimeUnit.NANOSECONDS.toMillis(this.time)).append(" ms");
        }
        if (this.threadDumps > 0) {
            buff.append(" of ").append(this.threadDumps).append(" thread dumps");
        }
        buff.append(":").append(LINE_SEPARATOR);
        if (this.counts.size() == 0) {
            buff.append("(none)").append(LINE_SEPARATOR);
        }
        HashMap<String, Integer> copy = new HashMap<String, Integer>(this.counts);
        Profiler.appendTop(buff, copy, count, this.total, false);
        buff.append("summary:").append(LINE_SEPARATOR);
        copy = new HashMap<String, Integer>(this.summary);
        Profiler.appendTop(buff, copy, count, this.total, true);
        buff.append('.');
        return buff.toString();
    }

    private static void appendTop(StringBuilder buff, HashMap<String, Integer> map, int count, int total, boolean table) {
        int x = 0;
        int min = 0;
        while (true) {
            int highest = 0;
            Map.Entry<String, Integer> best = null;
            for (Map.Entry<String, Integer> el : map.entrySet()) {
                if (el.getValue() <= highest) continue;
                best = el;
                highest = el.getValue();
            }
            if (best == null) break;
            map.remove(best.getKey());
            if (++x >= count) {
                if (best.getValue() < min) break;
                min = best.getValue();
            }
            int c = best.getValue();
            int percent = 100 * c / Math.max(total, 1);
            if (table) {
                if (percent <= 1) continue;
                buff.append(percent).append("%: ").append(best.getKey()).append(LINE_SEPARATOR);
                continue;
            }
            buff.append(c).append('/').append(total).append(" (").append(percent).append("%):").append(LINE_SEPARATOR).append(best.getKey()).append(LINE_SEPARATOR);
        }
    }
}

