/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StringUtils {
    private static SoftReference<String[]> softCache;
    private static long softCacheCreatedNs;
    private static final char[] HEX;
    private static final int[] HEX_DECODE;
    private static final int TO_UPPER_CACHE_LENGTH = 2048;
    private static final int TO_UPPER_CACHE_MAX_ENTRY_LENGTH = 64;
    private static final String[][] TO_UPPER_CACHE;

    static {
        HEX = "0123456789abcdef".toCharArray();
        HEX_DECODE = new int[103];
        TO_UPPER_CACHE = new String[2048][];
        int i = 0;
        while (i < HEX_DECODE.length) {
            StringUtils.HEX_DECODE[i] = -1;
            ++i;
        }
        i = 0;
        while (i <= 9) {
            StringUtils.HEX_DECODE[i + 48] = i;
            ++i;
        }
        i = 0;
        while (i <= 5) {
            int n = i + 10;
            StringUtils.HEX_DECODE[i + 65] = n;
            StringUtils.HEX_DECODE[i + 97] = n;
            ++i;
        }
    }

    private StringUtils() {
    }

    private static String[] getCache() {
        String[] cache;
        if (softCache != null && (cache = softCache.get()) != null) {
            return cache;
        }
        long time = System.nanoTime();
        if (softCacheCreatedNs != 0L && time - softCacheCreatedNs < TimeUnit.SECONDS.toNanos(5L)) {
            return null;
        }
        try {
            cache = new String[SysProperties.OBJECT_CACHE_SIZE];
            softCache = new SoftReference<String[]>(cache);
            String[] stringArray = cache;
            return stringArray;
        }
        finally {
            softCacheCreatedNs = System.nanoTime();
        }
    }

    public static String toUpperEnglish(String s) {
        if (s.length() > 64) {
            return s.toUpperCase(Locale.ENGLISH);
        }
        int index = s.hashCode() & 0x7FF;
        String[] e = TO_UPPER_CACHE[index];
        if (e != null && e[0].equals(s)) {
            return e[1];
        }
        String s2 = s.toUpperCase(Locale.ENGLISH);
        e = new String[]{s, s2};
        StringUtils.TO_UPPER_CACHE[index] = e;
        return s2;
    }

    public static String toLowerEnglish(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static String quoteStringSQL(String s) {
        if (s == null) {
            return "NULL";
        }
        return StringUtils.quoteStringSQL(new StringBuilder(s.length() + 2), s).toString();
    }

    public static StringBuilder quoteStringSQL(StringBuilder builder, String s) {
        if (s == null) {
            return builder.append("NULL");
        }
        return StringUtils.quoteIdentifierOrLiteral(builder, s, '\'');
    }

    public static String decodeUnicodeStringSQL(String s, int uencode) {
        int l = s.length();
        StringBuilder builder = new StringBuilder(l);
        int i = 0;
        while (i < l) {
            int cp = s.codePointAt(i);
            i += Character.charCount(cp);
            if (cp == uencode) {
                if (i >= l) {
                    throw StringUtils.getFormatException(s, i);
                }
                cp = s.codePointAt(i);
                if (cp == uencode) {
                    i += Character.charCount(cp);
                } else {
                    if (i + 4 > l) {
                        throw StringUtils.getFormatException(s, i);
                    }
                    char ch = s.charAt(i);
                    try {
                        if (ch == '+') {
                            if (i + 7 > l) {
                                throw StringUtils.getFormatException(s, i);
                            }
                            cp = Integer.parseUnsignedInt(s.substring(i + 1, i += 7), 16);
                        } else {
                            cp = Integer.parseUnsignedInt(s.substring(i, i += 4), 16);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw StringUtils.getFormatException(s, i);
                    }
                }
            }
            builder.appendCodePoint(cp);
        }
        return builder.toString();
    }

    public static String javaEncode(String s) {
        StringBuilder buff = new StringBuilder(s.length());
        StringUtils.javaEncode(s, buff, false);
        return buff.toString();
    }

    public static void javaEncode(String s, StringBuilder buff, boolean forSQL) {
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    buff.append("\\t");
                    break;
                }
                case '\n': {
                    buff.append("\\n");
                    break;
                }
                case '\f': {
                    buff.append("\\f");
                    break;
                }
                case '\r': {
                    buff.append("\\r");
                    break;
                }
                case '\"': {
                    buff.append("\\\"");
                    break;
                }
                case '\'': {
                    if (forSQL) {
                        buff.append('\'');
                    }
                    buff.append('\'');
                    break;
                }
                case '\\': {
                    buff.append("\\\\");
                    break;
                }
                default: {
                    if (c >= ' ' && c < '\u0080') {
                        buff.append(c);
                        break;
                    }
                    buff.append("\\u").append(HEX[c >>> 12]).append(HEX[c >>> 8 & 0xF]).append(HEX[c >>> 4 & 0xF]).append(HEX[c & 0xF]);
                }
            }
            ++i;
        }
    }

    public static String addAsterisk(String s, int index) {
        if (s != null) {
            int len = s.length();
            index = Math.min(index, len);
            s = new StringBuilder(len + 3).append(s, 0, index).append("[*]").append(s, index, len).toString();
        }
        return s;
    }

    private static DbException getFormatException(String s, int i) {
        return DbException.get(90095, StringUtils.addAsterisk(s, i));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String javaDecode(String s) {
        int length = s.length();
        StringBuilder buff = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            block21: {
                char c;
                block20: {
                    c = s.charAt(i);
                    if (c != '\\') break block20;
                    if (i + 1 >= s.length()) {
                        throw StringUtils.getFormatException(s, i);
                    }
                    c = s.charAt(++i);
                    switch (c) {
                        case 't': {
                            buff.append('\t');
                            break block21;
                        }
                        case 'r': {
                            buff.append('\r');
                            break block21;
                        }
                        case 'n': {
                            buff.append('\n');
                            break block21;
                        }
                        case 'b': {
                            buff.append('\b');
                            break block21;
                        }
                        case 'f': {
                            buff.append('\f');
                            break block21;
                        }
                        case '#': {
                            buff.append('#');
                            break block21;
                        }
                        case '=': {
                            buff.append('=');
                            break block21;
                        }
                        case ':': {
                            buff.append(':');
                            break block21;
                        }
                        case '\"': {
                            buff.append('\"');
                            break block21;
                        }
                        case '\\': {
                            buff.append('\\');
                            break block21;
                        }
                        case 'u': {
                            if (i + 4 >= length) {
                                throw StringUtils.getFormatException(s, i);
                            }
                            try {
                                c = (char)Integer.parseInt(s.substring(i + 1, i + 5), 16);
                            }
                            catch (NumberFormatException e) {
                                throw StringUtils.getFormatException(s, i);
                            }
                            i += 4;
                            buff.append(c);
                            break block21;
                        }
                        default: {
                            if (c < '0' || c > '9' || i + 2 >= length) throw StringUtils.getFormatException(s, i);
                            try {
                                c = (char)Integer.parseInt(s.substring(i, i + 3), 8);
                            }
                            catch (NumberFormatException e) {
                                throw StringUtils.getFormatException(s, i);
                            }
                            i += 2;
                            buff.append(c);
                            break block21;
                        }
                    }
                }
                buff.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    public static String quoteJavaString(String s) {
        if (s == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder(s.length() + 2).append('\"');
        StringUtils.javaEncode(s, builder, false);
        return builder.append('\"').toString();
    }

    public static String quoteJavaStringArray(String[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder buff = new StringBuilder("new String[]{");
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(StringUtils.quoteJavaString(array[i]));
            ++i;
        }
        return buff.append('}').toString();
    }

    public static String quoteJavaIntArray(int[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder("new int[]{");
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(array[i]);
            ++i;
        }
        return builder.append('}').toString();
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            throw DbException.convert(e);
        }
    }

    public static String urlDecode(String encoded) {
        int length = encoded.length();
        byte[] buff = new byte[length];
        int j = 0;
        int i = 0;
        while (i < length) {
            char ch = encoded.charAt(i);
            if (ch == '+') {
                buff[j++] = 32;
            } else if (ch == '%') {
                buff[j++] = (byte)Integer.parseInt(encoded.substring(i + 1, i + 3), 16);
                i += 2;
            } else if (ch <= '\u007f' && ch >= ' ') {
                buff[j++] = (byte)ch;
            } else {
                throw new IllegalArgumentException("Unexpected char " + ch + " decoding " + encoded);
            }
            ++i;
        }
        return new String(buff, 0, j, StandardCharsets.UTF_8);
    }

    public static String[] arraySplit(String s, char separatorChar, boolean trim) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length == 0) {
            return new String[0];
        }
        ArrayList<String> list = Utils.newSmallArrayList();
        StringBuilder buff = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c == separatorChar) {
                String e = buff.toString();
                list.add(trim ? e.trim() : e);
                buff.setLength(0);
            } else if (c == '\\' && i < length - 1) {
                buff.append(s.charAt(++i));
            } else {
                buff.append(c);
            }
            ++i;
        }
        String e = buff.toString();
        list.add(trim ? e.trim() : e);
        return list.toArray(new String[0]);
    }

    public static String arrayCombine(String[] list, char separatorChar) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            String s;
            if (i > 0) {
                builder.append(separatorChar);
            }
            if ((s = list[i]) != null) {
                int j = 0;
                int length = s.length();
                while (j < length) {
                    char c = s.charAt(j);
                    if (c == '\\' || c == separatorChar) {
                        builder.append('\\');
                    }
                    builder.append(c);
                    ++j;
                }
            }
            ++i;
        }
        return builder.toString();
    }

    public static String xmlAttr(String name, String value) {
        return " " + name + "=\"" + StringUtils.xmlText(value) + "\"";
    }

    public static String xmlNode(String name, String attributes, String content) {
        return StringUtils.xmlNode(name, attributes, content, true);
    }

    public static String xmlNode(String name, String attributes, String content, boolean indent) {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(name);
        if (attributes != null) {
            builder.append(attributes);
        }
        if (content == null) {
            builder.append("/>\n");
            return builder.toString();
        }
        builder.append('>');
        if (indent && content.indexOf(10) >= 0) {
            builder.append('\n');
            StringUtils.indent(builder, content, 4, true);
        } else {
            builder.append(content);
        }
        builder.append("</").append(name).append(">\n");
        return builder.toString();
    }

    public static StringBuilder indent(StringBuilder builder, String s, int spaces, boolean newline) {
        int i = 0;
        int length = s.length();
        while (i < length) {
            int j = 0;
            while (j < spaces) {
                builder.append(' ');
                ++j;
            }
            int n = s.indexOf(10, i);
            n = n < 0 ? length : n + 1;
            builder.append(s, i, n);
            i = n;
        }
        if (newline && !s.endsWith("\n")) {
            builder.append('\n');
        }
        return builder;
    }

    public static String xmlComment(String data) {
        int idx = 0;
        while ((idx = ((String)data).indexOf("--", idx)) >= 0) {
            data = ((String)data).substring(0, idx + 1) + " " + ((String)data).substring(idx + 1);
        }
        if (((String)data).indexOf(10) >= 0) {
            StringBuilder builder = new StringBuilder(((String)data).length() + 18).append("<!--\n");
            return StringUtils.indent(builder, (String)data, 4, true).append("-->\n").toString();
        }
        return "<!-- " + (String)data + " -->\n";
    }

    public static String xmlCData(String data) {
        if (((String)data).contains("]]>")) {
            return StringUtils.xmlText((String)data);
        }
        boolean newline = ((String)data).endsWith("\n");
        data = "<![CDATA[" + (String)data + "]]>";
        return newline ? (String)data + "\n" : data;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String text) {
        return StringUtils.xmlText(text, false);
    }

    public static String xmlText(String text, boolean escapeNewline) {
        int length = text.length();
        StringBuilder buff = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    buff.append("&lt;");
                    break;
                }
                case '>': {
                    buff.append("&gt;");
                    break;
                }
                case '&': {
                    buff.append("&amp;");
                    break;
                }
                case '\'': {
                    buff.append("&#39;");
                    break;
                }
                case '\"': {
                    buff.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (escapeNewline) {
                        buff.append("&#x").append(Integer.toHexString(ch)).append(';');
                        break;
                    }
                    buff.append(ch);
                    break;
                }
                case '\t': {
                    buff.append(ch);
                    break;
                }
                default: {
                    if (ch < ' ' || ch > '\u007f') {
                        buff.append("&#x").append(Integer.toHexString(ch)).append(';');
                        break;
                    }
                    buff.append(ch);
                }
            }
            ++i;
        }
        return buff.toString();
    }

    public static String replaceAll(String s, String before, String after) {
        int next = s.indexOf(before);
        if (next < 0 || before.isEmpty()) {
            return s;
        }
        StringBuilder buff = new StringBuilder(s.length() - before.length() + after.length());
        int index = 0;
        do {
            buff.append(s, index, next).append(after);
        } while ((next = s.indexOf(before, index = next + before.length())) >= 0);
        buff.append(s, index, s.length());
        return buff.toString();
    }

    public static String quoteIdentifier(String s) {
        return StringUtils.quoteIdentifierOrLiteral(new StringBuilder(s.length() + 2), s, '\"').toString();
    }

    public static StringBuilder quoteIdentifier(StringBuilder builder, String s) {
        return StringUtils.quoteIdentifierOrLiteral(builder, s, '\"');
    }

    private static StringBuilder quoteIdentifierOrLiteral(StringBuilder builder, String s, char q) {
        int builderLength = builder.length();
        builder.append(q);
        int i = 0;
        int l = s.length();
        while (i < l) {
            int cp = s.codePointAt(i);
            i += Character.charCount(cp);
            if (cp < 32 || cp > 127) {
                builder.setLength(builderLength);
                builder.append("U&").append(q);
                i = 0;
                while (i < l) {
                    cp = s.codePointAt(i);
                    i += Character.charCount(cp);
                    if (cp >= 32 && cp < 127) {
                        char ch = (char)cp;
                        if (ch == q || ch == '\\') {
                            builder.append(ch);
                        }
                        builder.append(ch);
                        continue;
                    }
                    if (cp <= 65535) {
                        StringUtils.appendHex(builder.append('\\'), cp, 2);
                        continue;
                    }
                    StringUtils.appendHex(builder.append("\\+"), cp, 3);
                }
                break;
            }
            if (cp == q) {
                builder.append(q);
            }
            builder.append((char)cp);
        }
        return builder.append(q);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static String pad(String string, int n, String padding, boolean right) {
        if (n < 0) {
            n = 0;
        }
        if (n < string.length()) {
            return string.substring(0, n);
        }
        if (n == string.length()) {
            return string;
        }
        int paddingChar = padding == null || padding.isEmpty() ? 32 : padding.codePointAt(0);
        StringBuilder buff = new StringBuilder(n);
        n -= string.length();
        if (Character.isSupplementaryCodePoint(paddingChar)) {
            n >>= 1;
        }
        if (right) {
            buff.append(string);
        }
        int i = 0;
        while (i < n) {
            buff.appendCodePoint(paddingChar);
            ++i;
        }
        if (!right) {
            buff.append(string);
        }
        return buff.toString();
    }

    public static char[] cloneCharArray(char[] chars) {
        if (chars == null) {
            return null;
        }
        int len = chars.length;
        if (len == 0) {
            return chars;
        }
        return Arrays.copyOf(chars, len);
    }

    public static String trim(String s, boolean leading, boolean trailing, String characters) {
        IntPredicate test;
        if (characters == null || characters.isEmpty()) {
            return StringUtils.trim(s, leading, trailing, ' ');
        }
        int length = characters.length();
        if (length == 1) {
            return StringUtils.trim(s, leading, trailing, characters.charAt(0));
        }
        int count = characters.codePointCount(0, length);
        if (count <= 2) {
            int cp2;
            int cp = characters.codePointAt(0);
            test = count > 1 && cp != (cp2 = characters.codePointAt(Character.charCount(cp))) ? value -> value == cp || value == cp2 : value -> value == cp;
        } else {
            HashSet set = new HashSet();
            characters.codePoints().forEach(set::add);
            test = set::contains;
        }
        return StringUtils.trim(s, leading, trailing, test);
    }

    private static String trim(String s, boolean leading, boolean trailing, IntPredicate test) {
        int cp;
        int begin = 0;
        int end = s.length();
        if (leading) {
            while (begin < end && test.test(cp = s.codePointAt(begin))) {
                begin += Character.charCount(cp);
            }
        }
        if (trailing) {
            while (end > begin && test.test(cp = s.codePointBefore(end))) {
                end -= Character.charCount(cp);
            }
        }
        return s.substring(begin, end);
    }

    public static String trim(String s, boolean leading, boolean trailing, char character) {
        int begin = 0;
        int end = s.length();
        if (leading) {
            while (begin < end && s.charAt(begin) == character) {
                ++begin;
            }
        }
        if (trailing) {
            while (end > begin && s.charAt(end - 1) == character) {
                --end;
            }
        }
        return s.substring(begin, end);
    }

    public static String trimSubstring(String s, int beginIndex) {
        return StringUtils.trimSubstring(s, beginIndex, s.length());
    }

    public static String trimSubstring(String s, int beginIndex, int endIndex) {
        while (beginIndex < endIndex && s.charAt(beginIndex) <= ' ') {
            ++beginIndex;
        }
        while (beginIndex < endIndex && s.charAt(endIndex - 1) <= ' ') {
            --endIndex;
        }
        return s.substring(beginIndex, endIndex);
    }

    public static StringBuilder trimSubstring(StringBuilder builder, String s, int beginIndex, int endIndex) {
        while (beginIndex < endIndex && s.charAt(beginIndex) <= ' ') {
            ++beginIndex;
        }
        while (beginIndex < endIndex && s.charAt(endIndex - 1) <= ' ') {
            --endIndex;
        }
        return builder.append(s, beginIndex, endIndex);
    }

    public static String truncateString(String s, int maximumLength) {
        if (s.length() > maximumLength) {
            s = maximumLength > 0 ? s.substring(0, Character.isSurrogatePair(s.charAt(maximumLength - 1), s.charAt(maximumLength)) ? maximumLength - 1 : maximumLength) : "";
        }
        return s;
    }

    public static String cache(String s) {
        if (!SysProperties.OBJECT_CACHE) {
            return s;
        }
        if (s == null) {
            return s;
        }
        if (s.isEmpty()) {
            return "";
        }
        String[] cache = StringUtils.getCache();
        if (cache != null) {
            int hash = s.hashCode();
            int index = hash & SysProperties.OBJECT_CACHE_SIZE - 1;
            String cached = cache[index];
            if (s.equals(cached)) {
                return cached;
            }
            cache[index] = s;
        }
        return s;
    }

    public static void clearCache() {
        softCache = null;
    }

    public static int parseUInt31(String s, int start, int end) {
        if (end > s.length() || start < 0 || start > end) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            throw new NumberFormatException("");
        }
        int result = 0;
        int i = start;
        while (i < end) {
            char ch = s.charAt(i);
            if (ch < '0' || ch > '9' || result > 0xCCCCCCC) {
                throw new NumberFormatException(s.substring(start, end));
            }
            if ((result = result * 10 + ch - 48) < 0) {
                throw new NumberFormatException(s.substring(start, end));
            }
            ++i;
        }
        return result;
    }

    public static byte[] convertHexToBytes(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            throw DbException.get(90003, s);
        }
        byte[] buff = new byte[len /= 2];
        int mask = 0;
        int[] hex = HEX_DECODE;
        try {
            int i = 0;
            while (i < len) {
                int d = hex[s.charAt(i + i)] << 4 | hex[s.charAt(i + i + 1)];
                mask |= d;
                buff[i] = (byte)d;
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw DbException.get(90004, s);
        }
        if ((mask & 0xFFFFFF00) != 0) {
            throw DbException.get(90004, s);
        }
        return buff;
    }

    public static ByteArrayOutputStream convertHexWithSpacesToBytes(ByteArrayOutputStream baos, String s, int start, int end) {
        if (baos == null) {
            baos = new ByteArrayOutputStream(end - start >>> 1);
        }
        int mask = 0;
        int[] hex = HEX_DECODE;
        try {
            int i = start;
            while (i < end) {
                char c2;
                char c1;
                if ((c1 = s.charAt(i++)) == ' ') continue;
                do {
                    if (i < end) continue;
                    if (((mask | hex[c1]) & 0xFFFFFF00) != 0) {
                        throw StringUtils.getHexStringException(90004, s, start, end);
                    }
                    throw StringUtils.getHexStringException(90003, s, start, end);
                } while ((c2 = s.charAt(i++)) == ' ');
                int d = hex[c1] << 4 | hex[c2];
                mask |= d;
                baos.write(d);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw StringUtils.getHexStringException(90004, s, start, end);
        }
        if ((mask & 0xFFFFFF00) != 0) {
            throw StringUtils.getHexStringException(90004, s, start, end);
        }
        return baos;
    }

    private static DbException getHexStringException(int code, String s, int start, int end) {
        return DbException.get(code, s.substring(start, end));
    }

    public static String convertBytesToHex(byte[] value) {
        return StringUtils.convertBytesToHex(value, value.length);
    }

    public static String convertBytesToHex(byte[] value, int len) {
        byte[] bytes = new byte[len * 2];
        char[] hex = HEX;
        int i = 0;
        int j = 0;
        while (i < len) {
            int c = value[i] & 0xFF;
            bytes[j++] = (byte)hex[c >> 4];
            bytes[j++] = (byte)hex[c & 0xF];
            ++i;
        }
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }

    public static StringBuilder convertBytesToHex(StringBuilder builder, byte[] value) {
        return StringUtils.convertBytesToHex(builder, value, value.length);
    }

    public static StringBuilder convertBytesToHex(StringBuilder builder, byte[] value, int len) {
        char[] hex = HEX;
        int i = 0;
        while (i < len) {
            int c = value[i] & 0xFF;
            builder.append(hex[c >>> 4]).append(hex[c & 0xF]);
            ++i;
        }
        return builder;
    }

    public static StringBuilder appendHex(StringBuilder builder, long x, int bytes) {
        char[] hex = HEX;
        int i = bytes * 8;
        while (i > 0) {
            builder.append(hex[(int)(x >> (i -= 4)) & 0xF]).append(hex[(int)(x >> (i -= 4)) & 0xF]);
        }
        return builder;
    }

    public static boolean isNumber(String s) {
        int l = s.length();
        if (l == 0) {
            return false;
        }
        int i = 0;
        while (i < l) {
            if (!Character.isDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isWhitespaceOrEmpty(String s) {
        int i = 0;
        int l = s.length();
        while (i < l) {
            if (s.charAt(i) > ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static StringBuilder appendTwoDigits(StringBuilder builder, int positiveValue) {
        if (positiveValue < 10) {
            builder.append('0');
        }
        return builder.append(positiveValue);
    }

    public static StringBuilder appendZeroPadded(StringBuilder builder, int length, int positiveValue) {
        String s = Integer.toString(positiveValue);
        length -= s.length();
        while (length > 0) {
            builder.append('0');
            --length;
        }
        return builder.append(s);
    }

    public static StringBuilder appendToLength(StringBuilder builder, String s, int length) {
        int builderLength = builder.length();
        if (builderLength < length) {
            int need = length - builderLength;
            if (need >= s.length()) {
                builder.append(s);
            } else {
                builder.append(s, 0, need);
            }
        }
        return builder;
    }

    public static String escapeMetaDataPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return pattern;
        }
        return StringUtils.replaceAll(pattern, "\\", "\\\\");
    }

    public static boolean startsWith(String text, String prefix) {
        return text.startsWith(prefix);
    }

    public static boolean startsWithIgnoringCase(String text, String prefix) {
        if (text.length() < prefix.length()) {
            return false;
        }
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        return collator.equals(text.substring(0, prefix.length()), prefix);
    }
}

