/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.h2.engine.SysProperties;
import org.h2.mvstore.db.MVTable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ThreadDeadlockDetector {
    private static final String INDENT = "    ";
    private static ThreadDeadlockDetector detector;
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    private ThreadDeadlockDetector() {
        Timer threadCheck = new Timer("ThreadDeadlockDetector", true);
        threadCheck.schedule(new TimerTask(){

            @Override
            public void run() {
                ThreadDeadlockDetector.this.checkForDeadlocks();
            }
        }, 10L, 10000L);
    }

    public static synchronized void init() {
        if (detector == null) {
            detector = new ThreadDeadlockDetector();
        }
    }

    void checkForDeadlocks() {
        long[] deadlockedThreadIds = this.threadBean.findDeadlockedThreads();
        if (deadlockedThreadIds == null) {
            return;
        }
        ThreadDeadlockDetector.dumpThreadsAndLocks("ThreadDeadlockDetector - deadlock found :", this.threadBean, deadlockedThreadIds, System.out);
    }

    public static void dumpAllThreadsAndLocks(String msg) {
        ThreadDeadlockDetector.dumpAllThreadsAndLocks(msg, System.out);
    }

    public static void dumpAllThreadsAndLocks(String msg, PrintStream out) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] allThreadIds = threadBean.getAllThreadIds();
        ThreadDeadlockDetector.dumpThreadsAndLocks(msg, threadBean, allThreadIds, out);
    }

    private static void dumpThreadsAndLocks(String msg, ThreadMXBean threadBean, long[] threadIds, PrintStream out) {
        ThreadInfo[] infos;
        HashMap<Long, ArrayList<String>> tableSharedLocksMap;
        HashMap<Long, ArrayList<String>> tableExclusiveLocksMap;
        HashMap<Long, String> tableWaitingForLockMap;
        StringWriter stringWriter = new StringWriter();
        PrintWriter print = new PrintWriter(stringWriter);
        print.println(msg);
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            tableWaitingForLockMap = MVTable.WAITING_FOR_LOCK.getSnapshotOfAllThreads();
            tableExclusiveLocksMap = MVTable.EXCLUSIVE_LOCKS.getSnapshotOfAllThreads();
            tableSharedLocksMap = MVTable.SHARED_LOCKS.getSnapshotOfAllThreads();
        } else {
            tableWaitingForLockMap = new HashMap();
            tableExclusiveLocksMap = new HashMap();
            tableSharedLocksMap = new HashMap();
        }
        ThreadInfo[] threadInfoArray = infos = threadBean.getThreadInfo(threadIds, true, true);
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo ti = threadInfoArray[n2];
            ThreadDeadlockDetector.printThreadInfo(print, ti);
            ThreadDeadlockDetector.printLockInfo(print, ti.getLockedSynchronizers(), tableWaitingForLockMap.get(ti.getThreadId()), tableExclusiveLocksMap.get(ti.getThreadId()), tableSharedLocksMap.get(ti.getThreadId()));
            ++n2;
        }
        print.flush();
        out.println(stringWriter.getBuffer());
        out.flush();
    }

    private static void printThreadInfo(PrintWriter print, ThreadInfo ti) {
        ThreadDeadlockDetector.printThread(print, ti);
        StackTraceElement[] stackTrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        int i = 0;
        while (i < stackTrace.length) {
            StackTraceElement e = stackTrace[i];
            print.println("    at " + e.toString());
            MonitorInfo[] monitorInfoArray = monitors;
            int n = monitors.length;
            int n2 = 0;
            while (n2 < n) {
                MonitorInfo mi = monitorInfoArray[n2];
                if (mi.getLockedStackDepth() == i) {
                    print.println("      - locked " + String.valueOf(mi));
                }
                ++n2;
            }
            ++i;
        }
        print.println();
    }

    private static void printThread(PrintWriter print, ThreadInfo ti) {
        print.print("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " in " + String.valueOf((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            print.append(" on lock=").append(ti.getLockName());
        }
        if (ti.isSuspended()) {
            print.append(" (suspended)");
        }
        if (ti.isInNative()) {
            print.append(" (running in native)");
        }
        print.println();
        if (ti.getLockOwnerName() != null) {
            print.println("     owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
    }

    private static void printLockInfo(PrintWriter print, LockInfo[] locks, String tableWaitingForLock, ArrayList<String> tableExclusiveLocks, ArrayList<String> tableSharedLocksMap) {
        print.println("    Locked synchronizers: count = " + locks.length);
        LockInfo[] lockInfoArray = locks;
        int n = locks.length;
        int n2 = 0;
        while (n2 < n) {
            LockInfo li = lockInfoArray[n2];
            print.println("      - " + String.valueOf(li));
            ++n2;
        }
        if (tableWaitingForLock != null) {
            print.println("    Waiting for table: " + tableWaitingForLock);
        }
        if (tableExclusiveLocks != null) {
            print.println("    Exclusive table locks: count = " + tableExclusiveLocks.size());
            for (String name : tableExclusiveLocks) {
                print.println("      - " + name);
            }
        }
        if (tableSharedLocksMap != null) {
            print.println("    Shared table locks: count = " + tableSharedLocksMap.size());
            for (String name : tableSharedLocksMap) {
                print.println("      - " + name);
            }
        }
        print.println();
    }
}

