/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Utils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final HashMap<String, byte[]> RESOURCES = new HashMap();

    private Utils() {
    }

    public static int indexOf(byte[] bytes, byte[] pattern, int start) {
        if (pattern.length == 0) {
            return start;
        }
        if (start > bytes.length) {
            return -1;
        }
        int last = bytes.length - pattern.length + 1;
        int patternLen = pattern.length;
        while (start < last) {
            block5: {
                int i = 0;
                while (i < patternLen) {
                    if (bytes[start + i] == pattern[i]) {
                        ++i;
                        continue;
                    }
                    break block5;
                }
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static int getByteArrayHash(byte[] value) {
        int len;
        int h = len = value.length;
        if (len < 50) {
            int i = 0;
            while (i < len) {
                h = 31 * h + value[i];
                ++i;
            }
        } else {
            int step = len / 16;
            int i = 0;
            while (i < 4) {
                h = 31 * h + value[i];
                h = 31 * h + value[--len];
                ++i;
            }
            i = 4 + step;
            while (i < len) {
                h = 31 * h + value[i];
                i += step;
            }
        }
        return h;
    }

    public static boolean compareSecure(byte[] test, byte[] good) {
        if (test == null || good == null) {
            return test == null && good == null;
        }
        int len = test.length;
        if (len != good.length) {
            return false;
        }
        if (len == 0) {
            return true;
        }
        int bits = 0;
        int i = 0;
        while (i < len) {
            bits |= test[i] ^ good[i];
            ++i;
        }
        return bits == 0;
    }

    public static byte[] copy(byte[] source, byte[] target) {
        int len = source.length;
        if (len > target.length) {
            target = new byte[len];
        }
        System.arraycopy(source, 0, target, 0, len);
        return target;
    }

    public static byte[] newBytes(int len) {
        if (len == 0) {
            return EMPTY_BYTES;
        }
        try {
            return new byte[len];
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryError e2 = new OutOfMemoryError("Requested memory: " + len);
            e2.initCause(e);
            throw e2;
        }
    }

    public static byte[] copyBytes(byte[] bytes, int len) {
        if (len == 0) {
            return EMPTY_BYTES;
        }
        try {
            return Arrays.copyOf(bytes, len);
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryError e2 = new OutOfMemoryError("Requested memory: " + len);
            e2.initCause(e);
            throw e2;
        }
    }

    public static byte[] cloneByteArray(byte[] b) {
        if (b == null) {
            return null;
        }
        int len = b.length;
        if (len == 0) {
            return EMPTY_BYTES;
        }
        return Arrays.copyOf(b, len);
    }

    public static long getMemoryUsed() {
        Utils.collectGarbage();
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory() >> 10;
    }

    public static long getMemoryFree() {
        Utils.collectGarbage();
        return Runtime.getRuntime().freeMemory() >> 10;
    }

    public static long getMemoryMax() {
        return Runtime.getRuntime().maxMemory() >> 10;
    }

    public static long getGarbageCollectionTime() {
        long totalGCTime = 0L;
        for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long collectionTime = gcMXBean.getCollectionTime();
            if (collectionTime <= 0L) continue;
            totalGCTime += collectionTime;
        }
        return totalGCTime;
    }

    public static long getGarbageCollectionCount() {
        long totalGCCount = 0L;
        int poolCount = 0;
        for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long collectionCount = gcMXBean.getCollectionTime();
            if (collectionCount <= 0L) continue;
            totalGCCount += collectionCount;
            poolCount += gcMXBean.getMemoryPoolNames().length;
        }
        poolCount = Math.max(poolCount, 1);
        return (totalGCCount + (long)(poolCount >> 1)) / (long)poolCount;
    }

    public static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long garbageCollectionCount = Utils.getGarbageCollectionCount();
        while (garbageCollectionCount == Utils.getGarbageCollectionCount()) {
            runtime.gc();
            Thread.yield();
        }
    }

    public static <T> ArrayList<T> newSmallArrayList() {
        return new ArrayList(4);
    }

    public static <X> void sortTopN(X[] array, int fromInclusive, int toExclusive, Comparator<? super X> comp) {
        int highInclusive = array.length - 1;
        if (highInclusive > 0 && toExclusive > fromInclusive) {
            Utils.partialQuickSort(array, 0, highInclusive, comp, fromInclusive, toExclusive - 1);
            Arrays.sort(array, fromInclusive, toExclusive, comp);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static <X> void partialQuickSort(X[] array, int low, int high, Comparator<? super X> comp, int start, int end) {
        if (low >= start && high <= end) {
            return;
        }
        i = low;
        j = high;
        p = low + MathUtils.randomInt(high - low);
        pivot = array[p];
        m = low + high >>> 1;
        temp = array[m];
        array[m] = pivot;
        array[p] = temp;
        ** GOTO lbl22
        {
            ++i;
            do {
                if (comp.compare(array[i], pivot) < 0) continue block0;
                while (comp.compare(array[j], pivot) > 0) {
                    --j;
                }
                if (i > j) continue;
                temp = array[i];
                array[i++] = array[j];
                array[j--] = temp;
lbl22:
                // 3 sources

            } while (i <= j);
        }
        if (low < j && start <= j) {
            Utils.partialQuickSort(array, low, j, comp, start, end);
        }
        if (i < high && i <= end) {
            Utils.partialQuickSort(array, i, high, comp, start, end);
        }
    }

    public static byte[] getResource(String name) throws IOException {
        byte[] data = RESOURCES.get(name);
        if (data == null && (data = Utils.loadResource(name)) != null) {
            RESOURCES.put(name, data);
        }
        return data;
    }

    private static byte[] loadResource(String name) throws IOException {
        InputStream in = Utils.class.getResourceAsStream("data.zip");
        if (in == null) {
            in = Utils.class.getResourceAsStream(name);
            if (in == null) {
                return null;
            }
            return IOUtils.readBytesAndClose(in, 0);
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipInputStream zipIn = new ZipInputStream(in);){
                ZipEntry entry;
                while ((entry = zipIn.getNextEntry()) != null) {
                    Object entryName = entry.getName();
                    if (!((String)entryName).startsWith("/")) {
                        entryName = "/" + (String)entryName;
                    }
                    if (((String)entryName).equals(name)) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOUtils.copy(zipIn, (OutputStream)out);
                        zipIn.closeEntry();
                        return out.toByteArray();
                    }
                    zipIn.closeEntry();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object callStaticMethod(String classAndMethod, Object ... params) throws Exception {
        int lastDot = classAndMethod.lastIndexOf(46);
        String className = classAndMethod.substring(0, lastDot);
        String methodName = classAndMethod.substring(lastDot + 1);
        return Utils.callMethod(null, Class.forName(className), methodName, params);
    }

    public static Object callMethod(Object instance, String methodName, Object ... params) throws Exception {
        return Utils.callMethod(instance, instance.getClass(), methodName, params);
    }

    private static Object callMethod(Object instance, Class<?> clazz, String methodName, Object ... params) throws Exception {
        Method best = null;
        int bestMatch = 0;
        boolean isStatic = instance == null;
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            int p;
            Method m = methodArray[n2];
            if (Modifier.isStatic(m.getModifiers()) == isStatic && m.getName().equals(methodName) && (p = Utils.match(m.getParameterTypes(), params)) > bestMatch) {
                bestMatch = p;
                best = m;
            }
            ++n2;
        }
        if (best == null) {
            throw new NoSuchMethodException(methodName);
        }
        return best.invoke(instance, params);
    }

    public static Object newInstance(String className, Object ... params) throws Exception {
        Constructor<?> best = null;
        int bestMatch = 0;
        Constructor<?>[] constructorArray = Class.forName(className).getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            int p = Utils.match(c.getParameterTypes(), params);
            if (p > bestMatch) {
                bestMatch = p;
                best = c;
            }
            ++n2;
        }
        if (best == null) {
            throw new NoSuchMethodException(className);
        }
        return best.newInstance(params);
    }

    private static int match(Class<?>[] params, Object[] values) {
        int len = params.length;
        if (len == values.length) {
            int points = 1;
            int i = 0;
            while (i < len) {
                Class<?> vc;
                Class<?> pc = Utils.getNonPrimitiveClass(params[i]);
                Object v = values[i];
                Class<?> clazz = vc = v == null ? null : v.getClass();
                if (pc == vc) {
                    ++points;
                } else if (vc != null && !pc.isAssignableFrom(vc)) {
                    return 0;
                }
                ++i;
            }
            return points;
        }
        return 0;
    }

    public static Class<?> getNonPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static boolean parseBoolean(String value, boolean defaultValue, boolean throwException) {
        if (value == null) {
            return defaultValue;
        }
        switch (value.length()) {
            case 1: {
                if (value.equals("1") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("y")) {
                    return true;
                }
                if (!value.equals("0") && !value.equalsIgnoreCase("f") && !value.equalsIgnoreCase("n")) break;
                return false;
            }
            case 2: {
                if (!value.equalsIgnoreCase("no")) break;
                return false;
            }
            case 3: {
                if (!value.equalsIgnoreCase("yes")) break;
                return true;
            }
            case 4: {
                if (!value.equalsIgnoreCase("true")) break;
                return true;
            }
            case 5: {
                if (!value.equalsIgnoreCase("false")) break;
                return false;
            }
        }
        if (throwException) {
            throw new IllegalArgumentException(value);
        }
        return defaultValue;
    }

    public static String getProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    public static int getProperty(String key, int defaultValue) {
        String s = Utils.getProperty(key, null);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        return Utils.parseBoolean(Utils.getProperty(key, null), defaultValue, false);
    }

    public static int scaleForAvailableMemory(int value) {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory != Long.MAX_VALUE) {
            return (int)((long)value * maxMemory / 0x40000000L);
        }
        try {
            OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
            Method method = Class.forName("com.sun.management.OperatingSystemMXBean").getMethod("getTotalPhysicalMemorySize", new Class[0]);
            long physicalMemorySize = ((Number)method.invoke((Object)mxBean, new Object[0])).longValue();
            return (int)((long)value * physicalMemorySize / 0x40000000L);
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        return value;
    }

    public static long currentNanoTime() {
        long time = System.nanoTime();
        if (time == 0L) {
            time = 1L;
        }
        return time;
    }

    public static long currentNanoTimePlusMillis(int ms) {
        return Utils.nanoTimePlusMillis(System.nanoTime(), ms);
    }

    public static long nanoTimePlusMillis(long nanoTime, int ms) {
        long time = nanoTime + (long)ms * 1000000L;
        if (time == 0L) {
            time = 1L;
        }
        return time;
    }

    public static ThreadPoolExecutor createSingleThreadExecutor(String threadName) {
        return Utils.createSingleThreadExecutor(threadName, new LinkedBlockingQueue<Runnable>());
    }

    public static ThreadPoolExecutor createSingleThreadExecutor(String threadName, BlockingQueue<Runnable> workQueue) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, workQueue, r -> {
            Thread thread = new Thread(r, threadName);
            thread.setDaemon(true);
            return thread;
        });
    }

    public static void flushExecutor(ThreadPoolExecutor executor) {
        if (executor != null) {
            try {
                executor.submit(() -> {}).get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (RejectedExecutionException ex) {
                Utils.shutdownExecutor(executor);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void shutdownExecutor(ThreadPoolExecutor executor) {
        if (executor != null) {
            executor.shutdown();
            try {
                executor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ClassFactory {
        public boolean match(String var1);

        public Class<?> loadClass(String var1) throws ClassNotFoundException;
    }
}

