/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.geometry;

import java.io.ByteArrayOutputStream;
import org.h2.util.Bits;
import org.h2.util.StringUtils;
import org.h2.util.geometry.GeometryUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class EWKBUtils {
    public static final int EWKB_Z = Integer.MIN_VALUE;
    public static final int EWKB_M = 0x40000000;
    public static final int EWKB_SRID = 0x20000000;

    public static byte[] ewkb2ewkb(byte[] ewkb) {
        return EWKBUtils.ewkb2ewkb(ewkb, EWKBUtils.getDimensionSystem(ewkb));
    }

    public static byte[] ewkb2ewkb(byte[] ewkb, int dimensionSystem) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        EWKBTarget target = new EWKBTarget(output, dimensionSystem);
        EWKBUtils.parseEWKB(ewkb, target);
        return output.toByteArray();
    }

    public static void parseEWKB(byte[] ewkb, GeometryUtils.Target target) {
        try {
            EWKBUtils.parseEWKB(new EWKBSource(ewkb), target, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    public static int type2dimensionSystem(int type) {
        boolean useZ = (type & Integer.MIN_VALUE) != 0;
        boolean useM = (type & 0x40000000) != 0;
        switch ((type &= 0xFFFF) / 1000) {
            case 1: {
                useZ = true;
                break;
            }
            case 3: {
                useZ = true;
            }
            case 2: {
                useM = true;
            }
        }
        return (useZ ? 1 : 0) | (useM ? 2 : 0);
    }

    private static void parseEWKB(EWKBSource source, GeometryUtils.Target target, int parentType) {
        int srid;
        switch (source.readByte()) {
            case 0: {
                source.bigEndian = true;
                break;
            }
            case 1: {
                source.bigEndian = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int type = source.readInt();
        boolean useZ = (type & Integer.MIN_VALUE) != 0;
        boolean useM = (type & 0x40000000) != 0;
        int n = srid = (type & 0x20000000) != 0 ? source.readInt() : 0;
        if (parentType == 0) {
            target.init(srid);
        }
        switch ((type &= 0xFFFF) / 1000) {
            case 1: {
                useZ = true;
                break;
            }
            case 3: {
                useZ = true;
            }
            case 2: {
                useM = true;
            }
        }
        target.dimensionSystem((useZ ? 1 : 0) | (useM ? 2 : 0));
        switch (type %= 1000) {
            case 1: {
                if (parentType != 0 && parentType != 4 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                target.startPoint();
                EWKBUtils.addCoordinate(source, target, useZ, useM, 0, 1);
                break;
            }
            case 2: {
                if (parentType != 0 && parentType != 5 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                int numPoints = source.readInt();
                if (numPoints < 0 || numPoints == 1) {
                    throw new IllegalArgumentException();
                }
                target.startLineString(numPoints);
                int i = 0;
                while (i < numPoints) {
                    EWKBUtils.addCoordinate(source, target, useZ, useM, i, numPoints);
                    ++i;
                }
                break;
            }
            case 3: {
                if (parentType != 0 && parentType != 6 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                int numRings = source.readInt();
                if (numRings == 0) {
                    target.startPolygon(0, 0);
                    break;
                }
                if (numRings < 0) {
                    throw new IllegalArgumentException();
                }
                --numRings;
                int size = source.readInt();
                if (size < 0 || size >= 1 && size <= 3) {
                    throw new IllegalArgumentException();
                }
                if (size == 0 && numRings > 0) {
                    throw new IllegalArgumentException();
                }
                target.startPolygon(numRings, size);
                if (size <= 0) break;
                EWKBUtils.addRing(source, target, useZ, useM, size);
                int i = 0;
                while (i < numRings) {
                    size = source.readInt();
                    if (size < 0 || size >= 1 && size <= 3) {
                        throw new IllegalArgumentException();
                    }
                    target.startPolygonInner(size);
                    EWKBUtils.addRing(source, target, useZ, useM, size);
                    ++i;
                }
                target.endNonEmptyPolygon();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (parentType != 0 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                int numItems = source.readInt();
                if (numItems < 0) {
                    throw new IllegalArgumentException();
                }
                target.startCollection(type, numItems);
                int i = 0;
                while (i < numItems) {
                    GeometryUtils.Target innerTarget = target.startCollectionItem(i, numItems);
                    EWKBUtils.parseEWKB(source, innerTarget, type);
                    target.endCollectionItem(innerTarget, type, i, numItems);
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        target.endObject(type);
    }

    private static void addRing(EWKBSource source, GeometryUtils.Target target, boolean useZ, boolean useM, int size) {
        if (size >= 4) {
            double startX = source.readCoordinate();
            double startY = source.readCoordinate();
            target.addCoordinate(startX, startY, useZ ? source.readCoordinate() : Double.NaN, useM ? source.readCoordinate() : Double.NaN, 0, size);
            int i = 1;
            while (i < size - 1) {
                EWKBUtils.addCoordinate(source, target, useZ, useM, i, size);
                ++i;
            }
            double endX = source.readCoordinate();
            double endY = source.readCoordinate();
            if (startX != endX || startY != endY) {
                throw new IllegalArgumentException();
            }
            target.addCoordinate(endX, endY, useZ ? source.readCoordinate() : Double.NaN, useM ? source.readCoordinate() : Double.NaN, size - 1, size);
        }
    }

    private static void addCoordinate(EWKBSource source, GeometryUtils.Target target, boolean useZ, boolean useM, int index, int total) {
        target.addCoordinate(source.readCoordinate(), source.readCoordinate(), useZ ? source.readCoordinate() : Double.NaN, useM ? source.readCoordinate() : Double.NaN, index, total);
    }

    public static int getDimensionSystem(byte[] ewkb) {
        EWKBSource source = new EWKBSource(ewkb);
        switch (source.readByte()) {
            case 0: {
                source.bigEndian = true;
                break;
            }
            case 1: {
                source.bigEndian = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return EWKBUtils.type2dimensionSystem(source.readInt());
    }

    public static byte[] envelope2wkb(double[] envelope) {
        byte[] result;
        if (envelope == null) {
            return null;
        }
        double minX = envelope[0];
        double maxX = envelope[1];
        double minY = envelope[2];
        double maxY = envelope[3];
        if (minX == maxX && minY == maxY) {
            result = new byte[21];
            result[4] = 1;
            Bits.DOUBLE_VH_BE.set(result, 5, minX);
            Bits.DOUBLE_VH_BE.set(result, 13, minY);
        } else if (minX == maxX || minY == maxY) {
            result = new byte[41];
            result[4] = 2;
            result[8] = 2;
            Bits.DOUBLE_VH_BE.set(result, 9, minX);
            Bits.DOUBLE_VH_BE.set(result, 17, minY);
            Bits.DOUBLE_VH_BE.set(result, 25, maxX);
            Bits.DOUBLE_VH_BE.set(result, 33, maxY);
        } else {
            result = new byte[93];
            result[4] = 3;
            result[8] = 1;
            result[12] = 5;
            Bits.DOUBLE_VH_BE.set(result, 13, minX);
            Bits.DOUBLE_VH_BE.set(result, 21, minY);
            Bits.DOUBLE_VH_BE.set(result, 29, minX);
            Bits.DOUBLE_VH_BE.set(result, 37, maxY);
            Bits.DOUBLE_VH_BE.set(result, 45, maxX);
            Bits.DOUBLE_VH_BE.set(result, 53, maxY);
            Bits.DOUBLE_VH_BE.set(result, 61, maxX);
            Bits.DOUBLE_VH_BE.set(result, 69, minY);
            Bits.DOUBLE_VH_BE.set(result, 77, minX);
            Bits.DOUBLE_VH_BE.set(result, 85, minY);
        }
        return result;
    }

    private EWKBUtils() {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class EWKBSource {
        private final byte[] ewkb;
        private int offset;
        boolean bigEndian;

        EWKBSource(byte[] ewkb) {
            this.ewkb = ewkb;
        }

        byte readByte() {
            return this.ewkb[this.offset++];
        }

        int readInt() {
            int result = this.bigEndian ? Bits.INT_VH_BE.get(this.ewkb, this.offset) : Bits.INT_VH_LE.get(this.ewkb, this.offset);
            this.offset += 4;
            return result;
        }

        double readCoordinate() {
            double v = this.bigEndian ? Bits.DOUBLE_VH_BE.get(this.ewkb, this.offset) : Bits.DOUBLE_VH_LE.get(this.ewkb, this.offset);
            this.offset += 8;
            return GeometryUtils.toCanonicalDouble(v);
        }

        public String toString() {
            String s = StringUtils.convertBytesToHex(this.ewkb);
            int idx = this.offset * 2;
            return new StringBuilder(s.length() + 3).append(s, 0, idx).append("<*>").append(s, idx, s.length()).toString();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class EWKBTarget
    extends GeometryUtils.Target {
        private final ByteArrayOutputStream output;
        private final int dimensionSystem;
        private final byte[] buf = new byte[8];
        private int type;
        private int srid;

        public EWKBTarget(ByteArrayOutputStream output, int dimensionSystem) {
            this.output = output;
            this.dimensionSystem = dimensionSystem;
        }

        @Override
        protected void init(int srid) {
            this.srid = srid;
        }

        @Override
        protected void startPoint() {
            this.writeHeader(1);
        }

        @Override
        protected void startLineString(int numPoints) {
            this.writeHeader(2);
            this.writeInt(numPoints);
        }

        @Override
        protected void startPolygon(int numInner, int numPoints) {
            this.writeHeader(3);
            if (numInner == 0 && numPoints == 0) {
                this.writeInt(0);
            } else {
                this.writeInt(numInner + 1);
                this.writeInt(numPoints);
            }
        }

        @Override
        protected void startPolygonInner(int numInner) {
            this.writeInt(numInner);
        }

        @Override
        protected void startCollection(int type, int numItems) {
            this.writeHeader(type);
            this.writeInt(numItems);
        }

        private void writeHeader(int type) {
            this.type = type;
            switch (this.dimensionSystem) {
                case 1: {
                    type |= Integer.MIN_VALUE;
                    break;
                }
                case 3: {
                    type |= Integer.MIN_VALUE;
                }
                case 2: {
                    type |= 0x40000000;
                }
            }
            if (this.srid != 0) {
                type |= 0x20000000;
            }
            this.output.write(0);
            this.writeInt(type);
            if (this.srid != 0) {
                this.writeInt(this.srid);
                this.srid = 0;
            }
        }

        @Override
        protected GeometryUtils.Target startCollectionItem(int index, int total) {
            return this;
        }

        @Override
        protected void addCoordinate(double x, double y, double z, double m, int index, int total) {
            boolean check;
            boolean bl = check = this.type != 1 || !Double.isNaN(x) || !Double.isNaN(y) || !Double.isNaN(z) || !Double.isNaN(m);
            if (check) {
                GeometryUtils.checkFinite(x);
                GeometryUtils.checkFinite(y);
            }
            this.writeDouble(x);
            this.writeDouble(y);
            if ((this.dimensionSystem & 1) != 0) {
                this.writeDouble(check ? GeometryUtils.checkFinite(z) : z);
            } else if (check && !Double.isNaN(z)) {
                throw new IllegalArgumentException();
            }
            if ((this.dimensionSystem & 2) != 0) {
                this.writeDouble(check ? GeometryUtils.checkFinite(m) : m);
            } else if (check && !Double.isNaN(m)) {
                throw new IllegalArgumentException();
            }
        }

        private void writeInt(int v) {
            Bits.INT_VH_BE.set(this.buf, 0, v);
            this.output.write(this.buf, 0, 4);
        }

        private void writeDouble(double v) {
            v = GeometryUtils.toCanonicalDouble(v);
            Bits.DOUBLE_VH_BE.set(this.buf, 0, v);
            this.output.write(this.buf, 0, 8);
        }
    }
}

