/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.geometry;

import org.h2.util.geometry.EWKBUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class GeometryUtils {
    public static final int POINT = 1;
    public static final int LINE_STRING = 2;
    public static final int POLYGON = 3;
    public static final int MULTI_POINT = 4;
    public static final int MULTI_LINE_STRING = 5;
    public static final int MULTI_POLYGON = 6;
    public static final int GEOMETRY_COLLECTION = 7;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int M = 3;
    public static final int DIMENSION_SYSTEM_XY = 0;
    public static final int DIMENSION_SYSTEM_XYZ = 1;
    public static final int DIMENSION_SYSTEM_XYM = 2;
    public static final int DIMENSION_SYSTEM_XYZM = 3;
    public static final int MIN_X = 0;
    public static final int MAX_X = 1;
    public static final int MIN_Y = 2;
    public static final int MAX_Y = 3;

    public static double[] getEnvelope(byte[] ewkb) {
        EnvelopeTarget target = new EnvelopeTarget();
        EWKBUtils.parseEWKB(ewkb, target);
        return target.getEnvelope();
    }

    public static boolean intersects(double[] envelope1, double[] envelope2) {
        return envelope1 != null && envelope2 != null && envelope1[1] >= envelope2[0] && envelope1[0] <= envelope2[1] && envelope1[3] >= envelope2[2] && envelope1[2] <= envelope2[3];
    }

    public static double[] union(double[] envelope1, double[] envelope2) {
        double[] dArray;
        if (envelope1 == null) {
            return envelope2;
        }
        if (envelope2 == null) {
            return envelope1;
        }
        double minX1 = envelope1[0];
        double maxX1 = envelope1[1];
        double minY1 = envelope1[2];
        double maxY1 = envelope1[3];
        double minX2 = envelope2[0];
        double maxX2 = envelope2[1];
        double minY2 = envelope2[2];
        double maxY2 = envelope2[3];
        boolean modified = false;
        if (minX1 > minX2) {
            minX1 = minX2;
            modified = true;
        }
        if (maxX1 < maxX2) {
            maxX1 = maxX2;
            modified = true;
        }
        if (minY1 > minY2) {
            minY1 = minY2;
            modified = true;
        }
        if (maxY1 < maxY2) {
            maxY1 = maxY2;
            modified = true;
        }
        if (modified) {
            double[] dArray2 = new double[4];
            dArray2[0] = minX1;
            dArray2[1] = maxX1;
            dArray2[2] = minY1;
            dArray = dArray2;
            dArray2[3] = maxY1;
        } else {
            dArray = envelope1;
        }
        return dArray;
    }

    static double toCanonicalDouble(double d) {
        return Double.isNaN(d) ? Double.NaN : (d == 0.0 ? 0.0 : d);
    }

    static double checkFinite(double d) {
        if (!Double.isFinite(d)) {
            throw new IllegalArgumentException();
        }
        return d;
    }

    private GeometryUtils() {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class DimensionSystemTarget
    extends Target {
        private boolean hasZ;
        private boolean hasM;

        @Override
        protected void dimensionSystem(int dimensionSystem) {
            if ((dimensionSystem & 1) != 0) {
                this.hasZ = true;
            }
            if ((dimensionSystem & 2) != 0) {
                this.hasM = true;
            }
        }

        @Override
        protected void addCoordinate(double x, double y, double z, double m, int index, int total) {
            if (!this.hasZ && !Double.isNaN(z)) {
                this.hasZ = true;
            }
            if (!this.hasM && !Double.isNaN(m)) {
                this.hasM = true;
            }
        }

        public int getDimensionSystem() {
            return (this.hasZ ? 1 : 0) | (this.hasM ? 2 : 0);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class EnvelopeTarget
    extends Target {
        private boolean enabled;
        private boolean set;
        private double minX;
        private double maxX;
        private double minY;
        private double maxY;

        @Override
        protected void startPoint() {
            this.enabled = true;
        }

        @Override
        protected void startLineString(int numPoints) {
            this.enabled = true;
        }

        @Override
        protected void startPolygon(int numInner, int numPoints) {
            this.enabled = true;
        }

        @Override
        protected void startPolygonInner(int numInner) {
            this.enabled = false;
        }

        @Override
        protected void addCoordinate(double x, double y, double z, double m, int index, int total) {
            if (this.enabled && !Double.isNaN(x) && !Double.isNaN(y)) {
                if (!this.set) {
                    this.minX = this.maxX = x;
                    this.minY = this.maxY = y;
                    this.set = true;
                } else {
                    if (this.minX > x) {
                        this.minX = x;
                    }
                    if (this.maxX < x) {
                        this.maxX = x;
                    }
                    if (this.minY > y) {
                        this.minY = y;
                    }
                    if (this.maxY < y) {
                        this.maxY = y;
                    }
                }
            }
        }

        public double[] getEnvelope() {
            double[] dArray;
            if (this.set) {
                double[] dArray2 = new double[4];
                dArray2[0] = this.minX;
                dArray2[1] = this.maxX;
                dArray2[2] = this.minY;
                dArray = dArray2;
                dArray2[3] = this.maxY;
            } else {
                dArray = null;
            }
            return dArray;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static abstract class Target {
        protected void init(int srid) {
        }

        protected void dimensionSystem(int dimensionSystem) {
        }

        protected void startPoint() {
        }

        protected void startLineString(int numPoints) {
        }

        protected void startPolygon(int numInner, int numPoints) {
        }

        protected void startPolygonInner(int numInner) {
        }

        protected void endNonEmptyPolygon() {
        }

        protected void startCollection(int type, int numItems) {
        }

        protected Target startCollectionItem(int index, int total) {
            return this;
        }

        protected void endCollectionItem(Target target, int type, int index, int total) {
        }

        protected void endObject(int type) {
        }

        protected abstract void addCoordinate(double var1, double var3, double var5, double var7, int var9, int var10);
    }
}

