/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.json;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Function;
import org.h2.util.json.JSONTarget;
import org.h2.util.json.JSONValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JSONArray
extends JSONValue {
    private final ArrayList<JSONValue> elements = new ArrayList();

    JSONArray() {
    }

    void addElement(JSONValue value) {
        this.elements.add(value);
    }

    @Override
    public void addTo(JSONTarget<?> target) {
        target.startArray();
        for (JSONValue element : this.elements) {
            element.addTo(target);
        }
        target.endArray();
    }

    public int length() {
        return this.elements.size();
    }

    public JSONValue[] getArray() {
        return this.elements.toArray(new JSONValue[0]);
    }

    public <E> E[] getArray(Class<E> elementType, Function<JSONValue, E> converter) {
        int length = this.elements.size();
        Object[] array = (Object[])Array.newInstance(elementType, length);
        int i = 0;
        while (i < length) {
            array[i] = converter.apply(this.elements.get(i));
            ++i;
        }
        return array;
    }

    public JSONValue getElement(int index) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }
}

