/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.json;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import org.h2.util.json.JSONTarget;
import org.h2.util.json.JSONValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JSONObject
extends JSONValue {
    private final ArrayList<AbstractMap.SimpleImmutableEntry<String, JSONValue>> members = new ArrayList();

    JSONObject() {
    }

    void addMember(String name, JSONValue value) {
        this.members.add(new AbstractMap.SimpleImmutableEntry<String, JSONValue>(name, value));
    }

    @Override
    public void addTo(JSONTarget<?> target) {
        target.startObject();
        for (AbstractMap.SimpleImmutableEntry<String, JSONValue> member : this.members) {
            target.member(member.getKey());
            member.getValue().addTo(target);
        }
        target.endObject();
    }

    public Map.Entry<String, JSONValue>[] getMembers() {
        return this.members.toArray(new Map.Entry[0]);
    }

    public JSONValue getFirst(String name) {
        for (AbstractMap.SimpleImmutableEntry<String, JSONValue> entry : this.members) {
            if (!name.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }
}

