/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.json;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import org.h2.util.json.JSONArray;
import org.h2.util.json.JSONBoolean;
import org.h2.util.json.JSONNull;
import org.h2.util.json.JSONNumber;
import org.h2.util.json.JSONObject;
import org.h2.util.json.JSONString;
import org.h2.util.json.JSONTarget;
import org.h2.util.json.JSONValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JSONValueTarget
extends JSONTarget<JSONValue> {
    private final ArrayDeque<JSONValue> stack = new ArrayDeque();
    private final ArrayDeque<String> names = new ArrayDeque();
    private boolean needSeparator;
    private String memberName;
    private JSONValue result;

    @Override
    public void startObject() {
        this.beforeValue();
        this.names.push(this.memberName != null ? this.memberName : "");
        this.memberName = null;
        this.stack.push(new JSONObject());
    }

    @Override
    public void endObject() {
        if (this.memberName != null) {
            throw new IllegalStateException();
        }
        JSONValue value = this.stack.poll();
        if (!(value instanceof JSONObject)) {
            throw new IllegalStateException();
        }
        this.memberName = this.names.pop();
        this.afterValue(value);
    }

    @Override
    public void startArray() {
        this.beforeValue();
        this.names.push(this.memberName != null ? this.memberName : "");
        this.memberName = null;
        this.stack.push(new JSONArray());
    }

    @Override
    public void endArray() {
        JSONValue value = this.stack.poll();
        if (!(value instanceof JSONArray)) {
            throw new IllegalStateException();
        }
        this.memberName = this.names.pop();
        this.afterValue(value);
    }

    @Override
    public void member(String name) {
        if (this.memberName != null || !(this.stack.peek() instanceof JSONObject)) {
            throw new IllegalStateException();
        }
        this.memberName = name;
        this.beforeValue();
    }

    @Override
    public void valueNull() {
        this.beforeValue();
        this.afterValue(JSONNull.NULL);
    }

    @Override
    public void valueFalse() {
        this.beforeValue();
        this.afterValue(JSONBoolean.FALSE);
    }

    @Override
    public void valueTrue() {
        this.beforeValue();
        this.afterValue(JSONBoolean.TRUE);
    }

    @Override
    public void valueNumber(BigDecimal number) {
        this.beforeValue();
        this.afterValue(new JSONNumber(number));
    }

    @Override
    public void valueString(String string) {
        this.beforeValue();
        this.afterValue(new JSONString(string));
    }

    private void beforeValue() {
        if (this.memberName == null && this.stack.peek() instanceof JSONObject) {
            throw new IllegalStateException();
        }
        if (this.needSeparator) {
            if (this.stack.isEmpty()) {
                throw new IllegalStateException();
            }
            this.needSeparator = false;
        }
    }

    private void afterValue(JSONValue value) {
        JSONValue parent = this.stack.peek();
        if (parent == null) {
            this.result = value;
        } else if (parent instanceof JSONObject) {
            ((JSONObject)parent).addMember(this.memberName, value);
        } else {
            ((JSONArray)parent).addElement(value);
        }
        this.needSeparator = true;
        this.memberName = null;
    }

    @Override
    public boolean isPropertyExpected() {
        return this.memberName == null && this.stack.peek() instanceof JSONObject;
    }

    @Override
    public boolean isValueSeparatorExpected() {
        return this.needSeparator;
    }

    @Override
    public JSONValue getResult() {
        if (!this.stack.isEmpty() || this.result == null) {
            throw new IllegalStateException();
        }
        return this.result;
    }
}

