/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.nio.charset.Charset;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CharsetCollator
extends Collator {
    private final Charset charset;

    public CharsetCollator(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int compare(String source, String target) {
        return Arrays.compare(this.toBytes(source), this.toBytes(target));
    }

    byte[] toBytes(String source) {
        if (this.getStrength() <= 1) {
            source = source.toUpperCase(Locale.ROOT);
        }
        return source.getBytes(this.charset);
    }

    @Override
    public CollationKey getCollationKey(String source) {
        return new CharsetCollationKey(source);
    }

    @Override
    public int hashCode() {
        return 255;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class CharsetCollationKey
    extends CollationKey {
        private final byte[] bytes;

        CharsetCollationKey(String source) {
            super(source);
            this.bytes = CharsetCollator.this.toBytes(source);
        }

        @Override
        public int compareTo(CollationKey target) {
            return Arrays.compare(this.bytes, target.toByteArray());
        }

        @Override
        public byte[] toByteArray() {
            return this.bytes;
        }
    }
}

