/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueArray
extends ValueCollectionBase {
    public static final ValueArray EMPTY = ValueArray.get(TypeInfo.TYPE_NULL, Value.EMPTY_VALUES, null);
    private TypeInfo type;
    private final TypeInfo componentType;

    private ValueArray(TypeInfo componentType, Value[] list, CastDataProvider provider) {
        super(list);
        int length = list.length;
        if (length > 65536) {
            String typeName = ValueArray.getTypeName(this.getValueType());
            throw DbException.getValueTooLongException(typeName, typeName, length);
        }
        int i = 0;
        while (i < length) {
            list[i] = list[i].castTo(componentType, provider);
            ++i;
        }
        this.componentType = componentType;
    }

    public static ValueArray get(Value[] list, CastDataProvider provider) {
        return new ValueArray(TypeInfo.getHigherType(list), list, provider);
    }

    public static ValueArray get(TypeInfo componentType, Value[] list, CastDataProvider provider) {
        return new ValueArray(componentType, list, provider);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            TypeInfo componentType = this.getComponentType();
            this.type = type = TypeInfo.getTypeInfo(this.getValueType(), this.values.length, 0, componentType);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return 40;
    }

    public TypeInfo getComponentType() {
        return this.componentType;
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder().append('[');
        int i = 0;
        while (i < this.values.length) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.values[i].getString());
            ++i;
        }
        return builder.append(']').toString();
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        ValueArray v = (ValueArray)o;
        if (this.values == v.values) {
            return 0;
        }
        int l = this.values.length;
        int ol = v.values.length;
        int len = Math.min(l, ol);
        int i = 0;
        while (i < len) {
            Value v1 = this.values[i];
            Value v2 = v.values[i];
            int comp = v1.compareTo(v2, provider, mode);
            if (comp != 0) {
                return comp;
            }
            ++i;
        }
        return Integer.compare(l, ol);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        builder.append("ARRAY [");
        int length = this.values.length;
        int i = 0;
        while (i < length) {
            if (i > 0) {
                builder.append(", ");
            }
            this.values[i].getSQL(builder, sqlFlags);
            ++i;
        }
        return builder.append(']');
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueArray)) {
            return false;
        }
        ValueArray v = (ValueArray)other;
        if (this.values == v.values) {
            return true;
        }
        int len = this.values.length;
        if (len != v.values.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!this.values[i].equals(v.values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

