/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.nio.charset.StandardCharsets;
import org.h2.engine.SysProperties;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBytesBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueBinary
extends ValueBytesBase {
    private TypeInfo type;

    private ValueBinary(byte[] value) {
        super(value);
    }

    public static ValueBinary get(byte[] b) {
        return ValueBinary.getNoCopy(Utils.cloneByteArray(b));
    }

    public static ValueBinary getNoCopy(byte[] b) {
        ValueBinary obj = new ValueBinary(b);
        if (b.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueBinary)Value.cache(obj);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            long precision = this.value.length;
            this.type = type = new TypeInfo(5, precision, 0, null);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return 5;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0) {
            int length = this.value.length;
            return super.getSQL(builder.append("CAST("), sqlFlags).append(" AS BINARY(").append(length > 0 ? length : 1).append("))");
        }
        return super.getSQL(builder, sqlFlags);
    }

    @Override
    public String getString() {
        return new String(this.value, StandardCharsets.UTF_8);
    }
}

