/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ValueCollectionBase
extends Value {
    final Value[] values;
    private int hash;

    ValueCollectionBase(Value[] values) {
        this.values = values;
    }

    public Value[] getList() {
        return this.values;
    }

    @Override
    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = this.getValueType();
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            h = h * 31 + v.hashCode();
            ++n2;
        }
        this.hash = h;
        return h;
    }

    @Override
    public int compareWithNull(Value v, boolean forEquality, CastDataProvider provider, CompareMode compareMode) {
        if (v == ValueNull.INSTANCE) {
            return Integer.MIN_VALUE;
        }
        ValueCollectionBase l = this;
        int leftType = l.getValueType();
        int rightType = v.getValueType();
        if (rightType != leftType) {
            throw v.getDataConversionError(leftType);
        }
        ValueCollectionBase r = (ValueCollectionBase)v;
        Value[] leftArray = l.values;
        int leftLength = leftArray.length;
        Value[] rightArray = r.values;
        int rightLength = rightArray.length;
        if (leftLength != rightLength) {
            if (leftType == 41) {
                throw DbException.get(21002);
            }
            if (forEquality) {
                return 1;
            }
        }
        if (forEquality) {
            boolean hasNull = false;
            int i = 0;
            while (i < leftLength) {
                Value v1 = leftArray[i];
                Value v2 = rightArray[i];
                int comp = v1.compareWithNull(v2, forEquality, provider, compareMode);
                if (comp != 0) {
                    if (comp != Integer.MIN_VALUE) {
                        return comp;
                    }
                    hasNull = true;
                }
                ++i;
            }
            return hasNull ? Integer.MIN_VALUE : 0;
        }
        int len = Math.min(leftLength, rightLength);
        int i = 0;
        while (i < len) {
            Value v1 = leftArray[i];
            Value v2 = rightArray[i];
            int comp = v1.compareWithNull(v2, forEquality, provider, compareMode);
            if (comp != 0) {
                return comp;
            }
            ++i;
        }
        return Integer.compare(leftLength, rightLength);
    }

    @Override
    public boolean containsNull() {
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (v.containsNull()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    Value getValueWithFirstNullImpl(Value v) {
        ValueCollectionBase r = (ValueCollectionBase)v;
        Value[] leftArray = this.values;
        Value[] rightArray = r.values;
        int leftLength = leftArray.length;
        int rightLength = rightArray.length;
        int len = Math.min(leftLength, rightLength);
        int i = 0;
        while (i < len) {
            Value v1 = leftArray[i];
            Value v2 = rightArray[i];
            Value c = v1.getValueWithFirstNull(v2);
            if (c == v1) {
                return this;
            }
            if (c == v2) {
                return v;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getMemory() {
        int memory = 72 + this.values.length * 8;
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            memory += v.getMemory();
            ++n2;
        }
        return memory;
    }
}

