/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigDecimalBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueDecfloat
extends ValueBigDecimalBase {
    public static final ValueDecfloat ZERO = new ValueDecfloat(BigDecimal.ZERO);
    public static final ValueDecfloat ONE = new ValueDecfloat(BigDecimal.ONE);
    public static final ValueDecfloat POSITIVE_INFINITY = new ValueDecfloat(null);
    public static final ValueDecfloat NEGATIVE_INFINITY = new ValueDecfloat(null);
    public static final ValueDecfloat NAN = new ValueDecfloat(null);

    private ValueDecfloat(BigDecimal value) {
        super(value);
    }

    @Override
    public String getString() {
        if (this.value == null) {
            if (this == POSITIVE_INFINITY) {
                return "Infinity";
            }
            if (this == NEGATIVE_INFINITY) {
                return "-Infinity";
            }
            return "NaN";
        }
        return this.value.toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0) {
            return this.getSQL(builder.append("CAST(")).append(" AS DECFLOAT)");
        }
        return this.getSQL(builder);
    }

    private StringBuilder getSQL(StringBuilder builder) {
        if (this.value != null) {
            return builder.append(this.value);
        }
        if (this == POSITIVE_INFINITY) {
            return builder.append("'Infinity'");
        }
        if (this == NEGATIVE_INFINITY) {
            return builder.append("'-Infinity'");
        }
        return builder.append("'NaN'");
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            this.type = type = new TypeInfo(16, this.value != null ? this.value.precision() : 1, 0, null);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return 16;
    }

    @Override
    public Value add(Value v) {
        BigDecimal value2 = ((ValueDecfloat)v).value;
        if (this.value != null) {
            if (value2 != null) {
                return ValueDecfloat.get(this.value.add(value2));
            }
            return v;
        }
        if (value2 != null || this == v) {
            return this;
        }
        return NAN;
    }

    @Override
    public Value subtract(Value v) {
        BigDecimal value2 = ((ValueDecfloat)v).value;
        if (this.value != null) {
            if (value2 != null) {
                return ValueDecfloat.get(this.value.subtract(value2));
            }
            return v == POSITIVE_INFINITY ? NEGATIVE_INFINITY : (v == NEGATIVE_INFINITY ? POSITIVE_INFINITY : NAN);
        }
        if (value2 != null) {
            return this;
        }
        if (this == POSITIVE_INFINITY) {
            if (v == NEGATIVE_INFINITY) {
                return POSITIVE_INFINITY;
            }
        } else if (this == NEGATIVE_INFINITY && v == POSITIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        return NAN;
    }

    @Override
    public Value negate() {
        if (this.value != null) {
            return ValueDecfloat.get(this.value.negate());
        }
        return this == POSITIVE_INFINITY ? NEGATIVE_INFINITY : (this == NEGATIVE_INFINITY ? POSITIVE_INFINITY : NAN);
    }

    @Override
    public Value multiply(Value v) {
        BigDecimal value2 = ((ValueDecfloat)v).value;
        if (this.value != null) {
            if (value2 != null) {
                return ValueDecfloat.get(this.value.multiply(value2));
            }
            if (v == POSITIVE_INFINITY) {
                int s = this.value.signum();
                if (s > 0) {
                    return POSITIVE_INFINITY;
                }
                if (s < 0) {
                    return NEGATIVE_INFINITY;
                }
            } else if (v == NEGATIVE_INFINITY) {
                int s = this.value.signum();
                if (s > 0) {
                    return NEGATIVE_INFINITY;
                }
                if (s < 0) {
                    return POSITIVE_INFINITY;
                }
            }
        } else if (value2 != null) {
            if (this == POSITIVE_INFINITY) {
                int s = value2.signum();
                if (s > 0) {
                    return POSITIVE_INFINITY;
                }
                if (s < 0) {
                    return NEGATIVE_INFINITY;
                }
            } else if (this == NEGATIVE_INFINITY) {
                int s = value2.signum();
                if (s > 0) {
                    return NEGATIVE_INFINITY;
                }
                if (s < 0) {
                    return POSITIVE_INFINITY;
                }
            }
        } else if (this == POSITIVE_INFINITY) {
            if (v == POSITIVE_INFINITY) {
                return POSITIVE_INFINITY;
            }
            if (v == NEGATIVE_INFINITY) {
                return NEGATIVE_INFINITY;
            }
        } else if (this == NEGATIVE_INFINITY) {
            if (v == POSITIVE_INFINITY) {
                return NEGATIVE_INFINITY;
            }
            if (v == NEGATIVE_INFINITY) {
                return POSITIVE_INFINITY;
            }
        }
        return NAN;
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        BigDecimal value2 = ((ValueDecfloat)v).value;
        if (value2 != null && value2.signum() == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        if (this.value != null) {
            if (value2 != null) {
                return ValueDecfloat.divide(this.value, value2, quotientType);
            }
            if (v != NAN) {
                return ZERO;
            }
        } else if (value2 != null && this != NAN) {
            return this == POSITIVE_INFINITY == value2.signum() > 0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
        }
        return NAN;
    }

    public static ValueDecfloat divide(BigDecimal dividend, BigDecimal divisor, TypeInfo quotientType) {
        int quotientPrecision = (int)quotientType.getPrecision();
        BigDecimal quotient = dividend.divide(divisor, dividend.scale() - dividend.precision() + divisor.precision() - divisor.scale() + quotientPrecision, RoundingMode.HALF_DOWN);
        int precision = quotient.precision();
        if (precision > quotientPrecision) {
            quotient = quotient.setScale(quotient.scale() - precision + quotientPrecision, RoundingMode.HALF_UP);
        }
        return ValueDecfloat.get(quotient);
    }

    @Override
    public Value modulus(Value v) {
        BigDecimal value2 = ((ValueDecfloat)v).value;
        if (value2 != null && value2.signum() == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        if (this.value != null) {
            if (value2 != null) {
                return ValueDecfloat.get(this.value.remainder(value2));
            }
            if (v != NAN) {
                return this;
            }
        }
        return NAN;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        BigDecimal value2 = ((ValueDecfloat)o).value;
        if (this.value != null) {
            if (value2 != null) {
                return this.value.compareTo(value2);
            }
            return o == NEGATIVE_INFINITY ? 1 : -1;
        }
        if (value2 != null) {
            return this == NEGATIVE_INFINITY ? -1 : 1;
        }
        if (this == o) {
            return 0;
        }
        if (this == NEGATIVE_INFINITY) {
            return -1;
        }
        if (o == NEGATIVE_INFINITY) {
            return 1;
        }
        return this == POSITIVE_INFINITY ? -1 : 1;
    }

    @Override
    public int getSignum() {
        if (this.value != null) {
            return this.value.signum();
        }
        return this == POSITIVE_INFINITY ? 1 : (this == NEGATIVE_INFINITY ? -1 : 0);
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.value != null) {
            return this.value;
        }
        throw this.getDataConversionError(13);
    }

    @Override
    public float getFloat() {
        if (this.value != null) {
            return this.value.floatValue();
        }
        if (this == POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        if (this == NEGATIVE_INFINITY) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.NaN;
    }

    @Override
    public double getDouble() {
        if (this.value != null) {
            return this.value.doubleValue();
        }
        if (this == POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (this == NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.NaN;
    }

    @Override
    public int hashCode() {
        return this.value != null ? this.getClass().hashCode() * 31 + this.value.hashCode() : System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ValueDecfloat) {
            BigDecimal value2 = ((ValueDecfloat)other).value;
            if (this.value != null) {
                return this.value.equals(value2);
            }
            if (value2 == null && this == other) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMemory() {
        return this.value != null ? this.value.precision() + 120 : 32;
    }

    public boolean isFinite() {
        return this.value != null;
    }

    public static ValueDecfloat get(BigDecimal dec) {
        if (BigDecimal.ZERO.equals(dec = dec.stripTrailingZeros())) {
            return ZERO;
        }
        if (BigDecimal.ONE.equals(dec)) {
            return ONE;
        }
        return (ValueDecfloat)Value.cache(new ValueDecfloat(dec));
    }
}

