/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueDouble
extends Value {
    static final int PRECISION = 53;
    public static final int DECIMAL_PRECISION = 17;
    public static final int DISPLAY_SIZE = 24;
    public static final long ZERO_BITS = 0L;
    public static final ValueDouble ZERO = new ValueDouble(0.0);
    public static final ValueDouble ONE = new ValueDouble(1.0);
    private static final ValueDouble NAN = new ValueDouble(Double.NaN);
    private final double value;

    private ValueDouble(double value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        return ValueDouble.get(this.value + ((ValueDouble)v).value);
    }

    @Override
    public Value subtract(Value v) {
        return ValueDouble.get(this.value - ((ValueDouble)v).value);
    }

    @Override
    public Value negate() {
        return ValueDouble.get(-this.value);
    }

    @Override
    public Value multiply(Value v) {
        return ValueDouble.get(this.value * ((ValueDouble)v).value);
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        ValueDouble v2 = (ValueDouble)v;
        if (v2.value == 0.0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueDouble.get(this.value / v2.value);
    }

    @Override
    public ValueDouble modulus(Value v) {
        ValueDouble other = (ValueDouble)v;
        if (other.value == 0.0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueDouble.get(this.value % other.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0) {
            return this.getSQL(builder.append("CAST(")).append(" AS DOUBLE PRECISION)");
        }
        return this.getSQL(builder);
    }

    private StringBuilder getSQL(StringBuilder builder) {
        if (this.value == Double.POSITIVE_INFINITY) {
            return builder.append("'Infinity'");
        }
        if (this.value == Double.NEGATIVE_INFINITY) {
            return builder.append("'-Infinity'");
        }
        if (Double.isNaN(this.value)) {
            return builder.append("'NaN'");
        }
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_DOUBLE;
    }

    @Override
    public int getValueType() {
        return 15;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        return Double.compare(this.value, ((ValueDouble)o).value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0 || Double.isNaN(this.value) ? 0 : (this.value < 0.0 ? -1 : 1);
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Double.isFinite(this.value)) {
            return BigDecimal.valueOf(this.value);
        }
        throw DbException.get(22018, Double.toString(this.value));
    }

    @Override
    public float getFloat() {
        return (float)this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return Double.toString(this.value);
    }

    @Override
    public int hashCode() {
        long hash = Double.doubleToRawLongBits(this.value);
        return (int)(hash ^ hash >>> 32);
    }

    public static ValueDouble get(double d) {
        if (d == 1.0) {
            return ONE;
        }
        if (d == 0.0) {
            return ZERO;
        }
        if (Double.isNaN(d)) {
            return NAN;
        }
        return (ValueDouble)Value.cache(new ValueDouble(d));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueDouble)) {
            return false;
        }
        return this.compareTypeSafe((ValueDouble)other, null, null) == 0;
    }
}

