/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.message.DbException;
import org.h2.util.Bits;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.geometry.EWKBUtils;
import org.h2.util.geometry.EWKTUtils;
import org.h2.util.geometry.GeometryUtils;
import org.h2.util.geometry.JTSUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBytesBase;
import org.h2.value.ValueNull;
import org.locationtech.jts.geom.Geometry;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueGeometry
extends ValueBytesBase {
    private static final double[] UNKNOWN_ENVELOPE = new double[0];
    private final int typeAndDimensionSystem;
    private final int srid;
    private double[] envelope;
    private Object geometry;

    private ValueGeometry(byte[] bytes, double[] envelope) {
        super(bytes);
        if (bytes.length < 9 || bytes[0] != 0) {
            throw DbException.get(22018, StringUtils.convertBytesToHex(bytes));
        }
        this.value = bytes;
        this.envelope = envelope;
        int t = Bits.INT_VH_BE.get(bytes, 1);
        this.srid = (t & 0x20000000) != 0 ? Bits.INT_VH_BE.get(bytes, 5) : 0;
        this.typeAndDimensionSystem = (t & 0xFFFF) % 1000 + EWKBUtils.type2dimensionSystem(t) * 1000;
    }

    public static ValueGeometry getFromGeometry(Object o) {
        try {
            Geometry g = (Geometry)o;
            return (ValueGeometry)Value.cache(new ValueGeometry(JTSUtils.geometry2ewkb(g), UNKNOWN_ENVELOPE));
        }
        catch (RuntimeException ex) {
            throw DbException.get(22018, String.valueOf(o));
        }
    }

    public static ValueGeometry get(String s) {
        try {
            return (ValueGeometry)Value.cache(new ValueGeometry(EWKTUtils.ewkt2ewkb(s), UNKNOWN_ENVELOPE));
        }
        catch (RuntimeException ex) {
            throw DbException.get(22018, s);
        }
    }

    public static ValueGeometry get(byte[] bytes) {
        return (ValueGeometry)Value.cache(new ValueGeometry(bytes, UNKNOWN_ENVELOPE));
    }

    public static ValueGeometry getFromEWKB(byte[] bytes) {
        try {
            return (ValueGeometry)Value.cache(new ValueGeometry(EWKBUtils.ewkb2ewkb(bytes), UNKNOWN_ENVELOPE));
        }
        catch (RuntimeException ex) {
            throw DbException.get(22018, StringUtils.convertBytesToHex(bytes));
        }
    }

    public static Value fromEnvelope(double[] envelope) {
        return envelope != null ? Value.cache(new ValueGeometry(EWKBUtils.envelope2wkb(envelope), envelope)) : ValueNull.INSTANCE;
    }

    public Geometry getGeometry() {
        if (this.geometry == null) {
            try {
                this.geometry = JTSUtils.ewkb2geometry(this.value, this.getDimensionSystem());
            }
            catch (RuntimeException ex) {
                throw DbException.convert(ex);
            }
        }
        return ((Geometry)this.geometry).copy();
    }

    public int getTypeAndDimensionSystem() {
        return this.typeAndDimensionSystem;
    }

    public int getGeometryType() {
        return this.typeAndDimensionSystem % 1000;
    }

    public int getDimensionSystem() {
        return this.typeAndDimensionSystem / 1000;
    }

    public int getSRID() {
        return this.srid;
    }

    public double[] getEnvelopeNoCopy() {
        if (this.envelope == UNKNOWN_ENVELOPE) {
            GeometryUtils.EnvelopeTarget target = new GeometryUtils.EnvelopeTarget();
            EWKBUtils.parseEWKB(this.value, target);
            this.envelope = target.getEnvelope();
        }
        return this.envelope;
    }

    public boolean intersectsBoundingBox(ValueGeometry r) {
        return GeometryUtils.intersects(this.getEnvelopeNoCopy(), r.getEnvelopeNoCopy());
    }

    public Value getEnvelopeUnion(ValueGeometry r) {
        return ValueGeometry.fromEnvelope(GeometryUtils.union(this.getEnvelopeNoCopy(), r.getEnvelopeNoCopy()));
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_GEOMETRY;
    }

    @Override
    public int getValueType() {
        return 37;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        builder.append("GEOMETRY ");
        if ((sqlFlags & 8) != 0) {
            EWKBUtils.parseEWKB(this.value, new EWKTUtils.EWKTTarget(builder.append('\''), this.getDimensionSystem()));
            builder.append('\'');
        } else {
            super.getSQL(builder, 0);
        }
        return builder;
    }

    @Override
    public String getString() {
        return EWKTUtils.ewkb2ewkt(this.value, this.getDimensionSystem());
    }

    @Override
    public int getMemory() {
        return MathUtils.convertLongToInt((long)this.value.length * 20L + 24L);
    }
}

