/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.Bits;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueInteger
extends Value {
    public static final int PRECISION = 32;
    public static final int DECIMAL_PRECISION = 10;
    public static final int DISPLAY_SIZE = 11;
    private static final int STATIC_SIZE = 128;
    private static final int DYNAMIC_SIZE = 256;
    private static final ValueInteger[] STATIC_CACHE = new ValueInteger[128];
    private static final ValueInteger[] DYNAMIC_CACHE = new ValueInteger[256];
    private final int value;

    static {
        int i = 0;
        while (i < 128) {
            ValueInteger.STATIC_CACHE[i] = new ValueInteger(i);
            ++i;
        }
    }

    private ValueInteger(int value) {
        this.value = value;
    }

    public static ValueInteger get(int i) {
        if (i >= 0 && i < 128) {
            return STATIC_CACHE[i];
        }
        ValueInteger v = DYNAMIC_CACHE[i & 0xFF];
        if (v == null || v.value != i) {
            ValueInteger.DYNAMIC_CACHE[i & 0xFF] = v = new ValueInteger(i);
        }
        return v;
    }

    @Override
    public Value add(Value v) {
        ValueInteger other = (ValueInteger)v;
        return ValueInteger.checkRange((long)this.value + (long)other.value);
    }

    private static ValueInteger checkRange(long x) {
        if ((long)((int)x) != x) {
            throw DbException.get(22003, Long.toString(x));
        }
        return ValueInteger.get((int)x);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueInteger.checkRange(-((long)this.value));
    }

    @Override
    public Value subtract(Value v) {
        ValueInteger other = (ValueInteger)v;
        return ValueInteger.checkRange((long)this.value - (long)other.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueInteger other = (ValueInteger)v;
        return ValueInteger.checkRange((long)this.value * (long)other.value);
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        int y = ((ValueInteger)v).value;
        if (y == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        int x = this.value;
        if (x == Integer.MIN_VALUE && y == -1) {
            throw DbException.get(22003, "2147483648");
        }
        return ValueInteger.get(x / y);
    }

    @Override
    public Value modulus(Value v) {
        ValueInteger other = (ValueInteger)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueInteger.get(this.value % other.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_INTEGER;
    }

    @Override
    public int getValueType() {
        return 11;
    }

    @Override
    public byte[] getBytes() {
        byte[] b = new byte[4];
        Bits.INT_VH_BE.set(b, 0, this.getInt());
        return b;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        return Integer.compare(this.value, ((ValueInteger)o).value);
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueInteger && this.value == ((ValueInteger)other).value;
    }
}

