/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBytesBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueJavaObject
extends ValueBytesBase {
    private static final ValueJavaObject EMPTY = new ValueJavaObject(Utils.EMPTY_BYTES);

    private ValueJavaObject(byte[] v) {
        super(v);
    }

    public static ValueJavaObject getNoCopy(byte[] b) {
        int length = b.length;
        if (length == 0) {
            return EMPTY;
        }
        ValueJavaObject obj = new ValueJavaObject(b);
        if (length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueJavaObject)Value.cache(obj);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_JAVA_OBJECT;
    }

    @Override
    public int getValueType() {
        return 35;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0) {
            return super.getSQL(builder.append("CAST("), 0).append(" AS JAVA_OBJECT)");
        }
        return super.getSQL(builder, 0);
    }

    @Override
    public String getString() {
        throw DbException.get(22018, "JAVA_OBJECT to CHARACTER VARYING");
    }
}

