/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueTimestamp
extends Value {
    public static final int DEFAULT_PRECISION = 26;
    public static final int MAXIMUM_PRECISION = 29;
    public static final int DEFAULT_SCALE = 6;
    public static final int MAXIMUM_SCALE = 9;
    private final long dateValue;
    private final long timeNanos;

    private ValueTimestamp(long dateValue, long timeNanos) {
        if (dateValue < -511999999967L || dateValue > 512000000415L) {
            throw new IllegalArgumentException("dateValue out of range " + dateValue);
        }
        if (timeNanos < 0L || timeNanos >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + timeNanos);
        }
        this.dateValue = dateValue;
        this.timeNanos = timeNanos;
    }

    public static ValueTimestamp fromDateValueAndNanos(long dateValue, long timeNanos) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(dateValue, timeNanos));
    }

    public static ValueTimestamp parse(String s, CastDataProvider provider) {
        try {
            return (ValueTimestamp)DateTimeUtils.parseTimestamp(s, provider, false);
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "TIMESTAMP", s);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIMESTAMP;
    }

    @Override
    public int getValueType() {
        return 20;
    }

    @Override
    public int getMemory() {
        return 32;
    }

    @Override
    public String getString() {
        return this.toString(new StringBuilder(29), false).toString();
    }

    public String getISOString() {
        return this.toString(new StringBuilder(29), true).toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return this.toString(builder.append("TIMESTAMP '"), false).append('\'');
    }

    private StringBuilder toString(StringBuilder builder, boolean iso) {
        DateTimeUtils.appendDate(builder, this.dateValue).append(iso ? (char)'T' : ' ');
        return DateTimeUtils.appendTime(builder, this.timeNanos);
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        ValueTimestamp t = (ValueTimestamp)o;
        int c = Long.compare(this.dateValue, t.dateValue);
        if (c != 0) {
            return c;
        }
        return Long.compare(this.timeNanos, t.timeNanos);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueTimestamp)) {
            return false;
        }
        ValueTimestamp x = (ValueTimestamp)other;
        return this.dateValue == x.dateValue && this.timeNanos == x.timeNanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32);
    }

    @Override
    public Value add(Value v) {
        ValueTimestamp t = (ValueTimestamp)v;
        long absoluteDay = DateTimeUtils.absoluteDayFromDateValue(this.dateValue) + DateTimeUtils.absoluteDayFromDateValue(t.dateValue);
        long nanos = this.timeNanos + t.timeNanos;
        if (nanos >= 86400000000000L) {
            nanos -= 86400000000000L;
            ++absoluteDay;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), nanos);
    }

    @Override
    public Value subtract(Value v) {
        ValueTimestamp t = (ValueTimestamp)v;
        long absoluteDay = DateTimeUtils.absoluteDayFromDateValue(this.dateValue) - DateTimeUtils.absoluteDayFromDateValue(t.dateValue);
        long nanos = this.timeNanos - t.timeNanos;
        if (nanos < 0L) {
            nanos += 86400000000000L;
            --absoluteDay;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), nanos);
    }
}

