/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IntervalUtils;
import org.h2.util.JSR310Utils;
import org.h2.util.JdbcUtils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBinary;
import org.h2.value.ValueBlob;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueChar;
import org.h2.value.ValueClob;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueRow;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueToObjectConverter;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueToObjectConverter2
extends TraceObject {
    public static TypeInfo classToType(Class<?> clazz) {
        if (clazz == null) {
            return TypeInfo.TYPE_NULL;
        }
        if (clazz.isPrimitive()) {
            clazz = Utils.getNonPrimitiveClass(clazz);
        }
        if (clazz == Void.class) {
            return TypeInfo.TYPE_NULL;
        }
        if (clazz == String.class || clazz == Character.class) {
            return TypeInfo.TYPE_VARCHAR;
        }
        if (clazz == byte[].class) {
            return TypeInfo.TYPE_VARBINARY;
        }
        if (clazz == Boolean.class) {
            return TypeInfo.TYPE_BOOLEAN;
        }
        if (clazz == Byte.class) {
            return TypeInfo.TYPE_TINYINT;
        }
        if (clazz == Short.class) {
            return TypeInfo.TYPE_SMALLINT;
        }
        if (clazz == Integer.class) {
            return TypeInfo.TYPE_INTEGER;
        }
        if (clazz == Long.class) {
            return TypeInfo.TYPE_BIGINT;
        }
        if (clazz == Float.class) {
            return TypeInfo.TYPE_REAL;
        }
        if (clazz == Double.class) {
            return TypeInfo.TYPE_DOUBLE;
        }
        if (clazz == LocalDate.class) {
            return TypeInfo.TYPE_DATE;
        }
        if (clazz == LocalTime.class) {
            return TypeInfo.TYPE_TIME;
        }
        if (clazz == OffsetTime.class) {
            return TypeInfo.TYPE_TIME_TZ;
        }
        if (clazz == LocalDateTime.class) {
            return TypeInfo.TYPE_TIMESTAMP;
        }
        if (clazz == OffsetDateTime.class || clazz == ZonedDateTime.class || clazz == Instant.class) {
            return TypeInfo.TYPE_TIMESTAMP_TZ;
        }
        if (clazz == Period.class) {
            return TypeInfo.TYPE_INTERVAL_YEAR_TO_MONTH;
        }
        if (clazz == Duration.class) {
            return TypeInfo.TYPE_INTERVAL_DAY_TO_SECOND;
        }
        if (UUID.class == clazz) {
            return TypeInfo.TYPE_UUID;
        }
        if (clazz.isArray()) {
            return TypeInfo.getTypeInfo(40, Integer.MAX_VALUE, 0, ValueToObjectConverter2.classToType(clazz.getComponentType()));
        }
        if (Clob.class.isAssignableFrom(clazz) || Reader.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_CLOB;
        }
        if (Blob.class.isAssignableFrom(clazz) || InputStream.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_BLOB;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_NUMERIC_FLOATING_POINT;
        }
        if (ValueToObjectConverter.GEOMETRY_CLASS != null && ValueToObjectConverter.GEOMETRY_CLASS.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_GEOMETRY;
        }
        if (Array.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_ARRAY_UNKNOWN;
        }
        if (ResultSet.class.isAssignableFrom(clazz)) {
            return TypeInfo.TYPE_ROW_EMPTY;
        }
        TypeInfo t = LegacyDateTimeUtils.legacyClassToType(clazz);
        if (t != null) {
            return t;
        }
        return TypeInfo.TYPE_JAVA_OBJECT;
    }

    public static Value readValue(Session session, ResultSet rs, int columnIndex, int type) {
        Value v;
        if (rs instanceof JdbcResultSet) {
            v = ValueToObjectConverter.readValue(session, (JdbcResultSet)rs, columnIndex);
        } else {
            try {
                v = ValueToObjectConverter2.readValueOther(session, rs, columnIndex, type);
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
        return v;
    }

    private static Value readValueOther(Session session, ResultSet rs, int columnIndex, int type) throws SQLException {
        Value v;
        switch (type) {
            case 0: {
                v = ValueNull.INSTANCE;
                break;
            }
            case 1: {
                String s = rs.getString(columnIndex);
                v = s == null ? ValueNull.INSTANCE : ValueChar.get(s);
                break;
            }
            case 2: {
                String s = rs.getString(columnIndex);
                v = s == null ? ValueNull.INSTANCE : ValueVarchar.get(s, session);
                break;
            }
            case 3: {
                if (session == null) {
                    String s = rs.getString(columnIndex);
                    v = s == null ? ValueNull.INSTANCE : ValueClob.createSmall(s);
                    break;
                }
                Reader in = rs.getCharacterStream(columnIndex);
                v = in == null ? ValueNull.INSTANCE : session.addTemporaryLob(session.getDataHandler().getLobStorage().createClob(new BufferedReader(in), -1L));
                break;
            }
            case 4: {
                String s = rs.getString(columnIndex);
                v = s == null ? ValueNull.INSTANCE : ValueVarcharIgnoreCase.get(s);
                break;
            }
            case 5: {
                byte[] bytes = rs.getBytes(columnIndex);
                v = bytes == null ? ValueNull.INSTANCE : ValueBinary.getNoCopy(bytes);
                break;
            }
            case 6: {
                byte[] bytes = rs.getBytes(columnIndex);
                v = bytes == null ? ValueNull.INSTANCE : ValueVarbinary.getNoCopy(bytes);
                break;
            }
            case 7: {
                if (session == null) {
                    byte[] buff = rs.getBytes(columnIndex);
                    v = buff == null ? ValueNull.INSTANCE : ValueBlob.createSmall(buff);
                    break;
                }
                InputStream in = rs.getBinaryStream(columnIndex);
                v = in == null ? ValueNull.INSTANCE : session.addTemporaryLob(session.getDataHandler().getLobStorage().createBlob(in, -1L));
                break;
            }
            case 8: {
                boolean value = rs.getBoolean(columnIndex);
                v = rs.wasNull() ? ValueNull.INSTANCE : ValueBoolean.get(value);
                break;
            }
            case 9: {
                byte value = rs.getByte(columnIndex);
                v = rs.wasNull() ? ValueNull.INSTANCE : ValueTinyint.get(value);
                break;
            }
            case 10: {
                short value = rs.getShort(columnIndex);
                v = rs.wasNull() ? ValueNull.INSTANCE : ValueSmallint.get(value);
                break;
            }
            case 11: {
                int value = rs.getInt(columnIndex);
                v = rs.wasNull() ? ValueNull.INSTANCE : ValueInteger.get(value);
                break;
            }
            case 12: {
                long value = rs.getLong(columnIndex);
                v = rs.wasNull() ? ValueNull.INSTANCE : ValueBigint.get(value);
                break;
            }
            case 13: {
                BigDecimal value = rs.getBigDecimal(columnIndex);
                v = value == null ? ValueNull.INSTANCE : ValueNumeric.getAnyScale(value);
                break;
            }
            case 14: {
                float value = rs.getFloat(columnIndex);
                v = rs.wasNull() ? ValueNull.INSTANCE : ValueReal.get(value);
                break;
            }
            case 15: {
                double value = rs.getDouble(columnIndex);
                v = rs.wasNull() ? ValueNull.INSTANCE : ValueDouble.get(value);
                break;
            }
            case 16: {
                BigDecimal value = rs.getBigDecimal(columnIndex);
                v = value == null ? ValueNull.INSTANCE : ValueDecfloat.get(value);
                break;
            }
            case 17: {
                try {
                    LocalDate value = rs.getObject(columnIndex, LocalDate.class);
                    v = value == null ? ValueNull.INSTANCE : JSR310Utils.localDateToValue(value);
                }
                catch (SQLException ignore) {
                    Date value = rs.getDate(columnIndex);
                    v = value == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromDate(session, null, value);
                }
                break;
            }
            case 18: {
                try {
                    LocalTime value = rs.getObject(columnIndex, LocalTime.class);
                    v = value == null ? ValueNull.INSTANCE : JSR310Utils.localTimeToValue(value);
                }
                catch (SQLException ignore) {
                    Time value = rs.getTime(columnIndex);
                    v = value == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTime(session, null, value);
                }
                break;
            }
            case 19: {
                try {
                    OffsetTime value = rs.getObject(columnIndex, OffsetTime.class);
                    v = value == null ? ValueNull.INSTANCE : JSR310Utils.offsetTimeToValue(value);
                }
                catch (SQLException ignore) {
                    Object obj = rs.getObject(columnIndex);
                    if (obj == null) {
                        v = ValueNull.INSTANCE;
                        break;
                    }
                    v = ValueTimeTimeZone.parse(obj.toString(), session);
                }
                break;
            }
            case 20: {
                try {
                    LocalDateTime value = rs.getObject(columnIndex, LocalDateTime.class);
                    v = value == null ? ValueNull.INSTANCE : JSR310Utils.localDateTimeToValue(value);
                }
                catch (SQLException ignore) {
                    Timestamp value = rs.getTimestamp(columnIndex);
                    v = value == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTimestamp((CastDataProvider)session, null, value);
                }
                break;
            }
            case 21: {
                try {
                    OffsetDateTime value = rs.getObject(columnIndex, OffsetDateTime.class);
                    v = value == null ? ValueNull.INSTANCE : JSR310Utils.offsetDateTimeToValue(value);
                }
                catch (SQLException ignore) {
                    Object obj = rs.getObject(columnIndex);
                    if (obj == null) {
                        v = ValueNull.INSTANCE;
                        break;
                    }
                    if (obj instanceof ZonedDateTime) {
                        v = JSR310Utils.zonedDateTimeToValue((ZonedDateTime)obj);
                        break;
                    }
                    v = ValueTimestampTimeZone.parse(obj.toString(), session);
                }
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                String s = rs.getString(columnIndex);
                v = s == null ? ValueNull.INSTANCE : IntervalUtils.parseFormattedInterval(IntervalQualifier.valueOf(type - 22), s);
                break;
            }
            case 35: {
                byte[] buff;
                try {
                    buff = rs.getBytes(columnIndex);
                }
                catch (SQLException ignore) {
                    try {
                        Object o = rs.getObject(columnIndex);
                        buff = o != null ? JdbcUtils.serialize(o, session.getJavaObjectSerializer()) : null;
                    }
                    catch (Exception e) {
                        throw DbException.convert(e);
                    }
                }
                v = buff == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(buff);
                break;
            }
            case 36: {
                int value = rs.getInt(columnIndex);
                v = rs.wasNull() ? ValueNull.INSTANCE : ValueInteger.get(value);
                break;
            }
            case 37: {
                Object x = rs.getObject(columnIndex);
                v = x == null ? ValueNull.INSTANCE : ValueGeometry.getFromGeometry(x);
                break;
            }
            case 38: {
                Object x = rs.getObject(columnIndex);
                if (x == null) {
                    v = ValueNull.INSTANCE;
                    break;
                }
                Class<?> clazz = x.getClass();
                if (clazz == byte[].class) {
                    v = ValueJson.fromJson((byte[])x);
                    break;
                }
                if (clazz == String.class) {
                    v = ValueJson.fromJson((String)x);
                    break;
                }
                v = ValueJson.fromJson(x.toString());
                break;
            }
            case 39: {
                Object o = rs.getObject(columnIndex);
                if (o == null) {
                    v = ValueNull.INSTANCE;
                    break;
                }
                if (o instanceof UUID) {
                    v = ValueUuid.get((UUID)o);
                    break;
                }
                if (o instanceof byte[]) {
                    v = ValueUuid.get((byte[])o);
                    break;
                }
                v = ValueUuid.get((String)o);
                break;
            }
            case 40: {
                Array array = rs.getArray(columnIndex);
                if (array == null) {
                    v = ValueNull.INSTANCE;
                    break;
                }
                Object[] list = (Object[])array.getArray();
                if (list == null) {
                    v = ValueNull.INSTANCE;
                    break;
                }
                int len = list.length;
                Value[] values = new Value[len];
                int i = 0;
                while (i < len) {
                    values[i] = ValueToObjectConverter.objectToValue(session, list[i], 0);
                    ++i;
                }
                v = ValueArray.get(values, session);
                break;
            }
            case 41: {
                Object o = rs.getObject(columnIndex);
                if (o == null) {
                    v = ValueNull.INSTANCE;
                    break;
                }
                if (o instanceof ResultSet) {
                    v = ValueToObjectConverter.resultSetToValue(session, (ResultSet)o);
                    break;
                }
                Object[] list = (Object[])o;
                int len = list.length;
                Value[] values = new Value[len];
                int i = 0;
                while (i < len) {
                    values[i] = ValueToObjectConverter.objectToValue(session, list[i], 0);
                    ++i;
                }
                v = ValueRow.get(values);
                break;
            }
            default: {
                throw DbException.getInternalError("data type " + type);
            }
        }
        return v;
    }

    private ValueToObjectConverter2() {
    }
}

