/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.UUID;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.Bits;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ValueUuid
extends Value {
    static final int PRECISION = 16;
    static final int DISPLAY_SIZE = 36;
    private final long high;
    private final long low;

    private ValueUuid(long high, long low) {
        this.high = high;
        this.low = low;
    }

    @Override
    public int hashCode() {
        return (int)(this.high >>> 32 ^ this.high ^ this.low >>> 32 ^ this.low);
    }

    public static ValueUuid getNewRandom() {
        long high = MathUtils.secureRandomLong();
        long low = MathUtils.secureRandomLong();
        high = high & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        low = low & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new ValueUuid(high, low);
    }

    public static ValueUuid get(byte[] binary) {
        int length = binary.length;
        if (length != 16) {
            throw DbException.get(22018, "UUID requires 16 bytes, got " + length);
        }
        return ValueUuid.get(Bits.LONG_VH_BE.get(binary, 0), Bits.LONG_VH_BE.get(binary, 8));
    }

    public static ValueUuid get(long high, long low) {
        return (ValueUuid)Value.cache(new ValueUuid(high, low));
    }

    public static ValueUuid get(UUID uuid) {
        return ValueUuid.get(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    /*
     * Unable to fully structure code
     */
    public static ValueUuid get(String s) {
        low = 0L;
        high = 0L;
        j = 0;
        i = 0;
        length = s.length();
        while (i < length) {
            block9: {
                block8: {
                    block7: {
                        c = s.charAt(i);
                        if (c < '0' || c > '9') break block7;
                        low = low << 4 | (long)(c - 48);
                        ** GOTO lbl-1000
                    }
                    if (c < 'a' || c > 'f') break block8;
                    low = low << 4 | (long)(c - 87);
                    ** GOTO lbl-1000
                }
                if (c != '-') {
                    if (c < 'A' || c > 'F') {
                        if (c > ' ') {
                            throw DbException.get(22018, s);
                        }
                    } else {
                        low = low << 4 | (long)(c - 55);
                    }
                }
                break block9;
lbl-1000:
                // 3 sources

                {
                    if (++j == 16) {
                        high = low;
                        low = 0L;
                    }
                }
            }
            ++i;
        }
        if (j != 32) {
            throw DbException.get(22018, s);
        }
        return ValueUuid.get(high, low);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return this.addString(builder.append("UUID '")).append('\'');
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_UUID;
    }

    @Override
    public int getMemory() {
        return 32;
    }

    @Override
    public int getValueType() {
        return 39;
    }

    @Override
    public String getString() {
        return this.addString(new StringBuilder(36)).toString();
    }

    @Override
    public byte[] getBytes() {
        return Bits.uuidToBytes(this.high, this.low);
    }

    private StringBuilder addString(StringBuilder builder) {
        StringUtils.appendHex(builder, this.high >> 32, 4).append('-');
        StringUtils.appendHex(builder, this.high >> 16, 2).append('-');
        StringUtils.appendHex(builder, this.high, 2).append('-');
        StringUtils.appendHex(builder, this.low >> 48, 2).append('-');
        return StringUtils.appendHex(builder, this.low, 6);
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        if (o == this) {
            return 0;
        }
        ValueUuid v = (ValueUuid)o;
        int cmp = Long.compareUnsigned(this.high, v.high);
        return cmp != 0 ? cmp : Long.compareUnsigned(this.low, v.low);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueUuid)) {
            return false;
        }
        ValueUuid v = (ValueUuid)other;
        return this.high == v.high && this.low == v.low;
    }

    public UUID getUuid() {
        return new UUID(this.high, this.low);
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    @Override
    public long charLength() {
        return 36L;
    }

    @Override
    public long octetLength() {
        return 16L;
    }
}

