/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value.lob;

import java.io.IOException;
import java.io.InputStream;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.value.ValueLob;
import org.h2.value.lob.LobData;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class LobDataDatabase
extends LobData {
    private final DataHandler handler;
    private final int tableId;
    private final long lobId;

    public LobDataDatabase(DataHandler handler, int tableId, long lobId) {
        this.handler = handler;
        this.tableId = tableId;
        this.lobId = lobId;
    }

    @Override
    public void remove(ValueLob value) {
        if (this.handler != null) {
            this.handler.getLobStorage().removeLob(value);
        }
    }

    @Override
    public boolean isLinkedToTable() {
        return this.tableId >= 0;
    }

    public int getTableId() {
        return this.tableId;
    }

    public long getLobId() {
        return this.lobId;
    }

    @Override
    public InputStream getInputStream(long precision) {
        try {
            return this.handler.getLobStorage().getInputStream(this.lobId, this.tableId, precision);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.toString());
        }
    }

    @Override
    public DataHandler getDataHandler() {
        return this.handler;
    }

    public String toString() {
        return "lob-table: table: " + this.tableId + " id: " + this.lobId;
    }
}

