/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.Function1_2;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FileFunction
extends Function1_2 {
    public static final int FILE_READ = 0;
    public static final int FILE_WRITE = 1;
    private static final String[] NAMES = new String[]{"FILE_READ", "FILE_WRITE"};
    private final int function;

    public FileFunction(Expression expression, Expression expression2, int n) {
        super(expression, expression2);
        this.function = n;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        sessionLocal.getUser().checkAdmin();
        Value value = this.left.getValue(sessionLocal);
        if (value == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        switch (this.function) {
            case 0: {
                String string = value.getString();
                Database database = sessionLocal.getDatabase();
                try {
                    ValueLob valueLob;
                    long l = FileUtils.size(string);
                    try (InputStream inputStream = FileUtils.newInputStream(string);){
                        if (this.right == null) {
                            valueLob = database.getLobStorage().createBlob(inputStream, l);
                        } else {
                            Value value2 = this.right.getValue(sessionLocal);
                            InputStreamReader inputStreamReader = value2 == ValueNull.INSTANCE ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, value2.getString());
                            valueLob = database.getLobStorage().createClob(inputStreamReader, l);
                        }
                    }
                    value = sessionLocal.addTemporaryLob(valueLob);
                    break;
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, string);
                }
            }
            case 1: {
                Value value3 = this.right.getValue(sessionLocal);
                if (value3 == ValueNull.INSTANCE) {
                    value = ValueNull.INSTANCE;
                    break;
                }
                String string = value3.getString();
                try (OutputStream outputStream = Files.newOutputStream(Paths.get(string, new String[0]), new OpenOption[0]);
                     InputStream inputStream = value.getInputStream();){
                    value = ValueBigint.get(IOUtils.copy(inputStream, outputStream));
                    break;
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, string);
                }
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return value;
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        this.left = this.left.optimize(sessionLocal);
        if (this.right != null) {
            this.right = this.right.optimize(sessionLocal);
        }
        switch (this.function) {
            case 0: {
                this.type = this.right == null ? TypeInfo.getTypeInfo(7, Integer.MAX_VALUE, 0, null) : TypeInfo.getTypeInfo(3, Integer.MAX_VALUE, 0, null);
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 2: 
            case 8: {
                return false;
            }
            case 5: {
                if (this.function != 1) break;
                return false;
            }
        }
        return super.isEverything(expressionVisitor);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

