/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.security.SHA3;
import org.h2.util.Bits;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarbinary;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class HashFunction
extends FunctionN {
    public static final int HASH = 0;
    public static final int ORA_HASH = 1;
    private static final String[] NAMES = new String[]{"HASH", "ORA_HASH"};
    private final int function;

    public HashFunction(Expression expression, int n) {
        super(new Expression[]{expression});
        this.function = n;
    }

    public HashFunction(Expression expression, Expression expression2, Expression expression3, int n) {
        Expression[] expressionArray;
        if (expression3 == null) {
            Expression[] expressionArray2 = new Expression[2];
            expressionArray2[0] = expression;
            expressionArray = expressionArray2;
            expressionArray2[1] = expression2;
        } else {
            Expression[] expressionArray3 = new Expression[3];
            expressionArray3[0] = expression;
            expressionArray3[1] = expression2;
            expressionArray = expressionArray3;
            expressionArray3[2] = expression3;
        }
        super(expressionArray);
        this.function = n;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal, Value value, Value value2, Value value3) {
        switch (this.function) {
            case 0: {
                value = HashFunction.getHash(value.getString(), value2, value3 == null ? 1 : value3.getInt());
                break;
            }
            case 1: {
                value = HashFunction.oraHash(value, value2 == null ? 0xFFFFFFFFL : value2.getLong(), value3 == null ? 0L : value3.getLong());
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return value;
    }

    private static Value getHash(String string, Value value, int n) {
        if (n <= 0) {
            throw DbException.getInvalidValueException("iterations", n);
        }
        Object object = StringUtils.toUpperEnglish(string);
        int n2 = -1;
        switch (((String)object).hashCode()) {
            case 76158: {
                if (!((String)object).equals("MD5")) break;
                n2 = 0;
                break;
            }
            case 78861104: {
                if (!((String)object).equals("SHA-1")) break;
                n2 = 1;
                break;
            }
            case -1523887821: {
                if (!((String)object).equals("SHA-224")) break;
                n2 = 2;
                break;
            }
            case -1523887726: {
                if (!((String)object).equals("SHA-256")) break;
                n2 = 3;
                break;
            }
            case -1523886674: {
                if (!((String)object).equals("SHA-384")) break;
                n2 = 4;
                break;
            }
            case -1523884971: {
                if (!((String)object).equals("SHA-512")) break;
                n2 = 5;
                break;
            }
            case -1850268089: {
                if (!((String)object).equals("SHA256")) break;
                n2 = 6;
                break;
            }
            case 9509966: {
                if (!((String)object).equals("SHA3-224")) break;
                n2 = 7;
                break;
            }
            case 9510061: {
                if (!((String)object).equals("SHA3-256")) break;
                n2 = 8;
                break;
            }
            case 9511113: {
                if (!((String)object).equals("SHA3-384")) break;
                n2 = 9;
                break;
            }
            case 9512816: {
                if (!((String)object).equals("SHA3-512")) break;
                n2 = 10;
            }
        }
        MessageDigest messageDigest = switch (n2) {
            case 0, 1, 2, 3, 4, 5 -> HashFunction.hashImpl(value, string);
            case 6 -> HashFunction.hashImpl(value, "SHA-256");
            case 7 -> HashFunction.hashImpl(value, SHA3.getSha3_224());
            case 8 -> HashFunction.hashImpl(value, SHA3.getSha3_256());
            case 9 -> HashFunction.hashImpl(value, SHA3.getSha3_384());
            case 10 -> HashFunction.hashImpl(value, SHA3.getSha3_512());
            default -> throw DbException.getInvalidValueException("algorithm", string);
        };
        object = messageDigest.digest();
        for (n2 = 1; n2 < n; ++n2) {
            object = messageDigest.digest((byte[])object);
        }
        return ValueVarbinary.getNoCopy((byte[])object);
    }

    private static Value oraHash(Value value, long l, long l2) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("bucket", l);
        }
        if ((l2 & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("seed", l2);
        }
        MessageDigest messageDigest = HashFunction.hashImpl(value, "SHA-1");
        if (messageDigest == null) {
            return ValueNull.INSTANCE;
        }
        if (l2 != 0L) {
            byte[] byArray = new byte[4];
            Bits.INT_VH_BE.set(byArray, 0, (int)l2);
            messageDigest.update(byArray);
        }
        long l3 = Bits.LONG_VH_BE.get(messageDigest.digest(), 0);
        return ValueBigint.get((l3 & Long.MAX_VALUE) % (l + 1L));
    }

    private static MessageDigest hashImpl(Value value, String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
        return HashFunction.hashImpl(value, messageDigest);
    }

    private static MessageDigest hashImpl(Value value, MessageDigest messageDigest) {
        try {
            switch (value.getValueType()) {
                case 1: 
                case 2: 
                case 4: {
                    messageDigest.update(value.getString().getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case 3: 
                case 7: {
                    byte[] byArray = new byte[4096];
                    try (InputStream inputStream = value.getInputStream();){
                        int n;
                        while ((n = inputStream.read(byArray)) > 0) {
                            messageDigest.update(byArray, 0, n);
                        }
                        break;
                    }
                }
                default: {
                    messageDigest.update(value.getBytesNoCopy());
                }
            }
            return messageDigest;
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        boolean bl = this.optimizeArguments(sessionLocal, true);
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.TYPE_VARBINARY;
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (bl) {
            return TypedValueExpression.getTypedIfNull(this.getValue(sessionLocal), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

