/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.h2.command.Command0;
import org.h2.command.ParserBase;
import org.h2.command.dml.Help;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintDomain;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.DbObject;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.MetaIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Domain;
import org.h2.schema.FunctionAlias;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.schema.UserDefinedFunction;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueToObjectConverter2;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class InformationSchemaTableLegacy
extends MetaTable {
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int FUNCTION_COLUMNS = 20;
    private static final int CONSTRAINTS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int SYNONYMS = 29;
    private static final int TABLE_CONSTRAINTS = 30;
    private static final int DOMAIN_CONSTRAINTS = 31;
    private static final int KEY_COLUMN_USAGE = 32;
    private static final int REFERENTIAL_CONSTRAINTS = 33;
    private static final int CHECK_CONSTRAINTS = 34;
    private static final int CONSTRAINT_COLUMN_USAGE = 35;
    public static final int META_TABLE_TYPE_COUNT = 36;

    public InformationSchemaTableLegacy(Schema schema, int n, int n2) {
        super(schema, n, n2);
        Column[] columnArray;
        String string = null;
        switch (n2) {
            case 0: {
                this.setMetaTableName("TABLES");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("TABLE_TYPE"), this.column("STORAGE_TYPE"), this.column("SQL"), this.column("REMARKS"), this.column("LAST_MODIFICATION", TypeInfo.TYPE_BIGINT), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("TABLE_CLASS"), this.column("ROW_COUNT_ESTIMATE", TypeInfo.TYPE_BIGINT)};
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setMetaTableName("COLUMNS");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("COLUMN_DEFAULT"), this.column("IS_NULLABLE"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_NAME"), this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("IS_GENERATED"), this.column("GENERATION_EXPRESSION"), this.column("TYPE_NAME"), this.column("NULLABLE", TypeInfo.TYPE_INTEGER), this.column("IS_COMPUTED", TypeInfo.TYPE_BOOLEAN), this.column("SELECTIVITY", TypeInfo.TYPE_INTEGER), this.column("SEQUENCE_NAME"), this.column("REMARKS"), this.column("SOURCE_DATA_TYPE", TypeInfo.TYPE_SMALLINT), this.column("COLUMN_TYPE"), this.column("COLUMN_ON_UPDATE"), this.column("IS_VISIBLE"), this.column("CHECK_CONSTRAINT")};
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setMetaTableName("INDEXES");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("NON_UNIQUE", TypeInfo.TYPE_BOOLEAN), this.column("INDEX_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_SMALLINT), this.column("COLUMN_NAME"), this.column("CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("PRIMARY_KEY", TypeInfo.TYPE_BOOLEAN), this.column("INDEX_TYPE_NAME"), this.column("IS_GENERATED", TypeInfo.TYPE_BOOLEAN), this.column("INDEX_TYPE", TypeInfo.TYPE_SMALLINT), this.column("ASC_OR_DESC"), this.column("PAGES", TypeInfo.TYPE_INTEGER), this.column("FILTER_CONDITION"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("SORT_TYPE", TypeInfo.TYPE_INTEGER), this.column("CONSTRAINT_NAME"), this.column("INDEX_CLASS")};
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setMetaTableName("TABLE_TYPES");
                columnArray = new Column[]{this.column("TYPE")};
                break;
            }
            case 4: {
                this.setMetaTableName("TYPE_INFO");
                columnArray = new Column[]{this.column("TYPE_NAME"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("PRECISION", TypeInfo.TYPE_INTEGER), this.column("PREFIX"), this.column("SUFFIX"), this.column("PARAMS"), this.column("AUTO_INCREMENT", TypeInfo.TYPE_BOOLEAN), this.column("MINIMUM_SCALE", TypeInfo.TYPE_SMALLINT), this.column("MAXIMUM_SCALE", TypeInfo.TYPE_SMALLINT), this.column("RADIX", TypeInfo.TYPE_INTEGER), this.column("POS", TypeInfo.TYPE_INTEGER), this.column("CASE_SENSITIVE", TypeInfo.TYPE_BOOLEAN), this.column("NULLABLE", TypeInfo.TYPE_SMALLINT), this.column("SEARCHABLE", TypeInfo.TYPE_SMALLINT)};
                break;
            }
            case 5: {
                this.setMetaTableName("CATALOGS");
                columnArray = new Column[]{this.column("CATALOG_NAME")};
                break;
            }
            case 6: {
                this.setMetaTableName("SETTINGS");
                columnArray = new Column[]{this.column("NAME"), this.column("VALUE")};
                break;
            }
            case 7: {
                this.setMetaTableName("HELP");
                columnArray = new Column[]{this.column("ID", TypeInfo.TYPE_INTEGER), this.column("SECTION"), this.column("TOPIC"), this.column("SYNTAX"), this.column("TEXT")};
                break;
            }
            case 8: {
                this.setMetaTableName("SEQUENCES");
                columnArray = new Column[]{this.column("SEQUENCE_CATALOG"), this.column("SEQUENCE_SCHEMA"), this.column("SEQUENCE_NAME"), this.column("DATA_TYPE"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("START_VALUE", TypeInfo.TYPE_BIGINT), this.column("MINIMUM_VALUE", TypeInfo.TYPE_BIGINT), this.column("MAXIMUM_VALUE", TypeInfo.TYPE_BIGINT), this.column("INCREMENT", TypeInfo.TYPE_BIGINT), this.column("CYCLE_OPTION"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("CURRENT_VALUE", TypeInfo.TYPE_BIGINT), this.column("IS_GENERATED", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("CACHE", TypeInfo.TYPE_BIGINT), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("MIN_VALUE", TypeInfo.TYPE_BIGINT), this.column("MAX_VALUE", TypeInfo.TYPE_BIGINT), this.column("IS_CYCLE", TypeInfo.TYPE_BOOLEAN)};
                break;
            }
            case 9: {
                this.setMetaTableName("USERS");
                columnArray = new Column[]{this.column("NAME"), this.column("ADMIN"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 10: {
                this.setMetaTableName("ROLES");
                columnArray = new Column[]{this.column("NAME"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 11: {
                this.setMetaTableName("RIGHTS");
                columnArray = new Column[]{this.column("GRANTEE"), this.column("GRANTEETYPE"), this.column("GRANTEDROLE"), this.column("RIGHTS"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setMetaTableName("FUNCTION_ALIASES");
                columnArray = new Column[]{this.column("ALIAS_CATALOG"), this.column("ALIAS_SCHEMA"), this.column("ALIAS_NAME"), this.column("JAVA_CLASS"), this.column("JAVA_METHOD"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("COLUMN_COUNT", TypeInfo.TYPE_INTEGER), this.column("RETURNS_RESULT", TypeInfo.TYPE_SMALLINT), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("SOURCE")};
                break;
            }
            case 20: {
                this.setMetaTableName("FUNCTION_COLUMNS");
                columnArray = new Column[]{this.column("ALIAS_CATALOG"), this.column("ALIAS_SCHEMA"), this.column("ALIAS_NAME"), this.column("JAVA_CLASS"), this.column("JAVA_METHOD"), this.column("COLUMN_COUNT", TypeInfo.TYPE_INTEGER), this.column("POS", TypeInfo.TYPE_INTEGER), this.column("COLUMN_NAME"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("PRECISION", TypeInfo.TYPE_INTEGER), this.column("SCALE", TypeInfo.TYPE_SMALLINT), this.column("RADIX", TypeInfo.TYPE_SMALLINT), this.column("NULLABLE", TypeInfo.TYPE_SMALLINT), this.column("COLUMN_TYPE", TypeInfo.TYPE_SMALLINT), this.column("REMARKS"), this.column("COLUMN_DEFAULT")};
                break;
            }
            case 13: {
                this.setMetaTableName("SCHEMATA");
                columnArray = new Column[]{this.column("CATALOG_NAME"), this.column("SCHEMA_NAME"), this.column("SCHEMA_OWNER"), this.column("DEFAULT_CHARACTER_SET_NAME"), this.column("DEFAULT_COLLATION_NAME"), this.column("IS_DEFAULT", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 14: {
                this.setMetaTableName("TABLE_PRIVILEGES");
                columnArray = new Column[]{this.column("GRANTOR"), this.column("GRANTEE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("PRIVILEGE_TYPE"), this.column("IS_GRANTABLE")};
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setMetaTableName("COLUMN_PRIVILEGES");
                columnArray = new Column[]{this.column("GRANTOR"), this.column("GRANTEE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("PRIVILEGE_TYPE"), this.column("IS_GRANTABLE")};
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setMetaTableName("COLLATIONS");
                columnArray = new Column[]{this.column("NAME"), this.column("KEY")};
                break;
            }
            case 17: {
                this.setMetaTableName("VIEWS");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("VIEW_DEFINITION"), this.column("CHECK_OPTION"), this.column("IS_UPDATABLE"), this.column("STATUS"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setMetaTableName("IN_DOUBT");
                columnArray = new Column[]{this.column("TRANSACTION"), this.column("STATE")};
                break;
            }
            case 19: {
                this.setMetaTableName("CROSS_REFERENCES");
                columnArray = new Column[]{this.column("PKTABLE_CATALOG"), this.column("PKTABLE_SCHEMA"), this.column("PKTABLE_NAME"), this.column("PKCOLUMN_NAME"), this.column("FKTABLE_CATALOG"), this.column("FKTABLE_SCHEMA"), this.column("FKTABLE_NAME"), this.column("FKCOLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_SMALLINT), this.column("UPDATE_RULE", TypeInfo.TYPE_SMALLINT), this.column("DELETE_RULE", TypeInfo.TYPE_SMALLINT), this.column("FK_NAME"), this.column("PK_NAME"), this.column("DEFERRABILITY", TypeInfo.TYPE_SMALLINT)};
                string = "PKTABLE_NAME";
                break;
            }
            case 21: {
                this.setMetaTableName("CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CONSTRAINT_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("UNIQUE_INDEX_NAME"), this.column("CHECK_EXPRESSION"), this.column("COLUMN_LIST"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setMetaTableName("CONSTANTS");
                columnArray = new Column[]{this.column("CONSTANT_CATALOG"), this.column("CONSTANT_SCHEMA"), this.column("CONSTANT_NAME"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 23: {
                this.setMetaTableName("DOMAINS");
                columnArray = new Column[]{this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("DOMAIN_DEFAULT"), this.column("DOMAIN_ON_UPDATE"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("PRECISION", TypeInfo.TYPE_INTEGER), this.column("SCALE", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("PARENT_DOMAIN_CATALOG"), this.column("PARENT_DOMAIN_SCHEMA"), this.column("PARENT_DOMAIN_NAME"), this.column("SELECTIVITY", TypeInfo.TYPE_INTEGER), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("COLUMN_DEFAULT"), this.column("IS_NULLABLE"), this.column("CHECK_CONSTRAINT")};
                break;
            }
            case 24: {
                this.setMetaTableName("TRIGGERS");
                columnArray = new Column[]{this.column("TRIGGER_CATALOG"), this.column("TRIGGER_SCHEMA"), this.column("TRIGGER_NAME"), this.column("TRIGGER_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("BEFORE", TypeInfo.TYPE_BOOLEAN), this.column("JAVA_CLASS"), this.column("QUEUE_SIZE", TypeInfo.TYPE_INTEGER), this.column("NO_WAIT", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 25: {
                this.setMetaTableName("SESSIONS");
                columnArray = new Column[]{this.column("ID", TypeInfo.TYPE_INTEGER), this.column("USER_NAME"), this.column("SERVER"), this.column("CLIENT_ADDR"), this.column("CLIENT_INFO"), this.column("SESSION_START", TypeInfo.TYPE_TIMESTAMP_TZ), this.column("ISOLATION_LEVEL"), this.column("STATEMENT"), this.column("STATEMENT_START", TypeInfo.TYPE_TIMESTAMP_TZ), this.column("CONTAINS_UNCOMMITTED", TypeInfo.TYPE_BOOLEAN), this.column("STATE"), this.column("BLOCKER_ID", TypeInfo.TYPE_INTEGER), this.column("SLEEP_SINCE", TypeInfo.TYPE_TIMESTAMP_TZ)};
                break;
            }
            case 26: {
                this.setMetaTableName("LOCKS");
                columnArray = new Column[]{this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("SESSION_ID", TypeInfo.TYPE_INTEGER), this.column("LOCK_TYPE")};
                break;
            }
            case 27: {
                this.setMetaTableName("SESSION_STATE");
                columnArray = new Column[]{this.column("KEY"), this.column("SQL")};
                break;
            }
            case 28: {
                this.setMetaTableName("QUERY_STATISTICS");
                columnArray = new Column[]{this.column("SQL_STATEMENT"), this.column("EXECUTION_COUNT", TypeInfo.TYPE_INTEGER), this.column("MIN_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("MAX_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("CUMULATIVE_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("AVERAGE_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("STD_DEV_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("MIN_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("MAX_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("CUMULATIVE_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("AVERAGE_ROW_COUNT", TypeInfo.TYPE_DOUBLE), this.column("STD_DEV_ROW_COUNT", TypeInfo.TYPE_DOUBLE)};
                break;
            }
            case 29: {
                this.setMetaTableName("SYNONYMS");
                columnArray = new Column[]{this.column("SYNONYM_CATALOG"), this.column("SYNONYM_SCHEMA"), this.column("SYNONYM_NAME"), this.column("SYNONYM_FOR"), this.column("SYNONYM_FOR_SCHEMA"), this.column("TYPE_NAME"), this.column("STATUS"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "SYNONYM_NAME";
                break;
            }
            case 30: {
                this.setMetaTableName("TABLE_CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CONSTRAINT_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("IS_DEFERRABLE"), this.column("INITIALLY_DEFERRED"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                string = "TABLE_NAME";
                break;
            }
            case 31: {
                this.setMetaTableName("DOMAIN_CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("IS_DEFERRABLE"), this.column("INITIALLY_DEFERRED"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 32: {
                this.setMetaTableName("KEY_COLUMN_USAGE");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("POSITION_IN_UNIQUE_CONSTRAINT", TypeInfo.TYPE_INTEGER), this.column("INDEX_CATALOG"), this.column("INDEX_SCHEMA"), this.column("INDEX_NAME")};
                string = "TABLE_NAME";
                break;
            }
            case 33: {
                this.setMetaTableName("REFERENTIAL_CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("UNIQUE_CONSTRAINT_CATALOG"), this.column("UNIQUE_CONSTRAINT_SCHEMA"), this.column("UNIQUE_CONSTRAINT_NAME"), this.column("MATCH_OPTION"), this.column("UPDATE_RULE"), this.column("DELETE_RULE")};
                break;
            }
            case 34: {
                this.setMetaTableName("CHECK_CONSTRAINTS");
                columnArray = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CHECK_CLAUSE")};
                break;
            }
            case 35: {
                this.setMetaTableName("CONSTRAINT_COLUMN_USAGE");
                columnArray = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME")};
                string = "TABLE_NAME";
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(this.database.sysIdentifier(string)).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private static String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    @Override
    public ArrayList<Row> generateRows(SessionLocal sessionLocal, SearchRow searchRow, SearchRow searchRow2) {
        Value value = this.indexColumn >= 0 && searchRow != null ? searchRow.getValue(this.indexColumn) : null;
        Value value2 = this.indexColumn >= 0 && searchRow2 != null ? searchRow2.getValue(this.indexColumn) : null;
        ArrayList<Row> arrayList = Utils.newSmallArrayList();
        String string3 = this.database.getShortName();
        boolean bl = sessionLocal.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                this.getAllTables(sessionLocal, value, value2).forEach(table -> {
                    String string2 = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    String string3 = table.getCreateSQL();
                    if (!bl && string3 != null && string3.contains("--hide--")) {
                        string3 = "-";
                    }
                    this.add(sessionLocal, arrayList, string3, table.getSchema().getName(), table.getName(), table.getTableType().toString(), string2, string3, InformationSchemaTableLegacy.replaceNullWithEmpty(table.getComment()), ValueBigint.get(table.getMaxDataModificationId()), ValueInteger.get(table.getId()), null, table.getClass().getName(), ValueBigint.get(table.getRowCountApproximation(sessionLocal)));
                });
                break;
            }
            case 1: {
                this.getAllTables(sessionLocal, value, value2).forEach(table -> {
                    Column[] columnArray = table.getColumns();
                    String string2 = this.database.getCompareMode().getName();
                    for (int i = 0; i < columnArray.length; ++i) {
                        Column column = columnArray[i];
                        Domain domain = column.getDomain();
                        TypeInfo typeInfo = column.getType();
                        ValueInteger valueInteger = ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                        ValueInteger valueInteger2 = ValueInteger.get(typeInfo.getScale());
                        Sequence sequence = column.getSequence();
                        int n = typeInfo.getValueType();
                        boolean bl = switch (n) {
                            case 17, 18, 19, 20, 21, 27, 31, 33, 34 -> true;
                            default -> false;
                        };
                        boolean bl2 = column.isGenerated();
                        boolean bl3 = DataType.isIntervalType(n);
                        String string3 = column.getCreateSQLWithoutName();
                        this.add(sessionLocal, arrayList, string3, table.getSchema().getName(), table.getName(), column.getName(), ValueInteger.get(i + 1), bl2 ? null : column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), valueInteger, valueInteger, valueInteger, ValueInteger.get(10), valueInteger2, bl ? valueInteger2 : null, bl3 ? string3.substring(9) : null, bl3 ? valueInteger : null, CHARACTER_SET_NAME, string2, domain != null ? string3 : null, domain != null ? domain.getSchema().getName() : null, domain != null ? domain.getName() : null, bl2 ? "ALWAYS" : "NEVER", bl2 ? column.getDefaultSQL() : null, this.identifier(bl3 ? "INTERVAL" : typeInfo.getDeclaredTypeName()), ValueInteger.get(column.isNullable() ? 1 : 0), ValueBoolean.get(bl2), ValueInteger.get(column.getSelectivity()), sequence == null ? null : sequence.getName(), InformationSchemaTableLegacy.replaceNullWithEmpty(column.getComment()), null, string3, column.getOnUpdateSQL(), ValueBoolean.get(column.getVisible()), null);
                    }
                });
                break;
            }
            case 2: {
                this.getAllTables(sessionLocal, value, value2).forEach(table -> {
                    ArrayList<Index> arrayList2 = table.getIndexes();
                    ArrayList<Constraint> arrayList3 = table.getConstraints();
                    for (int i = 0; arrayList2 != null && i < arrayList2.size(); ++i) {
                        Index index = arrayList2.get(i);
                        if (index.getCreateSQL() == null) continue;
                        String string2 = null;
                        for (int j = 0; arrayList3 != null && j < arrayList3.size(); ++j) {
                            Constraint constraint = arrayList3.get(j);
                            if (!constraint.usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (constraint.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                                string2 = constraint.getName();
                                continue;
                            }
                            string2 = constraint.getName();
                        }
                        IndexColumn[] indexColumnArray = index.getIndexColumns();
                        int n = index.getUniqueColumnCount();
                        String string3 = index.getClass().getName();
                        for (int j = 0; j < indexColumnArray.length; ++j) {
                            IndexColumn indexColumn = indexColumnArray[j];
                            Column column = indexColumn.column;
                            this.add(sessionLocal, arrayList, string3, table.getSchema().getName(), table.getName(), ValueBoolean.get(j >= n), index.getName(), ValueSmallint.get((short)(j + 1)), column.getName(), ValueInteger.get(0), ValueBoolean.get(index.getIndexType().isPrimaryKey()), index.getIndexType().getSQL(false), ValueBoolean.get(index.getIndexType().getBelongsToConstraint()), ValueSmallint.get((short)3), (indexColumn.sortType & 1) != 0 ? "D" : "A", ValueInteger.get(0), "", InformationSchemaTableLegacy.replaceNullWithEmpty(index.getComment()), index.getCreateSQL(), ValueInteger.get(index.getId()), ValueInteger.get(indexColumn.sortType), string2, string3);
                        }
                    }
                });
                break;
            }
            case 3: {
                this.add(sessionLocal, arrayList, TableType.TABLE.toString());
                this.add(sessionLocal, arrayList, TableType.TABLE_LINK.toString());
                this.add(sessionLocal, arrayList, TableType.SYSTEM_TABLE.toString());
                this.add(sessionLocal, arrayList, TableType.VIEW.toString());
                this.add(sessionLocal, arrayList, TableType.EXTERNAL_TABLE_ENGINE.toString());
                break;
            }
            case 4: {
                int n = 42;
                for (int i = 1; i < n; ++i) {
                    DataType dataType = DataType.getDataType(i);
                    this.add(sessionLocal, arrayList, Value.getTypeName(dataType.type), ValueInteger.get(dataType.sqlType), ValueInteger.get(MathUtils.convertLongToInt(dataType.maxPrecision)), dataType.prefix, dataType.suffix, dataType.params, ValueBoolean.FALSE, ValueSmallint.get(MathUtils.convertIntToShort(dataType.minScale)), ValueSmallint.get(MathUtils.convertIntToShort(dataType.maxScale)), DataType.isNumericType(i) ? ValueInteger.get(10) : null, ValueInteger.get(dataType.type), ValueBoolean.get(dataType.caseSensitive), ValueSmallint.get((short)1), ValueSmallint.get((short)3));
                }
                break;
            }
            case 5: {
                this.add(sessionLocal, arrayList, string3);
                break;
            }
            case 6: {
                Object object = this.database.getAllSettings().iterator();
                while (object.hasNext()) {
                    Setting objectArray = object.next();
                    String inputStreamReader = objectArray.getStringValue();
                    if (inputStreamReader == null) {
                        inputStreamReader = Integer.toString(objectArray.getIntValue());
                    }
                    this.add(sessionLocal, arrayList, this.identifier(objectArray.getName()), inputStreamReader);
                }
                this.add(sessionLocal, arrayList, "info.BUILD_ID", "229");
                this.add(sessionLocal, arrayList, "info.VERSION_MAJOR", "2");
                this.add(sessionLocal, arrayList, "info.VERSION_MINOR", "2");
                this.add(sessionLocal, arrayList, "info.VERSION", Constants.FULL_VERSION);
                if (bl) {
                    String[] byArray = object = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    int sequence = byArray.length;
                    for (int dbObject = 0; dbObject < sequence; ++dbObject) {
                        String string8 = byArray[dbObject];
                        this.add(sessionLocal, arrayList, "property." + string8, Utils.getProperty(string8, ""));
                    }
                }
                this.add(sessionLocal, arrayList, "DEFAULT_NULL_ORDERING", this.database.getDefaultNullOrdering().name());
                this.add(sessionLocal, arrayList, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
                this.add(sessionLocal, arrayList, "MODE", this.database.getMode().getName());
                this.add(sessionLocal, arrayList, "QUERY_TIMEOUT", Integer.toString(sessionLocal.getQueryTimeout()));
                this.add(sessionLocal, arrayList, "TIME ZONE", sessionLocal.currentTimeZone().getId());
                this.add(sessionLocal, arrayList, "TRUNCATE_LARGE_LENGTH", sessionLocal.isTruncateLargeLength() ? "TRUE" : "FALSE");
                this.add(sessionLocal, arrayList, "VARIABLE_BINARY", sessionLocal.isVariableBinary() ? "TRUE" : "FALSE");
                this.add(sessionLocal, arrayList, "OLD_INFORMATION_SCHEMA", sessionLocal.isOldInformationSchema() ? "TRUE" : "FALSE");
                object = sessionLocal.getNonKeywords();
                if (object != null) {
                    this.add(sessionLocal, arrayList, "NON_KEYWORDS", ParserBase.formatNonKeywords((BitSet)object));
                }
                this.add(sessionLocal, arrayList, "RETENTION_TIME", Integer.toString(this.database.getRetentionTime()));
                for (Map.Entry<String, String> functionAlias : this.database.getSettings().getSortedSettings()) {
                    this.add(sessionLocal, arrayList, functionAlias.getKey(), functionAlias.getValue());
                }
                this.database.getStore().getMvStore().populateInfo((string, string2) -> this.add(sessionLocal, arrayList, string, string2));
                break;
            }
            case 7: {
                String string5 = "/org/h2/res/help.csv";
                try {
                    byte[] rightOwner = Utils.getResource(string5);
                    InputStreamReader role = new InputStreamReader((InputStream)new ByteArrayInputStream(rightOwner), StandardCharsets.UTF_8);
                    Csv userDefinedFunction = new Csv();
                    userDefinedFunction.setLineCommentCharacter('#');
                    ResultSet dbObject4 = userDefinedFunction.read(role, null);
                    int n = dbObject4.getMetaData().getColumnCount() - 1;
                    String[] dbException = new String[5];
                    int n2 = 0;
                    while (dbObject4.next()) {
                        for (int i = 0; i < n; ++i) {
                            String string4 = dbObject4.getString(1 + i);
                            switch (i) {
                                case 2: {
                                    string4 = Help.stripAnnotationsFromSyntax(string4);
                                    break;
                                }
                                case 3: {
                                    string4 = Help.processHelpText(string4);
                                }
                            }
                            dbException[i] = string4.trim();
                        }
                        this.add(sessionLocal, arrayList, ValueInteger.get(n2), dbException[0], dbException[1], dbException[2], dbException[3]);
                        ++n2;
                    }
                    break;
                }
                catch (Exception rightOwner) {
                    throw DbException.convert(rightOwner);
                }
            }
            case 8: {
                for (SchemaObject right : this.getAllSchemaObjects(3)) {
                    Sequence role = (Sequence)right;
                    TypeInfo userDefinedFunction = role.getDataType();
                    String typeInfo = Value.getTypeName(userDefinedFunction.getValueType());
                    ValueInteger command0 = ValueInteger.get(userDefinedFunction.getScale());
                    this.add(sessionLocal, arrayList, string3, role.getSchema().getName(), role.getName(), typeInfo, ValueInteger.get(role.getEffectivePrecision()), ValueInteger.get(10), command0, ValueBigint.get(role.getStartValue()), ValueBigint.get(role.getMinValue()), ValueBigint.get(role.getMaxValue()), ValueBigint.get(role.getIncrement()), role.getCycle().isCycle() ? "YES" : "NO", typeInfo, ValueInteger.get((int)userDefinedFunction.getPrecision()), command0, ValueBigint.get(role.getCurrentValue()), ValueBoolean.get(role.getBelongsToTable()), InformationSchemaTableLegacy.replaceNullWithEmpty(role.getComment()), ValueBigint.get(role.getCacheSize()), ValueInteger.get(role.getId()), ValueBigint.get(role.getMinValue()), ValueBigint.get(role.getMaxValue()), ValueBoolean.get(role.getCycle().isCycle()));
                }
                break;
            }
            case 9: {
                for (RightOwner schema : this.database.getAllUsersAndRoles()) {
                    if (!(schema instanceof User)) continue;
                    User user = (User)schema;
                    if (!bl && sessionLocal.getUser() != user) continue;
                    this.add(sessionLocal, arrayList, this.identifier(user.getName()), String.valueOf(user.isAdmin()), InformationSchemaTableLegacy.replaceNullWithEmpty(user.getComment()), ValueInteger.get(user.getId()));
                }
                break;
            }
            case 10: {
                for (RightOwner schema : this.database.getAllUsersAndRoles()) {
                    if (!(schema instanceof Role)) continue;
                    Role role = (Role)schema;
                    if (!bl && !sessionLocal.getUser().isRoleGranted(role)) continue;
                    this.add(sessionLocal, arrayList, this.identifier(role.getName()), InformationSchemaTableLegacy.replaceNullWithEmpty(role.getComment()), ValueInteger.get(role.getId()));
                }
                break;
            }
            case 11: {
                if (!bl) break;
                for (Right right : this.database.getAllRights()) {
                    String networkConnectionInfo;
                    Role schema = right.getGrantedRole();
                    DbObject table2 = right.getGrantee();
                    String string5 = networkConnectionInfo = table2.getType() == 2 ? "USER" : "ROLE";
                    if (schema == null) {
                        String string6;
                        DbObject table5 = right.getGrantedObject();
                        Schema schema2 = null;
                        DbObject dbObject = null;
                        if (table5 != null) {
                            if (table5 instanceof Schema) {
                                schema2 = (Schema)table5;
                            } else if (table5 instanceof Table) {
                                dbObject = (Table)table5;
                                schema2 = ((SchemaObject)dbObject).getSchema();
                            }
                        }
                        String string7 = dbObject != null ? dbObject.getName() : "";
                        String string8 = string6 = schema2 != null ? schema2.getName() : "";
                        if (!this.checkIndex(sessionLocal, string7, value, value2)) continue;
                        this.add(sessionLocal, arrayList, this.identifier(table2.getName()), networkConnectionInfo, "", right.getRights(), string6, string7, ValueInteger.get(right.getId()));
                        continue;
                    }
                    this.add(sessionLocal, arrayList, this.identifier(table2.getName()), networkConnectionInfo, this.identifier(schema.getName()), "", "", "", ValueInteger.get(right.getId()));
                }
                break;
            }
            case 12: {
                for (Schema right : this.database.getAllSchemas()) {
                    for (UserDefinedFunction table3 : right.getAllFunctionsAndAggregates()) {
                        if (table3 instanceof FunctionAlias) {
                            FunctionAlias.JavaMethod[] stringBuilder;
                            FunctionAlias functionAlias = (FunctionAlias)table3;
                            try {
                                stringBuilder = functionAlias.getJavaMethods();
                            }
                            catch (DbException dbException) {
                                continue;
                            }
                            for (FunctionAlias.JavaMethod javaMethod : stringBuilder) {
                                TypeInfo typeInfo = javaMethod.getDataType();
                                if (typeInfo == null) {
                                    typeInfo = TypeInfo.TYPE_NULL;
                                }
                                this.add(sessionLocal, arrayList, string3, functionAlias.getSchema().getName(), functionAlias.getName(), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), typeInfo.getDeclaredTypeName(), ValueInteger.get(javaMethod.getParameterCount()), ValueSmallint.get(typeInfo.getValueType() == 0 ? (short)1 : 2), InformationSchemaTableLegacy.replaceNullWithEmpty(functionAlias.getComment()), ValueInteger.get(functionAlias.getId()), functionAlias.getSource());
                            }
                            continue;
                        }
                        this.add(sessionLocal, arrayList, string3, this.database.getMainSchema().getName(), table3.getName(), table3.getJavaClassName(), "", ValueInteger.get(0), "NULL", ValueInteger.get(1), ValueSmallint.get((short)2), InformationSchemaTableLegacy.replaceNullWithEmpty(table3.getComment()), ValueInteger.get(table3.getId()), "");
                    }
                }
                break;
            }
            case 20: {
                for (Schema right : this.database.getAllSchemas()) {
                    for (UserDefinedFunction locale : right.getAllFunctionsAndAggregates()) {
                        FunctionAlias.JavaMethod[] javaMethodArray;
                        if (!(locale instanceof FunctionAlias)) continue;
                        FunctionAlias value3 = (FunctionAlias)locale;
                        try {
                            javaMethodArray = value3.getJavaMethods();
                        }
                        catch (DbException dbException) {
                            continue;
                        }
                        for (FunctionAlias.JavaMethod javaMethod : javaMethodArray) {
                            Object object;
                            TypeInfo typeInfo = javaMethod.getDataType();
                            if (typeInfo != null && typeInfo.getValueType() != 0) {
                                object = DataType.getDataType(typeInfo.getValueType());
                                this.add(sessionLocal, arrayList, string3, value3.getSchema().getName(), value3.getName(), value3.getJavaClassName(), value3.getJavaMethodName(), ValueInteger.get(javaMethod.getParameterCount()), ValueInteger.get(0), "P0", ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), typeInfo.getDeclaredTypeName(), ValueInteger.get(MathUtils.convertLongToInt(object.defaultPrecision)), ValueSmallint.get(MathUtils.convertIntToShort(object.defaultScale)), ValueSmallint.get((short)10), ValueSmallint.get((short)2), ValueSmallint.get((short)5), "", null);
                            }
                            object = javaMethod.getColumnClasses();
                            for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                                if (javaMethod.hasConnectionParam() && i == 0) continue;
                                Class<?> clazz = object[i];
                                TypeInfo typeInfo2 = ValueToObjectConverter2.classToType(clazz);
                                DataType dataType = DataType.getDataType(typeInfo2.getValueType());
                                this.add(sessionLocal, arrayList, string3, value3.getSchema().getName(), value3.getName(), value3.getJavaClassName(), value3.getJavaMethodName(), ValueInteger.get(javaMethod.getParameterCount()), ValueInteger.get(i + (javaMethod.hasConnectionParam() ? 0 : 1)), "P" + (i + 1), ValueInteger.get(DataType.convertTypeToSQLType(typeInfo2)), typeInfo2.getDeclaredTypeName(), ValueInteger.get(MathUtils.convertLongToInt(dataType.defaultPrecision)), ValueSmallint.get(MathUtils.convertIntToShort(dataType.defaultScale)), ValueSmallint.get((short)10), ValueSmallint.get(clazz.isPrimitive() ? (short)0 : 1), ValueSmallint.get((short)1), "", null);
                            }
                        }
                    }
                }
                break;
            }
            case 13: {
                String string13 = this.database.getCompareMode().getName();
                for (Schema schema : this.database.getAllSchemas()) {
                    this.add(sessionLocal, arrayList, string3, schema.getName(), this.identifier(schema.getOwner().getName()), CHARACTER_SET_NAME, string13, ValueBoolean.get(schema.getId() == 0), InformationSchemaTableLegacy.replaceNullWithEmpty(schema.getComment()), ValueInteger.get(schema.getId()));
                }
                break;
            }
            case 14: {
                for (Right right : this.database.getAllRights()) {
                    Table valueExpression;
                    DbObject inDoubtTransaction = right.getGrantedObject();
                    if (!(inDoubtTransaction instanceof Table) || !this.checkIndex(sessionLocal, (valueExpression = (Table)inDoubtTransaction).getName(), value, value2)) continue;
                    this.addPrivileges(sessionLocal, arrayList, right.getGrantee(), string3, valueExpression, null, right.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right schemaObject : this.database.getAllRights()) {
                    Table domain2;
                    DbObject constant = schemaObject.getGrantedObject();
                    if (!(constant instanceof Table) || !this.checkIndex(sessionLocal, (domain2 = (Table)constant).getName(), value, value2)) continue;
                    DbObject dbObject = schemaObject.getGrantee();
                    int n = schemaObject.getRightMask();
                    for (Column column : domain2.getColumns()) {
                        this.addPrivileges(sessionLocal, arrayList, dbObject, string3, domain2, column.getName(), n);
                    }
                }
                break;
            }
            case 16: {
                for (Locale table4 : CompareMode.getCollationLocales(false)) {
                    this.add(sessionLocal, arrayList, CompareMode.getName(table4), table4.toString());
                }
                break;
            }
            case 17: {
                this.getAllTables(sessionLocal, value, value2).filter(Table::isView).forEach(table -> this.add(sessionLocal, arrayList, string3, table.getSchema().getName(), table.getName(), table.getCreateSQL(), "NONE", "NO", table instanceof TableView && ((TableView)table).isInvalid() ? "INVALID" : "VALID", InformationSchemaTableLegacy.replaceNullWithEmpty(table.getComment()), ValueInteger.get(table.getId())));
                break;
            }
            case 18: {
                ArrayList<InDoubtTransaction> arrayList2 = this.database.getInDoubtTransactions();
                if (arrayList2 == null || !bl) break;
                for (InDoubtTransaction triggerObject : arrayList2) {
                    this.add(sessionLocal, arrayList, triggerObject.getTransactionName(), triggerObject.getStateDescription());
                }
                break;
            }
            case 19: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType() == Constraint.Type.REFERENTIAL && this.checkIndex(sessionLocal, constraint.getName(), value, value2)).forEach(constraint -> {
                    ConstraintReferential constraintReferential = (ConstraintReferential)constraint;
                    IndexColumn[] indexColumnArray = constraintReferential.getColumns();
                    IndexColumn[] indexColumnArray2 = constraintReferential.getRefColumns();
                    Table table = constraintReferential.getTable();
                    Table table2 = constraintReferential.getRefTable();
                    ValueSmallint valueSmallint = ValueSmallint.get(InformationSchemaTableLegacy.getRefAction(constraintReferential.getUpdateAction()));
                    ValueSmallint valueSmallint2 = ValueSmallint.get(InformationSchemaTableLegacy.getRefAction(constraintReferential.getDeleteAction()));
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        this.add(sessionLocal, arrayList, string3, table2.getSchema().getName(), table2.getName(), indexColumnArray2[i].column.getName(), string3, table.getSchema().getName(), table.getName(), indexColumnArray[i].column.getName(), ValueSmallint.get((short)(i + 1)), valueSmallint, valueSmallint2, constraintReferential.getName(), constraintReferential.getReferencedConstraint().getName(), ValueSmallint.get((short)7));
                    }
                });
                break;
            }
            case 21: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType() != Constraint.Type.DOMAIN && this.checkIndex(sessionLocal, constraint.getTable().getName(), value, value2)).forEach(constraint -> {
                    Constraint.Type type = constraint.getConstraintType();
                    String string2 = null;
                    IndexColumn[] indexColumnArray = null;
                    Table table = constraint.getTable();
                    Index index = constraint.getIndex();
                    String string3 = null;
                    if (index != null) {
                        string3 = index.getName();
                    }
                    if (type == Constraint.Type.CHECK) {
                        string2 = constraint.getExpression().getSQL(0);
                    } else if (type.isUnique()) {
                        indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (type == Constraint.Type.REFERENTIAL) {
                        indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    }
                    String string4 = null;
                    if (indexColumnArray != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n = indexColumnArray.length;
                        for (int i = 0; i < n; ++i) {
                            if (i > 0) {
                                stringBuilder.append(',');
                            }
                            stringBuilder.append(indexColumnArray[i].column.getName());
                        }
                        string4 = stringBuilder.toString();
                    }
                    this.add(sessionLocal, arrayList, string3, constraint.getSchema().getName(), constraint.getName(), type == Constraint.Type.PRIMARY_KEY ? type.getSqlName() : type.name(), string3, table.getSchema().getName(), table.getName(), string3, string2, string4, InformationSchemaTableLegacy.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInteger.get(constraint.getId()));
                });
                break;
            }
            case 22: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(11)) {
                    Constant constant = (Constant)schemaObject;
                    ValueExpression sessionLocal2 = constant.getValue();
                    this.add(sessionLocal, arrayList, string3, constant.getSchema().getName(), constant.getName(), ValueInteger.get(DataType.convertTypeToSQLType(sessionLocal2.getType())), InformationSchemaTableLegacy.replaceNullWithEmpty(constant.getComment()), sessionLocal2.getSQL(0), ValueInteger.get(constant.getId()));
                }
                break;
            }
            case 23: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(12)) {
                    Domain domain = (Domain)schemaObject;
                    Domain sessionLocal3 = domain.getDomain();
                    TypeInfo typeInfo = domain.getDataType();
                    this.add(sessionLocal, arrayList, string3, domain.getSchema().getName(), domain.getName(), domain.getDefaultSQL(), domain.getOnUpdateSQL(), ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision())), ValueInteger.get(typeInfo.getScale()), typeInfo.getDeclaredTypeName(), sessionLocal3 != null ? string3 : null, sessionLocal3 != null ? sessionLocal3.getSchema().getName() : null, sessionLocal3 != null ? sessionLocal3.getName() : null, ValueInteger.get(50), InformationSchemaTableLegacy.replaceNullWithEmpty(domain.getComment()), domain.getCreateSQL(), ValueInteger.get(domain.getId()), domain.getDefaultSQL(), "YES", null);
                }
                break;
            }
            case 24: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(4)) {
                    TriggerObject i = (TriggerObject)schemaObject;
                    Table string15 = i.getTable();
                    this.add(sessionLocal, arrayList, string3, i.getSchema().getName(), i.getName(), i.getTypeNameList(new StringBuilder()).toString(), string3, string15.getSchema().getName(), string15.getName(), ValueBoolean.get(i.isBefore()), i.getTriggerClassName(), ValueInteger.get(i.getQueueSize()), ValueBoolean.get(i.isNoWait()), InformationSchemaTableLegacy.replaceNullWithEmpty(i.getComment()), i.getCreateSQL(), ValueInteger.get(i.getId()));
                }
                break;
            }
            case 25: {
                for (SessionLocal n : this.database.getSessions(false)) {
                    if (!bl && n != sessionLocal) continue;
                    NetworkConnectionInfo networkConnectionInfo = n.getNetworkConnectionInfo();
                    Command0 command0 = n.getCurrentCommand();
                    int n3 = n.getBlockingSessionId();
                    this.add(sessionLocal, arrayList, ValueInteger.get(n.getId()), n.getUser().getName(), networkConnectionInfo == null ? null : networkConnectionInfo.getServer(), networkConnectionInfo == null ? null : networkConnectionInfo.getClient(), networkConnectionInfo == null ? null : networkConnectionInfo.getClientInfo(), n.getSessionStart(), n.getIsolationLevel().getSQL(), command0 == null ? null : command0.toString(), command0 == null ? null : n.getCommandStartOrEnd(), ValueBoolean.get(n.hasPendingTransaction()), String.valueOf((Object)n.getState()), n3 == 0 ? null : ValueInteger.get(n3), n.getState() == SessionLocal.State.SLEEP ? n.getCommandStartOrEnd() : null);
                }
                break;
            }
            case 26: {
                for (SessionLocal domain : this.database.getSessions(false)) {
                    if (!bl && domain != sessionLocal) continue;
                    for (Table table2 : domain.getLocks()) {
                        this.add(sessionLocal, arrayList, table2.getSchema().getName(), table2.getName(), ValueInteger.get(domain.getId()), table2.isLockedExclusivelyBy(domain) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 27: {
                TimeZoneProvider timeZoneProvider;
                String schemaObject;
                for (String string9 : sessionLocal.getVariableNames()) {
                    Value value3 = sessionLocal.getVariable(string9);
                    StringBuilder stringBuilder = new StringBuilder().append("SET @").append(string9).append(' ');
                    value3.getSQL(stringBuilder, 0);
                    this.add(sessionLocal, arrayList, "@" + string9, stringBuilder.toString());
                }
                for (Table table3 : sessionLocal.getLocalTempTables()) {
                    this.add(sessionLocal, arrayList, "TABLE " + table3.getName(), table3.getCreateSQL());
                }
                String[] stringArray = sessionLocal.getSchemaSearchPath();
                if (stringArray != null && stringArray.length > 0) {
                    StringBuilder tableSynonym = new StringBuilder("SET SCHEMA_SEARCH_PATH ");
                    int n = stringArray.length;
                    for (int constraintDomain = 0; constraintDomain < n; ++constraintDomain) {
                        if (constraintDomain > 0) {
                            tableSynonym.append(", ");
                        }
                        StringUtils.quoteIdentifier(tableSynonym, (String)stringArray[constraintDomain]);
                    }
                    this.add(sessionLocal, arrayList, "SCHEMA_SEARCH_PATH", tableSynonym.toString());
                }
                if ((schemaObject = sessionLocal.getCurrentSchemaName()) != null) {
                    this.add(sessionLocal, arrayList, "SCHEMA", StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), schemaObject).toString());
                }
                if ((timeZoneProvider = sessionLocal.currentTimeZone()).equals(DateTimeUtils.getTimeZone())) break;
                this.add(sessionLocal, arrayList, "TIME ZONE", StringUtils.quoteStringSQL(new StringBuilder("SET TIME ZONE "), timeZoneProvider.getId()).toString());
                break;
            }
            case 28: {
                QueryStatisticsData queryStatisticsData = this.database.getQueryStatisticsData();
                if (queryStatisticsData == null) break;
                for (QueryStatisticsData.QueryEntry queryEntry : queryStatisticsData.getQueries()) {
                    this.add(sessionLocal, arrayList, queryEntry.sqlStatement, ValueInteger.get(queryEntry.count), ValueDouble.get((double)queryEntry.executionTimeMinNanos / 1000000.0), ValueDouble.get((double)queryEntry.executionTimeMaxNanos / 1000000.0), ValueDouble.get((double)queryEntry.executionTimeCumulativeNanos / 1000000.0), ValueDouble.get(queryEntry.executionTimeMeanNanos / 1000000.0), ValueDouble.get(queryEntry.getExecutionTimeStandardDeviation() / 1000000.0), ValueBigint.get(queryEntry.rowCountMin), ValueBigint.get(queryEntry.rowCountMax), ValueBigint.get(queryEntry.rowCountCumulative), ValueDouble.get(queryEntry.rowCountMean), ValueDouble.get(queryEntry.getRowCountStandardDeviation()));
                }
                break;
            }
            case 29: {
                for (TableSynonym tableSynonym : this.database.getAllSynonyms()) {
                    this.add(sessionLocal, arrayList, string3, tableSynonym.getSchema().getName(), tableSynonym.getName(), tableSynonym.getSynonymForName(), tableSynonym.getSynonymForSchema().getName(), "SYNONYM", "VALID", InformationSchemaTableLegacy.replaceNullWithEmpty(tableSynonym.getComment()), ValueInteger.get(tableSynonym.getId()));
                }
                break;
            }
            case 30: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType() != Constraint.Type.DOMAIN && this.checkIndex(sessionLocal, constraint.getTable().getName(), value, value2)).forEach(constraint -> {
                    Constraint.Type type = constraint.getConstraintType();
                    Table table = constraint.getTable();
                    this.add(sessionLocal, arrayList, string3, constraint.getSchema().getName(), constraint.getName(), type.getSqlName(), string3, table.getSchema().getName(), table.getName(), "NO", "NO", InformationSchemaTableLegacy.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInteger.get(constraint.getId()));
                });
                break;
            }
            case 31: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    if (((Constraint)schemaObject).getConstraintType() != Constraint.Type.DOMAIN) continue;
                    ConstraintDomain constraintDomain = (ConstraintDomain)schemaObject;
                    Domain domain = constraintDomain.getDomain();
                    this.add(sessionLocal, arrayList, string3, constraintDomain.getSchema().getName(), constraintDomain.getName(), string3, domain.getSchema().getName(), domain.getName(), "NO", "NO", InformationSchemaTableLegacy.replaceNullWithEmpty(constraintDomain.getComment()), constraintDomain.getCreateSQL(), ValueInteger.get(constraintDomain.getId()));
                }
                break;
            }
            case 32: {
                this.getAllConstraints(sessionLocal).forEach(constraint -> {
                    IndexColumn[] indexColumnArray;
                    Constraint.Type type = constraint.getConstraintType();
                    if (type.isUnique()) {
                        indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (type == Constraint.Type.REFERENTIAL) {
                        indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    } else {
                        return;
                    }
                    Table table = constraint.getTable();
                    String string2 = table.getName();
                    if (!this.checkIndex(sessionLocal, string2, value, value2)) {
                        return;
                    }
                    ConstraintUnique constraintUnique = type == Constraint.Type.REFERENTIAL ? constraint.getReferencedConstraint() : null;
                    Index index = constraint.getIndex();
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        IndexColumn indexColumn = indexColumnArray[i];
                        ValueInteger valueInteger = ValueInteger.get(i + 1);
                        ValueInteger valueInteger2 = null;
                        if (constraintUnique != null) {
                            Column column = ((ConstraintReferential)constraint).getRefColumns()[i].column;
                            IndexColumn[] indexColumnArray2 = constraintUnique.getColumns();
                            for (int j = 0; j < indexColumnArray2.length; ++j) {
                                if (!indexColumnArray2[j].column.equals(column)) continue;
                                valueInteger2 = ValueInteger.get(j + 1);
                                break;
                            }
                        }
                        this.add(sessionLocal, arrayList, string3, constraint.getSchema().getName(), constraint.getName(), string3, table.getSchema().getName(), string2, indexColumn.columnName, valueInteger, valueInteger2, index != null ? string3 : null, index != null ? index.getSchema().getName() : null, index != null ? index.getName() : null);
                    }
                });
                break;
            }
            case 33: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType() == Constraint.Type.REFERENTIAL && this.checkIndex(sessionLocal, constraint.getName(), value, value2)).forEach(constraint -> {
                    ConstraintReferential constraintReferential = (ConstraintReferential)constraint;
                    ConstraintUnique constraintUnique = constraintReferential.getReferencedConstraint();
                    this.add(sessionLocal, arrayList, string3, constraintReferential.getSchema().getName(), constraintReferential.getName(), string3, constraintUnique.getSchema().getName(), constraintUnique.getName(), "NONE", constraintReferential.getUpdateAction().getSqlName(), constraintReferential.getDeleteAction().getSqlName());
                });
                break;
            }
            case 34: {
                this.getAllConstraints(sessionLocal).filter(constraint -> constraint.getConstraintType().isCheck() && this.checkIndex(sessionLocal, constraint.getName(), value, value2)).forEach(constraint -> this.add(sessionLocal, arrayList, string3, constraint.getSchema().getName(), constraint.getName(), constraint.getExpression().getSQL(0, 2)));
                break;
            }
            case 35: {
                this.getAllConstraints(sessionLocal).forEach(constraint -> {
                    switch (constraint.getConstraintType()) {
                        case CHECK: 
                        case DOMAIN: {
                            HashSet<Column> hashSet = new HashSet<Column>();
                            constraint.getExpression().isEverything(ExpressionVisitor.getColumnsVisitor(hashSet, null));
                            for (Column column : hashSet) {
                                Table table = column.getTable();
                                if (!this.checkIndex(sessionLocal, table.getName(), value, value2)) continue;
                                this.addConstraintColumnUsage(sessionLocal, arrayList, string3, (Constraint)constraint, column);
                            }
                            break;
                        }
                        case REFERENTIAL: {
                            Table table = constraint.getRefTable();
                            if (this.checkIndex(sessionLocal, table.getName(), value, value2)) {
                                for (Column column : constraint.getReferencedColumns(table)) {
                                    this.addConstraintColumnUsage(sessionLocal, arrayList, string3, (Constraint)constraint, column);
                                }
                            }
                        }
                        case PRIMARY_KEY: 
                        case UNIQUE: {
                            Table table = constraint.getTable();
                            if (!this.checkIndex(sessionLocal, table.getName(), value, value2)) break;
                            for (Column column : constraint.getReferencedColumns(table)) {
                                this.addConstraintColumnUsage(sessionLocal, arrayList, string3, (Constraint)constraint, column);
                            }
                            break;
                        }
                    }
                });
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        return arrayList;
    }

    private static short getRefAction(ConstraintActionType constraintActionType) {
        switch (constraintActionType) {
            case CASCADE: {
                return 0;
            }
            case RESTRICT: {
                return 1;
            }
            case SET_DEFAULT: {
                return 4;
            }
            case SET_NULL: {
                return 2;
            }
        }
        throw DbException.getInternalError("action=" + String.valueOf((Object)constraintActionType));
    }

    private void addConstraintColumnUsage(SessionLocal sessionLocal, ArrayList<Row> arrayList, String string, Constraint constraint, Column column) {
        Table table = column.getTable();
        this.add(sessionLocal, arrayList, string, table.getSchema().getName(), table.getName(), column.getName(), string, constraint.getSchema().getName(), constraint.getName());
    }

    private void addPrivileges(SessionLocal sessionLocal, ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(sessionLocal, arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(sessionLocal, arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(sessionLocal, arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(sessionLocal, arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(SessionLocal sessionLocal, ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(sessionLocal, arrayList, null, this.identifier(dbObject.getName()), string, table.getSchema().getName(), table.getName(), string3, string4);
        } else {
            this.add(sessionLocal, arrayList, null, this.identifier(dbObject.getName()), string, table.getSchema().getName(), table.getName(), string2, string3, string4);
        }
    }

    private ArrayList<SchemaObject> getAllSchemaObjects(int n) {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        for (Schema schema : this.database.getAllSchemas()) {
            schema.getAll(n, arrayList);
        }
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 8: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }
}

