-- Copyright 2004-2024 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

SELECT JSON_OBJECT('key1' : 10, 'key2' VALUE TRUE, KEY 'key3' VALUE 'str', 'key4' : NULL, 'key5' : '[1,2,3]' FORMAT JSON);
>> {"key1":10,"key2":true,"key3":"str","key4":null,"key5":[1,2,3]}

SELECT JSON_OBJECT('key1' : NULL ABSENT ON NULL);
>> {}

SELECT JSON_OBJECT('key1' : JSON 'null' ABSENT ON NULL);
>> {}

SELECT JSON_OBJECT('key1' : NULL NULL ON NULL);
>> {"key1":null}

SELECT JSON_OBJECT('key1' : JSON 'null' NULL ON NULL);
>> {"key1":null}

SELECT JSON_OBJECT();
>> {}

SELECT JSON_OBJECT(NULL ON NULL);
>> {}

SELECT JSON_OBJECT(WITHOUT UNIQUE KEYS);
>> {}

SELECT JSON_OBJECT('key1' : NULL, 'key1' : 2 NULL ON NULL WITHOUT UNIQUE KEYS);
>> {"key1":null,"key1":2}

SELECT JSON_OBJECT('key1' : 1, 'key1' : 2 WITH UNIQUE KEYS);
> exception INVALID_VALUE_2

SELECT JSON_OBJECT('key1' : 1, 'key1' : 2 NULL ON NULL WITH UNIQUE KEYS);
> exception INVALID_VALUE_2

SELECT JSON_OBJECT('key1' : TRUE WITH UNIQUE KEYS);
>> {"key1":true}

SELECT JSON_OBJECT(NULL : 1);
> exception INVALID_VALUE_2

CREATE TABLE TEST(V VARCHAR, ABSENT VARCHAR, WITHOUT VARCHAR);
> ok

EXPLAIN SELECT JSON_OBJECT('name' : V NULL ON NULL WITHOUT UNIQUE KEYS) FROM TEST;
>> SELECT JSON_OBJECT('name': "V") FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */

EXPLAIN SELECT JSON_OBJECT('name' : V ABSENT ON NULL WITH UNIQUE KEYS) FROM TEST;
>> SELECT JSON_OBJECT('name': "V" ABSENT ON NULL WITH UNIQUE KEYS) FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */

EXPLAIN SELECT JSON_OBJECT(ABSENT : 1) FROM TEST;
>> SELECT JSON_OBJECT("ABSENT": 1) FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */

EXPLAIN SELECT JSON_OBJECT(WITHOUT : 1) FROM TEST;
>> SELECT JSON_OBJECT("WITHOUT": 1) FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */

SELECT JSON_OBJECT(NULL ON NULL WITHOUT);
> exception SYNTAX_ERROR_2

DROP TABLE TEST;
> ok

SET MODE MySQL;
> ok

SELECT JSON_OBJECT('key1', 10, 'key2', 'str');
>> {"key1":10,"key2":"str"}

SET MODE MariaDB;
> ok

SELECT JSON_OBJECT('key1', 10, 'key2', 'str');
>> {"key1":10,"key2":"str"}
