/*
 * Decompiled with CFR 0.152.
 */
package udon;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import udon.diff.DiffFormat;
import udon.diff.DiffMarshaller;
import udon.diff.DiffType;
import udon.diff.DiffUnmarshaller;
import udon.diff.Differ;
import udon.diff.Hunk;
import udon.object.ObjectFormat;
import udon.object.ObjectMarshaller;
import udon.object.ObjectPrettyPrinter;
import udon.object.ObjectType;
import udon.object.ObjectUnmarshaller;
import udon.util.Lexer;
import udon.util.UDONException;

public class UDON {
    public static final ObjectFormat OBJECT = new ObjectFormat(){

        @Override
        public ObjectType objectType(Object o) {
            if (o == null) {
                return ObjectType.Null;
            }
            if (o instanceof CharSequence) {
                return ObjectType.String;
            }
            if (o instanceof Boolean) {
                return ObjectType.Bool;
            }
            if (o instanceof List) {
                return ObjectType.Array;
            }
            if (o instanceof Map) {
                return ObjectType.Map;
            }
            if (o instanceof Number) {
                return ObjectType.Number;
            }
            throw new RuntimeException("Unknown object: " + o.getClass().getName());
        }

        @Override
        public void array_add(Object o, Object v) {
            ((List)o).add(v);
        }

        @Override
        public Object array_get(Object o, int i) {
            return ((List)o).get(i);
        }

        @Override
        public int array_length(Object o) {
            return ((List)o).size();
        }

        @Override
        public Object array_new() {
            return new ArrayList();
        }

        @Override
        public Object array_new(List l) {
            return new ArrayList(l);
        }

        @Override
        public Object boolean_new(boolean b) {
            return b;
        }

        @Override
        public boolean boolean_toBoolean(Object b) {
            return (Boolean)b;
        }

        @Override
        public Object null_new() {
            return null;
        }

        @Override
        public Object number_new(String s) {
            return Double.parseDouble(s);
        }

        @Override
        public Object number_newInteger(String s) {
            return Integer.parseInt(s);
        }

        @Override
        public String number_toString(Object o) {
            return o.toString();
        }

        @Override
        public boolean object_has(Object o, Object k) {
            return ((Map)o).containsKey(k);
        }

        @Override
        public Object object_get(Object o, Object k) {
            return ((Map)o).get(k);
        }

        @Override
        public Set object_keys(Object o) {
            return ((Map)o).keySet();
        }

        @Override
        public Object object_new() {
            return new LinkedHashMap();
        }

        @Override
        public void object_put(Object o, Object k, Object v) {
            ((Map)o).put(k, v);
        }

        @Override
        public void object_remove(Object o, Object k) {
            ((Map)o).remove(k);
        }

        @Override
        public int object_size(Object o) {
            return ((Map)o).size();
        }

        @Override
        public Object string_new(String s) {
            return s;
        }

        @Override
        public String string_toString(Object o) {
            return ((CharSequence)o).toString();
        }

        @Override
        public Object deepCopy(Object o) {
            ObjectType t = this.objectType(o);
            switch (t) {
                case Map: {
                    HashMap r = new HashMap();
                    Map m = (Map)o;
                    for (Object k : m.keySet()) {
                        r.put(k, this.deepCopy(m.get(k)));
                    }
                    return r;
                }
                case Array: {
                    List l = (List)o;
                    ArrayList<Object> r = new ArrayList<Object>(l.size());
                    for (Object c : l) {
                        r.add(this.deepCopy(c));
                    }
                    break;
                }
            }
            return o;
        }

        @Override
        public boolean dataEqual(Object a, Object b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.equals(b);
        }
    };
    public static final DiffFormat DIFF = new DiffFormat(){

        @Override
        public DiffType diffType(Object o) {
            if (o instanceof Diff.Entry) {
                return DiffType.Entry;
            }
            if (o instanceof Diff.Map) {
                return DiffType.Map;
            }
            if (o instanceof Diff.Seq) {
                Diff.Seq ds = (Diff.Seq)o;
                return ds.text ? DiffType.Text : DiffType.List;
            }
            return null;
        }

        @Override
        public Object diff_entry_new(Object l, Object r) {
            return new Diff.Entry(l, r);
        }

        @Override
        public Object diff_entry_l(Object e) {
            return ((Diff.Entry)e).left;
        }

        @Override
        public Object diff_entry_r(Object e) {
            return ((Diff.Entry)e).right;
        }

        @Override
        public Object diff_map_new() {
            return new Diff.Map();
        }

        @Override
        public Set diff_map_keys(Object o) {
            return ((Diff.Map)o).keySet();
        }

        @Override
        public boolean diff_map_has(Object m, Object k) {
            return ((Diff.Map)m).containsKey(k);
        }

        @Override
        public Object diff_map_get(Object m, Object k) {
            return ((Diff.Map)m).get(k);
        }

        @Override
        public void diff_map_put(Object m, Object k, Object e) {
            ((Diff.Map)m).put(k, (Diff.Entry)e);
        }

        @Override
        public Object diff_seq_new(boolean text) {
            return new Diff.Seq(text);
        }

        @Override
        public void diff_seq_add(Object s, Hunk h) {
            ((Diff.Seq)s).add(h);
        }

        @Override
        public Iterator<Hunk> diff_seq_iterator(Object s) {
            return ((Diff.Seq)s).hunks.iterator();
        }

        @Override
        public Object diff_null_new() {
            return null;
        }
    };

    public static Object diff(Object l, Object r) throws IOException {
        return new Differ(DIFF, OBJECT).diff(l, r);
    }

    public static Object applyForward(Object left, Object diff) throws IOException {
        return new Differ(DIFF, OBJECT).apply(left, diff, true);
    }

    public static Object applyBackward(Object right, Object diff) throws IOException {
        return new Differ(DIFF, OBJECT).apply(right, diff, false);
    }

    public static ObjectMarshaller newMarshaller(Writer w) {
        return new ObjectMarshaller(OBJECT, w);
    }

    public static ObjectUnmarshaller newUnmarshaller(Reader r) throws IOException {
        return new ObjectUnmarshaller(new Lexer(r), OBJECT);
    }

    public static ObjectUnmarshaller newUnmarshaller(String s) throws IOException {
        return UDON.newUnmarshaller(new StringReader(s));
    }

    public static void prettyPrint(Writer w, Object o) throws IOException {
        new ObjectPrettyPrinter(OBJECT, w).marshal(o);
    }

    public static String prettyPrint(Object o) {
        StringWriter w = new StringWriter();
        try {
            new ObjectPrettyPrinter(OBJECT, w).marshal(o);
        }
        catch (IOException e) {
            throw new Error("Could not serialise complete serialisation: " + w.toString(), e);
        }
        return w.toString();
    }

    public static String prettyPrintSafe(Object o) {
        StringWriter w = new StringWriter();
        try {
            new ObjectPrettyPrinter(OBJECT, w).marshal(o);
        }
        catch (IOException e) {
            return "Could not serialise complete serialisation: " + e.getMessage() + ":\n" + w.toString();
        }
        return w.toString();
    }

    public static String marshal(Object o) {
        try {
            StringWriter w = new StringWriter();
            UDON.newMarshaller(w).marshal(o);
            return w.toString();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static String marshalBraceless(Object o) {
        try {
            StringWriter w = new StringWriter();
            UDON.newMarshaller(w).objectInner(o);
            return w.toString();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static String marshalDiff(Object o) {
        try {
            StringWriter w = new StringWriter();
            new DiffMarshaller(DIFF, new ObjectMarshaller(OBJECT, w), w).marshal(o);
            return w.toString();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static Object unmarshal(InputStream is) throws IOException {
        return UDON.unmarshal(new InputStreamReader(is));
    }

    public static Object unmarshal(Reader r) throws IOException {
        return UDON.newUnmarshaller(r).unmarshal();
    }

    public static Object unmarshalInner(String s) throws IOException {
        return UDON.newUnmarshaller(s).unmarshal();
    }

    public static Object unmarshal(String s) throws UDONException {
        try {
            return UDON.newUnmarshaller(s).unmarshal();
        }
        catch (UDONException e) {
            throw new UDONException("Unable to parse: " + s, e);
        }
        catch (IOException e) {
            throw new Error("Unable to parse: " + s + "\n" + e.getMessage());
        }
    }

    public static Object unmarshalSafe(String s) {
        try {
            return UDON.newUnmarshaller(s).unmarshal();
        }
        catch (IOException e) {
            throw new Error("Unable to parse: " + s + "\n" + e.getMessage());
        }
    }

    public static Object unmarshalBraceless(String s) throws IOException {
        return UDON.newUnmarshaller(s).objectBraceless();
    }

    public static Object unmarshalDiff(String s) throws IOException {
        Lexer l = new Lexer(s);
        return new DiffUnmarshaller(l, DIFF, new ObjectUnmarshaller(l, OBJECT)).unmarshal();
    }

    public static Object deepCopy(Object o) {
        return OBJECT.deepCopy(o);
    }

    public static Object unmarshalOrdered(String s) throws IOException {
        return UDON.unmarshal(s);
    }

    public static class Diff {

        public static class Entry {
            private final Object left;
            private final Object right;

            public Entry(Object left, Object right) {
                this.left = left;
                this.right = right;
            }

            public boolean hasLeft() {
                return this.left != Differ.NONE;
            }

            public boolean hasRight() {
                return this.right != Differ.NONE;
            }

            public Object left() {
                if (!this.hasLeft()) {
                    return Differ.NONE;
                }
                return this.left;
            }

            public Object right() {
                if (!this.hasRight()) {
                    return Differ.NONE;
                }
                return this.right;
            }
        }

        public static class Map
        extends HashMap<Object, Entry> {
        }

        public static class Seq {
            final boolean text;
            public final List<Hunk> hunks = new LinkedList<Hunk>();

            public Seq(boolean text) {
                this.text = text;
            }

            public void add(Hunk hunk) {
                this.hunks.add(hunk);
            }
        }
    }
}

