/*
 * Decompiled with CFR 0.152.
 */
package udon.diff;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import udon.diff.DiffBase;
import udon.diff.DiffFormat;
import udon.diff.DiffType;
import udon.diff.Differ;
import udon.diff.Hunk;
import udon.object.ObjectMarshaller;

public class DiffMarshaller
extends DiffBase {
    final Writer writer;
    final ObjectMarshaller obj;

    public DiffMarshaller(DiffFormat format, ObjectMarshaller obj, Writer writer) {
        super(format);
        this.obj = obj;
        this.writer = writer;
    }

    public void marshal(Object o) throws IOException {
        if (o == null) {
            this.writer.write("null");
            return;
        }
        DiffType t = this.diffType(o);
        switch (t) {
            case Entry: {
                Object none = Differ.NONE;
                Object l = this.de_l(o);
                Object r = this.de_r(o);
                if (l != none) {
                    this.writer.write("<");
                    this.obj.marshal(l);
                }
                if (r == none) break;
                this.writer.write(">");
                this.obj.marshal(r);
                break;
            }
            case Map: {
                this.writer.append('{');
                boolean first = true;
                Iterator I = this.dm_keys(o).iterator();
                while (I.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        this.writer.append(',');
                    }
                    Object k = I.next();
                    this.obj.key(k);
                    this.writer.append(':');
                    Object v = this.dm_get(o, k);
                    this.marshal(v);
                }
                this.writer.append('}');
                break;
            }
            case List: 
            case Text: {
                Iterator<Hunk> I = this.ds_iterator(o);
                while (I.hasNext()) {
                    Hunk h = I.next();
                    this.writer.write("" + h.leftStart);
                    if (h.hasLeftRange()) {
                        this.writer.write("," + h.leftEnd);
                    }
                    this.writer.write(h.type);
                    this.writer.write("" + h.rightStart);
                    if (h.hasRightRange()) {
                        this.writer.write("," + h.rightEnd);
                    }
                    if (h.type != '>') {
                        this.obj.marshal(h.left);
                    }
                    if (h.type == 'x') {
                        this.writer.write(44);
                    }
                    if (h.type == '<') continue;
                    this.obj.marshal(h.right);
                }
                break;
            }
            default: {
                throw new RuntimeException("Not supported: " + (Object)((Object)t));
            }
        }
    }
}

