/*
 * Decompiled with CFR 0.152.
 */
package udon.diff;

import java.io.IOException;
import udon.diff.DiffFormat;
import udon.diff.Differ;
import udon.diff.Hunk;
import udon.object.ObjectUnmarshaller;
import udon.util.AbstractUnmarshaller;
import udon.util.Lexer;

public class DiffUnmarshaller
extends AbstractUnmarshaller {
    final DiffFormat format;
    final ObjectUnmarshaller obj;

    public DiffUnmarshaller(Lexer lexer, DiffFormat format, ObjectUnmarshaller obj) throws IOException {
        super(lexer);
        this.format = format;
        this.obj = obj;
    }

    public Object unmarshal() throws IOException {
        return this.diff();
    }

    public Object diff() throws IOException {
        this.white();
        Object r = this.diff_();
        this.white();
        return r;
    }

    public Object diff_() throws IOException {
        Object l = Differ.NONE;
        switch (this.ch()) {
            case 123: {
                return this.map();
            }
            case 60: {
                this.next();
                l = this.obj.value();
            }
            case 62: {
                this.next();
                Object r = this.obj.value();
                return this.format.diff_entry_new(l, r);
            }
        }
        if (this.isDigit()) {
            return this.sequence();
        }
        return this.word();
    }

    Object word() throws IOException {
        switch (this.ch()) {
            case 110: {
                this.next('n');
                this.next('u');
                this.next('l');
                this.next('l');
                return this.format.diff_null_new();
            }
        }
        throw this.e("Unexpected '" + (char)this.ch() + "'");
    }

    Object map() throws IOException {
        Object map = this.format.diff_map_new();
        this.next('{');
        this.white();
        if (this.ch() == 125) {
            throw this.e("Diff map empty.");
        }
        while (true) {
            Object key = this.obj.key();
            this.white();
            this.next(':');
            if (this.format.diff_map_has(map, key)) {
                throw this.e("Duplicate key '" + key + "'");
            }
            this.format.diff_map_put(map, key, this.diff());
            this.white();
            if (this.ch() == 125) {
                this.next('}');
                return map;
            }
            this.next(',');
            this.white();
        }
    }

    public int lineNumber() throws IOException {
        StringBuilder sb = new StringBuilder(4);
        this.obj.digits(sb);
        return Integer.parseInt(sb.toString());
    }

    public Hunk hunkRange() throws IOException {
        int rightEnd;
        int leftEnd;
        int leftStart = this.lineNumber();
        if (this.ch() == 44) {
            this.next();
            leftEnd = this.lineNumber();
        } else {
            leftEnd = leftStart;
        }
        char type = (char)this.ch();
        if (type != '<' && type != '>' && type != '~') {
            throw this.e("Expected '>','<' or '~', got '" + type);
        }
        this.next();
        int rightStart = this.lineNumber();
        if (this.ch() == 44) {
            this.next();
            rightEnd = this.lineNumber();
        } else {
            rightEnd = rightStart;
        }
        return new Hunk(leftStart, leftEnd, type, rightStart, rightEnd);
    }

    public Object sequence() throws IOException {
        Hunk first = this.hunkRange();
        this.white();
        if (this.ch() != 34 && this.ch() != 91) {
            throw this.e("Expected '\"' or '['");
        }
        boolean text = this.ch() == 34;
        Object seq = this.format.diff_seq_new(text);
        this.sequenceCont(seq, text, first);
        this.white();
        while (this.isDigit()) {
            Hunk h = this.hunkRange();
            this.sequenceCont(seq, text, h);
            this.white();
        }
        return seq;
    }

    Object sequenceData(boolean text) throws IOException {
        return text ? this.obj.string() : this.obj.array();
    }

    public void sequenceCont(Object seq, boolean text, Hunk h) throws IOException {
        switch (h.type) {
            case '<': {
                h.left = this.sequenceData(text);
                break;
            }
            case '>': {
                h.right = this.sequenceData(text);
                break;
            }
            case 'x': {
                h.left = this.sequenceData(text);
                this.white();
                this.next(',');
                this.white();
                h.right = this.sequenceData(text);
                break;
            }
            default: {
                throw this.e("not a hunk type: " + h.type);
            }
        }
        this.format.diff_seq_add(seq, h);
    }
}

