/*
 * Decompiled with CFR 0.152.
 */
package udon.diff;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;
import udon.diff.DiffFormat;
import udon.diff.DiffType;
import udon.diff.Hunk;
import udon.object.ObjectFormat;
import udon.object.ObjectType;

public class Differ {
    public static final Object NONE = new Object();
    final ObjectFormat obj;
    final DiffFormat diff;

    public Differ(DiffFormat diff, ObjectFormat obj) {
        this.diff = diff;
        this.obj = obj;
    }

    private static String join(String[] arr, int start, int end) {
        int l = 1;
        int i = start;
        while (i < end) {
            l += arr[i].length() + 1;
            ++i;
        }
        StringBuffer sb = new StringBuffer(l);
        int i2 = start;
        while (i2 < end) {
            if (i2 > start) {
                sb.append("\n");
            }
            sb.append(arr[i2]);
            ++i2;
        }
        return sb.toString();
    }

    private static String join(List<String> list) {
        int l = 0;
        for (String s : list) {
            l += s.length() + 1;
        }
        StringBuffer sb = new StringBuffer(l);
        Iterator<String> I = list.iterator();
        if (I.hasNext()) {
            sb.append(I.next());
        }
        while (I.hasNext()) {
            sb.append("\n");
            sb.append(I.next());
        }
        return sb.toString();
    }

    private List<String> stringList(Object o) {
        String[] ss = this.s_toString(o).split("\n");
        LinkedList<String> list = new LinkedList<String>();
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s);
            ++n2;
        }
        return list;
    }

    public Object diff(Object a, Object b) {
        ObjectType t_b;
        if (a == NONE || b == NONE) {
            return this.de_new(a, b);
        }
        ObjectType t_a = this.objectType(a);
        if (t_a == (t_b = this.objectType(b))) {
            ObjectType t = t_a;
            switch (t) {
                case Map: {
                    Object diffs = this.dm_new();
                    HashSet keys = new HashSet();
                    keys.addAll(this.o_keys(a));
                    keys.addAll(this.o_keys(b));
                    for (Object k : keys) {
                        Object vb;
                        Object va = this.o_has(a, k) ? this.o_get(a, k) : NONE;
                        Object vdiff = this.diff(va, vb = this.o_has(b, k) ? this.o_get(b, k) : NONE);
                        if (vdiff == null) continue;
                        this.o_put(diffs, k, vdiff);
                    }
                    if (this.o_size(diffs) > 0) {
                        return diffs;
                    }
                    return null;
                }
                case Array: {
                    List l_a = (List)a;
                    List l_b = (List)b;
                    List diffs = new Diff(l_a, l_b).diff();
                    if (diffs.size() == 0) {
                        return null;
                    }
                    Object seq = this.ds_new(false);
                    for (Difference d : diffs) {
                        Hunk h = new Hunk(d);
                        if (h.hasLeft()) {
                            h.left = l_a.subList(d.getDeletedStart(), d.getDeletedEnd() + 1);
                        }
                        if (h.hasRight()) {
                            h.right = l_b.subList(d.getAddedStart(), d.getAddedEnd() + 1);
                        }
                        this.ds_add(seq, h);
                    }
                    return seq;
                }
                case String: {
                    Object[] s_a = this.s_toString(a).split("\n");
                    Object[] s_b = this.s_toString(b).split("\n");
                    if (s_a.length < 2 && s_b.length < 2) break;
                    List diffs = new Diff(s_a, s_b).diff();
                    Object seq = this.ds_new(true);
                    for (Difference d : diffs) {
                        Hunk h = new Hunk(d);
                        if (h.hasLeft()) {
                            h.left = Differ.join((String[])s_a, d.getDeletedStart(), d.getDeletedEnd() + 1);
                        }
                        if (h.hasRight()) {
                            h.right = Differ.join((String[])s_b, d.getAddedStart(), d.getAddedEnd() + 1);
                        }
                        this.ds_add(seq, h);
                    }
                    return seq;
                }
            }
        }
        if (this.obj.dataEqual(a, b)) {
            return null;
        }
        return this.de_new(a, b);
    }

    public RuntimeException e(String msg) {
        throw new RuntimeException(msg);
    }

    public Object apply(Object o, Object diff, boolean forward) {
        if (diff == null) {
            return o;
        }
        DiffType dt = this.diffType(diff);
        switch (dt) {
            case Entry: {
                return forward ? this.de_r(diff) : this.de_l(diff);
            }
            case Map: {
                for (Object k : this.dm_keys(diff)) {
                    Object v = this.o_has(o, k) ? this.o_get(o, k) : NONE;
                    Object vdiff = this.dm_get(diff, k);
                    if ((v = this.apply(v, vdiff, forward)) == NONE) {
                        this.o_remove(o, k);
                        continue;
                    }
                    this.o_put(o, k, v);
                }
                return o;
            }
            case List: {
                LinkedList list = new LinkedList((List)o);
                Iterator<Hunk> I = this.ds_iterator(diff);
                int correction = 0;
                while (I.hasNext()) {
                    Hunk h = I.next();
                    if (forward ? h.hasLeft() : h.hasRight()) {
                        int delStart = forward ? h.leftStart : h.rightStart;
                        int delEnd = forward ? h.leftEnd : h.rightEnd;
                        int delLength = delEnd - delStart + 1;
                        int i = 0;
                        while (i < delLength) {
                            list.remove(delStart + correction);
                            ++i;
                        }
                        correction -= delLength;
                    }
                    if (!(forward ? h.hasRight() : h.hasLeft())) continue;
                    int addStart = forward ? h.rightStart : h.leftStart;
                    int addEnd = forward ? h.rightEnd : h.leftEnd;
                    int addLength = addEnd - addStart + 1;
                    Object addO = forward ? h.right : h.left;
                    List addList = addO == NONE ? Collections.EMPTY_LIST : (List)addO;
                    list.addAll(addStart, addList);
                    correction += addLength;
                }
                return this.a_new(list);
            }
            case Text: {
                List<String> list = this.stringList(o);
                Iterator<Hunk> I = this.ds_iterator(diff);
                int correction = 0;
                while (I.hasNext()) {
                    Hunk h = I.next();
                    if (forward ? h.hasLeft() : h.hasRight()) {
                        int delStart = forward ? h.leftStart : h.rightStart;
                        int delEnd = forward ? h.leftEnd : h.rightEnd;
                        int delLength = delEnd - delStart + 1;
                        int i = 0;
                        while (i < delLength) {
                            list.remove(delStart + correction);
                            ++i;
                        }
                        correction -= delLength;
                    }
                    if (!(forward ? h.hasRight() : h.hasLeft())) continue;
                    int addStart = forward ? h.rightStart : h.leftStart;
                    int addEnd = forward ? h.rightEnd : h.leftEnd;
                    int addLength = addEnd - addStart + 1;
                    Object addO = forward ? h.right : h.left;
                    List<String> addList = addO == NONE ? Collections.EMPTY_LIST : this.stringList(addO);
                    list.addAll(addStart, addList);
                    correction += addLength;
                }
                return Differ.join(list);
            }
        }
        throw new Error();
    }

    public ObjectType objectType(Object o) {
        return this.obj.objectType(o);
    }

    public Object b_new(boolean b) {
        return this.obj.boolean_new(b);
    }

    public boolean b_toBoolean(Object b) {
        return this.obj.boolean_toBoolean(b);
    }

    public Object null_new() {
        return this.obj.null_new();
    }

    public Object n_new(String s) {
        return this.obj.number_new(s);
    }

    public Object n_newInteger(String s) {
        return this.obj.number_newInteger(s);
    }

    public String n_toString(Object o) {
        return this.obj.number_toString(o);
    }

    public Object s_new(String s) {
        return this.obj.string_new(s);
    }

    public String s_toString(Object o) {
        return this.obj.string_toString(o);
    }

    public Object o_get(Object o, Object k) {
        return this.obj.object_get(o, k);
    }

    public boolean o_has(Object o, Object k) {
        return this.obj.object_has(o, k);
    }

    public Set o_keys(Object o) {
        return this.obj.object_keys(o);
    }

    public Object o_new() {
        return this.obj.object_new();
    }

    public void o_put(Object o, Object k, Object v) {
        this.obj.object_put(o, k, v);
    }

    public void o_remove(Object o, Object k) {
        this.obj.object_remove(o, k);
    }

    public int o_size(Object o) {
        return this.obj.object_size(o);
    }

    public void a_add(Object o, Object v) {
        this.obj.array_add(o, v);
    }

    public Object a_get(Object o, int i) {
        return this.obj.array_get(o, i);
    }

    public int a_length(Object o) {
        return this.obj.array_length(o);
    }

    public Object a_new() {
        return this.obj.array_new();
    }

    public Object a_new(List l) {
        return this.obj.array_new(l);
    }

    public DiffType diffType(Object o) {
        return this.diff.diffType(o);
    }

    public Object de_new(Object a, Object b) {
        return this.diff.diff_entry_new(a, b);
    }

    public Object de_l(Object e) {
        return this.diff.diff_entry_l(e);
    }

    public Object de_r(Object e) {
        return this.diff.diff_entry_r(e);
    }

    public Object dm_new() {
        return this.diff.diff_map_new();
    }

    public Set dm_keys(Object o) {
        return this.diff.diff_map_keys(o);
    }

    public boolean dm_has(Object o, Object k) {
        return this.diff.diff_map_has(o, k);
    }

    public Object dm_get(Object o, Object k) {
        return this.diff.diff_map_get(o, k);
    }

    public void dm_put(Object o, Object k, Object e) {
        this.diff.diff_map_put(o, k, e);
    }

    public Object ds_new(boolean text) {
        return this.diff.diff_seq_new(text);
    }

    public void ds_add(Object s, Hunk h) {
        this.diff.diff_seq_add(s, h);
    }

    public Iterator<Hunk> ds_iterator(Object s) {
        return this.diff.diff_seq_iterator(s);
    }
}

