/*
 * Decompiled with CFR 0.152.
 */
package udon.object;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import udon.object.ObjectBase;
import udon.object.ObjectFormat;
import udon.object.ObjectType;

public class ObjectMarshaller
extends ObjectBase {
    final Writer writer;

    public ObjectMarshaller(ObjectFormat obj, Writer writer) {
        super(obj);
        this.writer = writer;
    }

    public void arrayStart() throws IOException {
        this.writer.append('[');
    }

    public void arrayEnd() throws IOException {
        this.writer.append(']');
    }

    public void objectStart() throws IOException {
        this.writer.append('{');
    }

    public void objectEnd() throws IOException {
        this.writer.append('}');
    }

    public void objectEntry(Object k, Object v) throws IOException {
        this.key(k);
        this.writer.append(':');
        this.marshal(v);
    }

    public void marshal(Object o) throws IOException {
        ObjectType t = this.objectType(o);
        switch (t) {
            case Null: {
                this.writer.write("null");
                break;
            }
            case Bool: {
                this.writer.write(this.b_toBoolean(o) ? "true" : "false");
                break;
            }
            case String: {
                this.writer.write(ObjectMarshaller.escape(this.s_toString(o)));
                break;
            }
            case Number: {
                this.writer.write(this.n_toString(o));
                break;
            }
            case Array: {
                this.arrayStart();
                int l = this.a_length(o);
                int i = 0;
                while (i < l) {
                    if (i > 0) {
                        this.writer.append(',');
                    }
                    Object el = this.a_get(o, i);
                    this.marshal(el);
                    ++i;
                }
                this.arrayEnd();
                break;
            }
            case Map: {
                this.objectStart();
                this.objectInner(o);
                this.objectEnd();
                break;
            }
            case Binary: {
                throw new RuntimeException("Not supported");
            }
        }
    }

    public void objectInner(Object o) throws IOException {
        boolean first = true;
        Iterator I = this.o_keys(o).iterator();
        while (I.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.writer.append(',');
            }
            Object k = I.next();
            Object v = this.o_get(o, k);
            this.objectEntry(k, v);
        }
    }

    public void key(Object o) throws IOException {
        String k = this.s_toString(o);
        this.writer.write(ObjectMarshaller.escape(k));
    }

    static String escape(String s) {
        StringBuffer sb = new StringBuffer(s.length() + 1 + s.length() / 16);
        sb.append("\"");
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        int k = 0;
                        while (k < 4 - ss.length()) {
                            sb.append('0');
                            ++k;
                        }
                        sb.append(ss.toUpperCase());
                        break;
                    }
                    sb.append(ch);
                }
            }
            ++i;
        }
        sb.append("\"");
        return sb.toString();
    }
}

