/*
 * Decompiled with CFR 0.152.
 */
package udon.object;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.TreeSet;
import udon.object.ObjectFormat;
import udon.object.ObjectMarshaller;
import udon.object.ObjectType;

public class ObjectPrettyPrinter
extends ObjectMarshaller {
    private int indent = 0;

    public ObjectPrettyPrinter(ObjectFormat obj, Writer writer) {
        super(obj, writer);
    }

    private void indent() throws IOException {
        this.writer.append("\n");
        int i = 0;
        while (i < this.indent) {
            this.writer.append("    ");
            ++i;
        }
    }

    private void write(String s) throws IOException {
        this.writer.append(s);
    }

    @Override
    public void marshal(Object o) throws IOException {
        ObjectType t = this.objectType(o);
        switch (t) {
            case Null: {
                this.write("null");
                break;
            }
            case Bool: {
                this.write(this.b_toBoolean(o) ? "true" : "false");
                break;
            }
            case String: {
                this.write(ObjectPrettyPrinter.escape(this.s_toString(o)));
                break;
            }
            case Number: {
                this.write(this.n_toString(o));
                break;
            }
            case Array: {
                int l = this.a_length(o);
                if (l == 0) {
                    this.write("[]");
                    break;
                }
                this.write("[");
                ++this.indent;
                int i = 0;
                while (i < l) {
                    if (i > 0) {
                        this.writer.append(',');
                    }
                    this.indent();
                    Object el = this.a_get(o, i);
                    this.marshal(el);
                    ++i;
                }
                --this.indent;
                this.indent();
                this.write("]");
                break;
            }
            case Map: {
                if (this.o_keys(o).size() == 0) {
                    this.write("{}");
                    break;
                }
                this.write("{");
                ++this.indent;
                this.objectInner(o);
                --this.indent;
                this.indent();
                this.write("}");
                break;
            }
            case Binary: {
                throw new RuntimeException("Not supported");
            }
        }
    }

    @Override
    public void objectInner(Object o) throws IOException {
        boolean first = true;
        Iterator I = new TreeSet(this.o_keys(o)).iterator();
        while (I.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.writer.append(',');
            }
            this.indent();
            Object k = I.next();
            this.key(k);
            this.writer.append(": ");
            Object v = this.o_get(o, k);
            this.marshal(v);
        }
    }

    @Override
    public void key(Object o) throws IOException {
        String k = this.s_toString(o);
        this.write(ObjectPrettyPrinter.escape(k));
    }
}

