/*
 * Decompiled with CFR 0.152.
 */
package udon.object;

import java.io.IOException;
import udon.object.ObjectFormat;
import udon.util.AbstractUnmarshaller;
import udon.util.Lexer;

public class ObjectUnmarshaller
extends AbstractUnmarshaller {
    final ObjectFormat obj;

    public ObjectUnmarshaller(Lexer lexer, ObjectFormat obj) {
        super(lexer);
        this.obj = obj;
    }

    public Object unmarshal() throws IOException {
        Object r = this.value();
        if (this.ch() != -1) {
            throw this.e("Expected end, got " + (char)this.ch());
        }
        return r;
    }

    Object numberExp(StringBuilder sb) throws IOException {
        sb.append((char)this.ch());
        this.next();
        if (this.ch() == 45 || this.ch() == 43) {
            sb.append((char)this.ch());
            this.next();
        }
        this.digits(sb);
        return this.obj.number_new(sb.toString());
    }

    public void digits(StringBuilder sb) throws IOException {
        while (this.isDigit()) {
            sb.append((char)this.ch());
            this.next();
        }
    }

    Object number() throws IOException {
        StringBuilder sb = new StringBuilder(20);
        if (this.ch() == 45) {
            sb.append('-');
            this.next('-');
        }
        this.digits(sb);
        if (this.ch() == 46) {
            sb.append('.');
            this.next();
            this.digits(sb);
            if (this.ch() == 101 || this.ch() == 69) {
                return this.numberExp(sb);
            }
            return this.obj.number_new(sb.toString());
        }
        if (this.ch() == 101 || this.ch() == 69) {
            return this.numberExp(sb);
        }
        return this.obj.number_newInteger(sb.toString());
    }

    public Object value() throws IOException {
        this.white();
        Object r = this.value_();
        this.white();
        return r;
    }

    public Object value_() throws IOException {
        switch (this.ch()) {
            case 123: {
                return this.object();
            }
            case 91: {
                return this.array();
            }
            case 34: {
                return this.string();
            }
            case 45: {
                return this.number();
            }
        }
        return this.isDigit() ? this.number() : this.word();
    }

    Object word() throws IOException {
        switch (this.ch()) {
            case 116: {
                this.next('t');
                this.next('r');
                this.next('u');
                this.next('e');
                return this.obj.boolean_new(true);
            }
            case 102: {
                this.next('f');
                this.next('a');
                this.next('l');
                this.next('s');
                this.next('e');
                return this.obj.boolean_new(false);
            }
            case 110: {
                this.next('n');
                this.next('u');
                this.next('l');
                this.next('l');
                return this.obj.null_new();
            }
        }
        throw this.e("Unexpected '" + (char)this.ch() + "'");
    }

    int hexDigit() throws IOException {
        this.next();
        switch (this.ch()) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 97: {
                return 10;
            }
            case 98: {
                return 11;
            }
            case 99: {
                return 12;
            }
            case 100: {
                return 13;
            }
            case 101: {
                return 14;
            }
            case 102: {
                return 15;
            }
        }
        return -1;
    }

    char escapedChar() throws IOException {
        this.next();
        switch (this.ch()) {
            case 117: {
                int uffff = 0;
                int i = 0;
                while (i < 4) {
                    int hex = this.hexDigit();
                    if (hex == -1) break;
                    uffff = uffff * 16 + hex;
                    ++i;
                }
                return (char)uffff;
            }
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)this.ch();
            }
        }
        throw this.e("Invalid escape char: " + this.ch());
    }

    public String string_() throws IOException {
        StringBuffer sb = new StringBuffer();
        this.next('\"');
        if (34 == this.ch()) {
            this.next();
            if (34 == this.ch()) {
                this.next();
                while (true) {
                    if (this.ch() == 92) {
                        sb.append(this.escapedChar());
                    } else {
                        sb.append((char)this.ch());
                    }
                    this.next();
                    if (34 != this.ch()) continue;
                    this.next();
                    if (34 == this.ch()) {
                        this.next();
                        if (34 == this.ch()) {
                            this.next();
                            return sb.toString();
                        }
                        sb.append('\"');
                    }
                    sb.append('\"');
                }
            }
            return "";
        }
        while (true) {
            if (this.ch() == 34) {
                this.next();
                return sb.toString();
            }
            if (this.ch() == 92) {
                sb.append(this.escapedChar());
            } else {
                sb.append((char)this.ch());
            }
            this.next();
        }
    }

    public Object string() throws IOException {
        return this.obj.string_new(this.string_());
    }

    public Object key() throws IOException {
        if (this.ch() == 34) {
            return this.string();
        }
        return this.obj.string_new(this.key_());
    }

    String key_() throws IOException {
        StringBuffer sb = new StringBuffer();
        if (!Character.isJavaIdentifierPart(this.ch())) {
            throw this.e("Cannot start unquoted key with: " + (char)this.ch());
        }
        sb.append((char)this.ch());
        while (true) {
            this.next();
            if (!Character.isJavaIdentifierPart(this.ch())) {
                return sb.toString();
            }
            sb.append((char)this.ch());
        }
    }

    public Object array() throws IOException {
        Object array = this.obj.array_new();
        this.next('[');
        this.white();
        if (this.ch() == 93) {
            this.next(']');
            return array;
        }
        do {
            this.obj.array_add(array, this.value());
            if (this.ch() == 93) {
                this.next(']');
                return array;
            }
            this.next(',');
            this.white();
        } while (this.ch() != 93);
        this.next(']');
        return array;
    }

    private Object objectInner(int last) throws IOException {
        Object object = this.obj.object_new();
        this.white();
        if (this.ch() == last) {
            return object;
        }
        while (true) {
            Object key = this.key();
            this.white();
            this.next(':');
            if (this.obj.object_has(object, key)) {
                throw this.e("Duplicate key '" + key + "'");
            }
            this.obj.object_put(object, key, this.value());
            this.white();
            if (this.ch() == last) {
                return object;
            }
            this.next(',');
            this.white();
        }
    }

    public Object object() throws IOException {
        this.next('{');
        Object object = this.objectInner(125);
        this.next('}');
        return object;
    }

    public Object objectBraceless() throws IOException {
        return this.objectInner(-1);
    }
}

