/*
 * Decompiled with CFR 0.152.
 */
package udon.util;

import java.io.IOException;
import udon.util.Lexer;
import udon.util.UDONException;

public abstract class AbstractUnmarshaller {
    protected final Lexer lexer;

    protected AbstractUnmarshaller(Lexer lexer) {
        this.lexer = lexer;
    }

    protected UDONException e(String msg) {
        return this.lexer.e(msg);
    }

    protected void next() throws IOException {
        this.lexer.next();
    }

    protected void next(char c) throws IOException {
        this.lexer.next(c);
    }

    protected void white() throws IOException {
        while (true) {
            if (this.ch() == 47) {
                this.comment();
            } else if (!Character.isWhitespace(this.ch())) {
                return;
            }
            this.next();
        }
    }

    protected int ch() {
        return this.lexer.ch;
    }

    public boolean isDigit() {
        return this.ch() >= 48 && this.ch() <= 57;
    }

    private void comment() throws IOException {
        this.next('/');
        this.next('*');
        int col0 = this.lexer.col;
        int row0 = this.lexer.row;
        while (true) {
            if (this.ch() == -1) {
                throw new UDONException("Unclosed comment", row0, col0);
            }
            if (this.ch() == 42) {
                this.next();
                if (this.ch() == 47) {
                    return;
                }
            }
            this.next();
        }
    }
}

