/*
 * Decompiled with CFR 0.152.
 */
package udon.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import udon.util.UDONException;

public class Lexer {
    protected final Reader reader;
    protected int ch;
    protected int row;
    protected int col;

    public Lexer(Reader reader) throws IOException {
        this.reader = reader;
        this.row = 1;
        this.col = 0;
        this.next();
    }

    public Lexer(String s) throws IOException {
        this(new StringReader(s));
    }

    protected UDONException e(String msg) {
        return new UDONException(msg, this.row, this.col);
    }

    protected void next() throws IOException {
        int r;
        this.ch = r = this.reader.read();
        if (this.ch == 10) {
            ++this.row;
            this.col = 1;
        } else {
            ++this.col;
        }
    }

    protected void next(char c) throws IOException {
        if (this.ch != c) {
            throw this.e("Expected '" + c + "', got '" + (char)this.ch + "'");
        }
        this.next();
    }

    protected void white() throws IOException {
        while (Character.isWhitespace(this.ch)) {
            this.next();
        }
    }
}

