/*
 * Decompiled with CFR 0.152.
 */
package udon.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.TreeSet;
import udon.UDON;
import udon.diff.Hunk;
import udon.object.ObjectBase;
import udon.object.ObjectType;

public class UDONUtil {
    public static String marshalFlat(Object o) {
        try {
            StringWriter sw = new StringWriter();
            new Flattener(sw).marshalFlat(null, o);
            return sw.toString();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static String formatSeq(UDON.Diff.Seq seq) {
        StringBuilder r = new StringBuilder();
        int i = 0;
        for (Hunk h : seq.hunks) {
            r.append("-----------hunk " + i++ + "-----------\n");
            if (h.hasLeft()) {
                r.append("<<< " + h.leftStart + "-" + h.leftEnd);
                r.append("\n");
                r.append(h.left);
                r.append("\n");
            }
            if (!h.hasRight()) continue;
            r.append(">>> " + h.rightStart + "-" + h.rightEnd);
            r.append("\n");
            r.append(h.right);
            r.append("\n");
        }
        return r.toString();
    }

    public static boolean assertFlatEquals(String what, Object a, Object b) {
        String sb;
        String sa = UDONUtil.marshalFlat(a);
        if (!sa.equals(sb = UDONUtil.marshalFlat(b))) {
            try {
                System.err.println("---Unequal: " + what + " ---");
                UDON.Diff.Seq seq = (UDON.Diff.Seq)UDON.diff(sa, sb);
                System.err.println(UDONUtil.formatSeq(seq));
                System.err.println("-------------");
            }
            catch (Exception e) {
                throw new Error("!Unequal", e);
            }
            return false;
        }
        return true;
    }

    public static class Flattener
    extends ObjectBase {
        final Writer writer;

        public Flattener(Writer writer) {
            super(UDON.OBJECT);
            this.writer = writer;
        }

        private void writeLine(String path, String value) throws IOException {
            this.writer.write(path);
            this.writer.write("=");
            this.writer.write(value);
            this.writer.write("\n");
        }

        private void marshalFlat(String path, Object o) throws IOException {
            ObjectType t = this.objectType(o);
            switch (t) {
                case Null: {
                    this.writeLine(path, "null");
                    break;
                }
                case Bool: {
                    this.writeLine(path, this.b_toBoolean(o) ? "true" : "false");
                    break;
                }
                case String: {
                    this.writeLine(path, this.s_toString(o));
                    break;
                }
                case Number: {
                    this.writeLine(path, this.n_toString(o));
                    break;
                }
                case Array: {
                    int l = this.a_length(o);
                    int i = 0;
                    while (i < l) {
                        Object el = this.a_get(o, i);
                        String path2 = path == null ? "" + i : String.valueOf(path) + "." + i;
                        this.marshalFlat(path2, el);
                        ++i;
                    }
                    break;
                }
                case Map: {
                    for (Object k : new TreeSet(this.o_keys(o))) {
                        Object v = this.o_get(o, k);
                        String path2 = path == null ? "" + k : String.valueOf(path) + "." + k;
                        this.marshalFlat(path2, v);
                    }
                    break;
                }
                case Binary: {
                    throw new RuntimeException("Not supported");
                }
            }
        }
    }
}

