package ebuild.api.common;

import java.util.HashMap;
import java.util.Map;

public class Scope implements Comparable<Scope> {
    static private Map<String,Scope> scopes = new HashMap();
    
    static final public Scope MAIN = new Scope(null,"main");
    static final public Scope POKE = new Scope(MAIN,"poke");
    static final public Scope TEST = new Scope(POKE,"test");

    static public Scope get(String name) {
        return scopes.get(name);
    }
    
    
    final private Scope parent;
    final private String name; 
    private Scope(Scope parent, String name){
        this.parent = parent;
        this.name = name;
        scopes.put(name,this);
    }
    
    public String getName() { return name; }
    public Scope getParent() { return parent; }

    public int hashCode() { return name.hashCode(); }
    public boolean equals(Object o) { 
        // SCOPE construction is private
        return this==o; 
    }
    public boolean includes(Scope scope) {
        if(equals(scope)) return true;
        if(parent==null) return false;
        return parent.includes(scope);
    }
    public int compareTo(Scope o) {
        return name.compareTo(o.name);
    }
    public String toString() { return name; }


 
}
