package ebuild.api;

import java.io.File;
import java.util.List;

import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.IPropertyMap;

public interface IBuilderArgument {
	public IEBuild getEBuild();
	public ILogger getLogger();
	public IPropertyMap getPropertyMap();
	public Scope getScope();
	public List<File> getInputDirs(String artifactType);
	public File getOutputDir(String artifactType);
	@Deprecated public File getIntermediateDir(String uniquePath);
	public IModuleBuildProject getModuleBuildProject();
	public boolean isFirstCall();
    public boolean isBuild();
}
