package ebuild.api;

import java.io.File;
import java.util.Collection;

import ebuild.api.plugin.BuildPluginProblem;


public interface IInputMap {
    public Collection<String> inputKeys();
    
    public IInput getInput(String name);
    public IInput expectInput(String name) throws BuildPluginProblem;
    public IInput expectLoneInput() throws BuildPluginProblem;
    
    
    @Deprecated public Collection<File> getArtifacts(String input);
    @Deprecated public Collection<File> getArtifacts(String input, Collection<File> default_);
    @Deprecated public Collection<File> expectArtifacts(String input) throws BuildPluginProblem;
    @Deprecated public Collection<File> expectArtifacts() throws BuildPluginProblem;
    
    @Deprecated public File expectLoneArtifact() throws BuildPluginProblem;
    @Deprecated public File expectLoneArtifactForInput(String input) throws BuildPluginProblem;
}
