package ebuild.api.plugin;

public interface IPropertyMap {

	public Iterable<String> listKeys();
	
    public void put(String key, Object value);

    public Object get(String key);
    
    public Boolean getBool(String key);
    public boolean getBool(String key, boolean default_);
    public boolean expectBool(String key) throws BuildPluginProblem;;
    
    public String getString(String key);
    public String getString(String key, String default_);
    public String expectString(String key) throws BuildPluginProblem;

    public<E extends Enum> E getEnum(Class<E> enumClass, String key) throws BuildPluginProblem;
    public<E extends Enum> E getEnum(Class<E> enumClass, String key, E default_) throws BuildPluginProblem;
    public<E extends Enum> E expectEnum(Class<E> enumClass, String key) throws BuildPluginProblem;

}
