package ebuild.api;

import java.io.File;
import java.util.Date;

import ebuild.api.common.IElementKey;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.IPropertyMap;

/** An instance of this class is passed as the argument for each run of an assembler, as specified in the product-assembly.xml.
 * 
 *  <assembler org="foo" name="bar" tag="xxx">
 *  	<input name="a">
 *  		....
 *  	</input>
 *  </assembler>
 *  
 **/
public interface IAssemblerArgument {
	
	public IEBuild getEBuild();	
	/** Log for the user-developer to see what the assembler is doing. Assemblers should indicate major steps being taken and
	 * output relevant warnings to aid with build debugging/understanding. */
	public ILogger getLogger();	
	/** Assembly can be configured via the property mechanism. In some instances an entire 'DSL' can be specified as a property.
	 * e.g. the build.file.layout  */
	public IPropertyMap getPropertyMap();
	/** Inputs are the results of other assemblers or a module selection or a reference to another product  */
	public IInputMap getInputMap();
	public File getOutputDirectory();
	
	/** Last commit date for the current revision of the product being assembeled. */
    public Date getLastCommitDate();

    /** EBuild element key for the current product. Useful e.g. to get version information.*/
    public IElementKey getProductKey();
    
    /**
     * <p><i>Advanced - this method is only not useful in particular circumstances.</i></p>  
     * 
     * <p>Ordinarily there is no name to give the assembled artifact anything other than a simple descriptive name
     * (e.g. the zip assembler could name the artifacts it produces artifact.zip). The assembled artifact, if it
     * is the end product of one of the public targets (i.e. corresponds to a released artifact) then it is renamed
     * by ebuild when it is released, after it has been assembled.</p>  
     * 
     * <p>However there is an exception. In some signing schemes (such as vexi) the file name is part of the input
     * to the signature - i.e. renaming the file is not allowed. In this case it is necessary that the artifact has
     * its final name when it is being signed.</p>
     **/
    public String getReleaseFileName();
}
