package ebuild.api;

import java.io.File;
import java.util.List;

import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.IPropertyMap;

/** An instance of this class is passed as the argument for each <i>build</i> run of a builder, as specified in the module-build.xml.  */
 
public interface IBuilderArgument {
	public IEBuild getEBuild();
	public ILogger getLogger();
    // SHOULD implement this 
	//public Map<String,String> getConfs();
    public IPropertyMap getPropertyMap();
	public Scope getScope();
	
	
	public List<File> getInputDirs(String artifactType);
	public File getIntermediateDir(String uniquePath);
	public File getOutputArtifact(String artifactType, boolean alwaysNamed);
	public IModuleBuildProject getModuleBuildProject();
	public boolean isFirstCall();
    public boolean isBuild();
}
