package ebuild.api;

import java.io.File;

public interface IEBuild {
	/** Access file in the credentials directory, necessary if step requires a password, since we 
	 * should not be storing credentials in source control. */
	public File getCredentialsFile(String path);
    public boolean isVerbose();
    /** Format a file path relative to the main ebuild directories (if applicable). This is principally to produce
     * less noisy log output. e.g. we may show files relative to the workspace.
     *    [workspace]/... 
     * */
    public String formatAsDisplayPath(File file);
    
    /** Get path relative to the workspace, if applicable */
	public String getPathInWorkspace(File file);
}
