package ebuild.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;

import ebuild.api.common.Scope;
import ebuild.api.eclipse.IEclipseProject;

// REMARK at a later stage we will perhaps split this up into general facilities
// and ones which are specific to a given IDE.
public interface IModuleWorkspaceProject extends IModuleProject{
	
	public void addIgnores(String... patterns);   
    
	public File getProjectFile(String path);
	public String readProjectFile(String path) throws IOException;
	public void writeProjectFile(String path, String text) throws IOException;
	
    public String getArtifactPath(String kind, Scope scope, String type);
      
    // REMARK ideally this would be decoupled and IDE handling would be plugable
    public IEclipseProject asEclipseProject();

    public File getCorespondingArtifactDependency(Scope scope, String artifactType, File artifact);
    
    /** Lists all the load groups. Loadgroups are named sets of runtime only dependencies. */
    public Collection<String> getLoadGroups(Scope scope);
    
    
    /** Returns all IDE project depenencies. Any dependencies which resolved to projects in the workspace.
     */
    public Collection<IModuleWorkspaceProject> getIDESetupProjectDependencies(Scope scope, String loadgroup);
    
    /** Returns artifacts which are used by the IDE project. Which means all 
     *  artifacts of dependencies not represented as projects in the workspace. 
     *  
     *  @param scope                scope of dependencies
     *  @param loadgroup            loadgroup of dependencies. Load group can, and usually will be null.
     *  @param artifact             artifact type
     *  @param passThroughProjects  if true, transitively include dependencies of workspace projcets.
     * */
    public Collection<File>                    getIDESetupArtifactDependencies(Scope scope, String loadgroup, String artifact);
}
