package ebuild.api.plugin;

import java.util.ArrayList;
import java.util.List;


abstract public class AbstractPropertyMap implements IPropertyMap {
    
    
    public String getString(String key) {
        Object o = get(key);
        if(o==null) return null;
        return o.toString();
    }
    public String getString(String key, String default_) {
        String r = getString(key);
        if(r==null) return default_;
        return r;
    }
    public String expectString(String key) throws BuildPluginProblem {
        String r = getString(key);
        if(r==null) {
        	List<String> props = new ArrayList();
        	for(String s: listKeys()) props.add(s);
        	throw new BuildPluginProblem("Expected string property '"+key+"'. Set props: "+join(",",props));
        }
        return r;
    }
    
    public Boolean getBool(String key) {
        String s = getString(key);
        if(s==null) return null;
        return parseBooleanTolerantly(s);
    }
    public boolean getBool(String key, boolean default_) {
        Boolean r = getBool(key);
        if(r==null) return default_;
        return r;
    }
    public boolean expectBool(String key) throws BuildPluginProblem {
        Boolean r = getBool(key);
        if(r==null) throw new BuildPluginProblem("Expected bool property '"+key+"'");
        return r;
    }
    
    public<E extends Enum> E getEnum(Class<E> enumClass, String key) throws BuildPluginProblem {
        String v = getString(key);
        if(v==null) return null;
        E[] es = enumClass.getEnumConstants();
        for(E e: es){
            if(v.equals(e.name())) return e;
        }
        throw new BuildPluginProblem("Expected one of '"+join(",", (Object[])enumClass.getEnumConstants())+"', got '"+v+"' for property '"+key+"'");
    }
    public<E extends Enum> E getEnum(Class<E> enumClass, String key, E default_) throws BuildPluginProblem {
        E r = getEnum(enumClass,key);
        if(r==null) return default_;
        return r;
    }
    public<E extends Enum> E expectEnum(Class<E> enumClass, String key) throws BuildPluginProblem {
        E r = getEnum(enumClass,key);
        if(r==null)  throw new BuildPluginProblem("Expected one of '"+join(",", (Object[])enumClass.getEnumConstants())+"' property '"+key+"'");
        return r;
    }
    
    
    static public String join(String separator, Object... os){
        int l = 0;
        for(Object o: os){
            String s = o.toString();
            l += (s==null?4:s.length())+1;
        }       
        StringBuffer r = new StringBuffer(l);
        for(Object o: os){
            String s = o.toString();
            if(r.length()>0)r.append(separator);
            r.append(s==null?"null":s);
        }
        return r.toString();
    }
    
	static private Boolean parseBooleanTolerantly(String string){
		if(string==null) return null;
		
		String s = string.toLowerCase();
		if("true".equals(s)) return true;
		if("yes".equals(s)) return true;
		if("false".equals(s)) return false;
		if("no".equals(s)) return false;
		return null;
	}
	
    
}
