package ebuild.api.repo;

import java.io.File;
import java.io.FileFilter;

import ebuild.api.common.IElementKey;

abstract public class AbstractSourceRepository implements IRepository {
	private String headRevision;
	final public String getHeadRevision() throws RepositoryPluginException{
		if(headRevision==null){
			headRevision = doGetHeadRevision();
		}
		return headRevision;
	}
	
	abstract protected String doGetHeadRevision() throws RepositoryPluginException;
	
	abstract public void fetchProject(File projectDir, IElementKey key) throws RepositoryPluginException;
	
	public FileFilter getFileFilter() { return null; }

}
