package ebuild.api.repo;

import java.io.File;
import java.io.FileFilter;
import java.util.List;

import ebuild.api.common.IElementKey;
import ebuild.api.common.IVersion;

abstract public class AbstractSourceRepository implements IRepository {
	
	abstract public FileFilter getFileFilter();
	
	abstract public int compareRevisions(String ra, String rb);
	
	////////////
	// REMARK these have become somewhat subversion specific. Will need revisiting, especially
	// when looking at how to do dvcs
	abstract public String fetchRevisionOfHead() throws RepositoryPluginException;
	abstract public String fetchRevisionOfBranchHead(IVersion branch) throws RepositoryPluginException;
	abstract public String fetchRevisionOfBranchCreation(IVersion branch) throws RepositoryPluginException;
	abstract public String fetchRevisionOfLastChange(IElementKey key) throws RepositoryPluginException;
	
	abstract public void fetchProject(File projectDir, IElementKey key) throws RepositoryPluginException;
	
	public Long fetchInstantOfBranchCreation(IVersion branch) throws RepositoryPluginException{ return Long.MIN_VALUE; }
	public long fetchInstantOfLastChange(IElementKey key) throws RepositoryPluginException{ return Long.MIN_VALUE; }
	
	
	
	abstract public List<String> listProjects(IVersion version) throws RepositoryPluginException;
}
